<?php

/**************************************************
Program name:	display_table_html.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	HTML for diplaying a PostgreSQL table.  
			
Create Date:	6/29/01 

Modified Date(s):
	
**************************************************/

if ($num_rows > 1) {  
	// print "Showing records 0 - 30 (237 total)" as an example
?>
	<?= "$strShowingRecords $pos - $pos_next ($num_rows $strTotal)";  ?>
<br>
	<!-- print navigation bar -->
	<?= $strNavigation; ?>

<? } ?>

<!--<br>"Your SQL Statement: "-->
<? //echo $sql_get; ?>
<br>
<!-- Build Table -->
<table border= <? echo $cfgBorder ; ?> width="100%">

	<!-- Print Row Headings -->
	<tr>
		<? // Loop through columns to print column names
		for ($j = 0; $j < $num_columns; $j++) { 
			// Print Field Name as a hyperlink if number of rows is great than 1
				if ($num_rows > 1) {
					$sort_order = urlencode(" ORDER BY $cfgQuotes$column_name[$j]$cfgQuotes");   ?>
					<th><a class=link hREF="sqlresults.php?server=<?=$server?>&db=<?=$db?>&pos=<?=$pos?>&sql_query=<?=urlencode($nsql_query)?>&sql_order=<?=$sort_order?>"><? echo $column_name[$j] ?></a></th>

				<? } else {  ?>
					<th><?echo $column_name[$j]; ?></th>
			<?	}
		}  ?>
	</tr>
	
	<!-- Print Data Rows -->

	<?	
	# Loop through rows of $sql_return and fetch rows
	for ($i = $pos; $i < $pos_next; $i++) {
		$return_row = pg_fetch_row($sql_return, $i);
		unset($primary_key);  //DAN - WHY
		$bgcolor = $cfgBgcolorOne;
		$i % 2  ? 0: $bgcolor = $cfgBgcolorTwo;
	?>
	<tr bgcolor=<?echo $bgcolor; ?>>
		
		<? # Loop through columns to data cell of each column in row.
		for ($j = 0; $j < $num_columns; $j++) { 
		
			if (!empty($return_row[$j])) {	# if else &nbsp;

			     # Print data cell based on column type
			   if (eregi("int|numeric", $column_type[$j])) { ?>
				
				<!-- INTEGER -->
				<td align=right valign=top><? echo $return_row[$j] ; ?></td>

			<? } elseif ($cfgShowBlob == false && eregi("BLOB", $column_type[$j])) { ?>
		
				<!-- BLOB -->
				<td align=right valign=top>[BLOB]</td>;
		
			<? } elseif (eregi("text|char", $column_type[$j])) {
			
				// If the text is longer than $cfgMaxText characters, let's cut it short
				if (strlen($return_row[$j]) > $cfgMaxText && !empty($cfgMaxText)) {
					$strLgText = nl2br(htmlspecialchars(substr($return_row[$j], 0, $cfgMaxText))) . " <br><b>... $strMore ...</b>";
				} else {
					$strLgText = nl2br(htmlspecialchars($return_row[$j]));
				}
			?>
				<!-- TEXT -->
				<td valign=top><? echo $strLgText ; ?></td> 

			<? } elseif ($field_type == "bool") { ?>
				
				<!-- BOOLEAN -->
				<td valign=top><? echo bool_YesNo($return_row[$j]) ; // add bool_YesNo function, didn't work since variable was out of scope ?></td> 


			<? } else {
				$other =  nl2br(htmlspecialchars($return_row[$j]))
			?>
				<!-- OTHER -->
				<td valign=top><? echo nl2br(htmlspecialchars($return_row[$j])); ?></td> 
				
			<? } // end if eregi()	?>
		  
<?		} else { 
			echo "<td>"."&nbsp;"."</td>";
		} // end of if (!empty)
?>
	 
<?	}  // end for loop of columns $j   ?>

	</tr>

<?	 } // end for loop for rows $i   ?>

</table>
