<?
/**************************************************
Program name:	connect_exec.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)
		Dan Wilson (hpPgAdmin@acucore.com)

Description:	Send and Retrieve Result of SQL String.
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/

// Connect to PostgreSQL
include ($PATH_INCLUDE."database.inc.php");


// If connection was successful then continue

if ($link) {

	// Execute SQL string

	#$sql_get is the generic SQL string varible to get some rows from a database
	if (!empty($sql_get)) {

		# Execute SQL - $sql_return is the Resource Variable (int) from executing $sql_get
		if ($cfgDebug) {
			$sql_return = @pg_exec($link, pre_query($sql_get)) or pg_die(@pg_errormessage(), $sql_get, __FILE__, __LINE__);
		} else {
			$sql_return = @pg_exec($link, pre_query($sql_get)) or pg_die(@pg_errormessage(), $sql_get, __FILE__, __LINE__);
		}

		# Get Number of Rows - $num_rows is the number of rows that exist
		if ($cfgDebug) {
			$num_return = pg_numrows($sql_return);
		} else {
			$num_return = @pg_numrows($sql_return);
		}
		$num_rows = $num_return;

		# Get Number of Columns - $num_columns is number of columns that exist
		if ($cfgDebug) {
			$num_fields = pg_numfields($sql_return);
		} else {
			$num_fields = @pg_numfields($sql_return);
		}

		$num_columns = $num_fields;

		# Get Fields Names and Field Types of SQL returned (Single-Dimensional Arrays) 
		for ($j = 0; $j < $num_columns; $j++) {
			if ($cfgDebug) {
				$column_name[$j] = pg_fieldname($sql_return, $j);
				$column_type[$j] = pg_fieldtype($sql_return, $j);
			} else {
				$column_name[$j] = @pg_fieldname($sql_return, $j);
				$column_type[$j] = @pg_fieldtype($sql_return, $j);
		}
		
	        }

		# Fetch 2-Dimensional Array for SQL 
		# Don't fetch ALL rows for TABLE.  Better to only fetch up to first position on  
		# display_table_html page.
		for ($i = 0; $i < $num_rows; $i++) {
			if ($cfgDebug) {
				$sql_array[$i] = pg_fetch_array($sql_return, $i, PGSQL_BOTH);
			} else {
				$sql_array[$i] = @pg_fetch_array($sql_return, $i, PGSQL_BOTH);
			}

		}


	} else {
		#SQL String is Empty
	}

} else {	
	#This should never get run.  pg_die will catch it in database.inc.php if $link is false
}


// Needed to close because bug when I had 3 include(get_array_*) statements.  2 worked but not three ?????
if (webpage($PHP_SELF) == "func_editpage.php") {
	if ($cfgDebug) {
		$cl = pg_close($link);
	} else {
		$cl = @pg_close($link);
	}
}

// If there were any errors then set web_page to errorpage.php
if (!empty($strpgdie[1])) {
	$web_page = "errorpage.php";
	include($PATH_TEMPLATE.$cfgTemplate1);
	exit;
}


?>
