<?php

/**************************************************
Program name:	get_array_dbs.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Get array of database names, owner, encoding, and comments.
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/


// Set variable $qrUserOnly to be used in following SQL Statement	
	if ($cfgUserDatabases && !$bSuperUser) {
		$qrUserOnly = " AND pg_get_userbyid(datdba) = CURRENT_USER";
	} else {
		unset($qrUserOnly);
	}

// $sql_get_dbs is SQL string to get database name, owner, encoding
$sql_get = "
	SELECT 
		d.datname as ".dquotes($strDatabase).", 
		u.usename as ".dquotes($strOwner).", 
		pg_encoding_to_char(d.encoding) as ".dquotes($strEncoding).", 
		datallowconn as ".dquotes($strAllowConnect).",
		datpath as ".dquotes($strDataPath).",
 		obj_description(d.oid) as ".dquotes($strComment)." 
	FROM 
		pg_database d, pg_user u 
	WHERE 
		d.datdba = u.usesysid ".$qrUserOnly;

If (!empty($cfgServer[only_db])) {
$sql_get .= "
		AND d.datname = '".$cfgServer[only_db]."'";
}
$sql_get .= "
	UNION
	SELECT 
		d.datname, 
		NULL AS owner,
		pg_encoding_to_char(d.encoding),
		datallowconn,
		datpath,
		obj_description(d.oid) as description 
	FROM 
		pg_database d 
	WHERE 
		d.datdba NOT IN (SELECT usesysid FROM pg_user) ".$qrUserOnly;

If (!empty($cfgServer[only_db])) {
$sql_get .= "
		AND d.datname = '".$cfgServer[only_db]."'";
}

$sql_get .= "
	ORDER BY ". 
		dquotes($strDatabase)
	;
#
#echo "onlydb".$cfgServer[only_db].$cfgServer[user]. "<br>";
#echo $sql_get;
#exit;

// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");


//Modify Fields

for ($i = 0; $i < $num_rows; $i++) {

	# Make link for DB name
	$sql_array[$i][0] = "<a class=link href=tbllist.php?ndb=".$sql_array[$i][0].">".$sql_array[$i][0]."</a>";

	# Make PGDATA for datpath if blank
	if (empty($sql_array[$i][4])) {
		$sql_array[$i][4] = "PGDATA";
	}

	# Accepting connections (yes/no)
	$sql_array[$i][3] = bool_YesNo($sql_array[$i][3]);
}

?>
