<?php

/**************************************************
Program name:	library.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Functions used
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/

/*
Functions

pg_die()
select_box()
pre_query()
get_table_def()
get_table_content()
get_table_csv()
count_records()
show_docu()
show_message()
isInArray()
bool_YesNo()
noQuoteSplit()
RedirectTo($url) 
$cfgFunctions 
*/

#function isview($relation) {
#	global $view
#	if ($relation == $view) {
#		return true;
#	} else {
#		return false;
#	}
#}



function cf($confirmtext,$hyplink) {
   global $cfgConfirm;
   if ($cfgConfirm) {
	   $hyplink = str_replace("<a","",$hyplink);
	   $hyplink = "onclick=\"return confirmSubmit('".$confirmtext."')"."\" ". $hyplink;
	   $hyplink = "<a ".$hyplink;
   }
   return $hyplink;
}


// Set cfgQuotes - CHANGE THIS LATER
if ($cfgQuotesOn) {
	$cfgQuotes = "\"";
#	unset($cfgQuotes);

} else {
	unset($cfgQuotes);
}


// add single quotes in you don't have them
function add_sq($str) {
	$str = stripslashes($str);
	$str = "'".$str."'";
	return $str;
}

function add_dq($str) {
	$str = stripslashes($str);
	$str = "\"".$str."\"";
	return $str;
}

function strip_sq($str) {
	$str = stripslashes($str);
	if (eregi("^'[[:alnum:][:punct:][:cntrl:][:space:]]*'$", $str)) {
		$str = ereg_replace("^'|'$", "", $str);
	}
	return $str;
}

function strip_dq($str) {
	$str = stripslashes($str);
	if (eregi("^\"[[:alnum:][:punct:][:cntrl:][:space:]]*\"$", $str)) {
		$str = ereg_replace("^\"|\"$", "", $str);
	}
	return $str;
}

function has_sq($str) {
	// if begins with ' or \'
	$str = stripslashes($str);
	if (eregi("^'[[:alnum:][:punct:][:cntrl:][:space:]]*'$", $str)) {
		return true;
	} else {
		return 0;
	}
}

function has_dq($str) {
	$str = stripslashes($str);
	if (eregi("^\"[[:alnum:][:punct:][:cntrl:][:space:]]*\"$", $str)) {
		return true;
	} else {
		return 0;
	}
}

function squotes($str) {
	$str = stripslashes($str);
	if (!has_sq($str)) {
		$str = add_sq($str);
	} 
	return $str;
}

function dquotes($str) {
	$str = stripslashes($str);
	if (!has_dq($str)) {
		$str = add_dq($str);
	} 
	return $str;
}


function dq($str) {
	global $cfgQuotesOn;
	if ($cfgQuotesOn) {
		$str = dquotes($str);
	} 
	return $str;
}
function webpage($strpage) {
	$phpself_array = explode('/',$strpage);
	$current_page = end($phpself_array);
	// strip off .php
	$current_page = eregi_replace(".php", "", $current_page);
	$webpage_page = $current_page."page.php";
	return $webpage_page;
}
function currentpage($strpage) {
	$phpself_array = explode('/',$strpage);
	$current_page = end($phpself_array);
	// strip off .php
	$current_page = eregi_replace(".php", "", $current_page);
	$webpage_page = $current_page."page.php";
	return $current_page;
}


// -----------------------------------------------------------------
// Function: 	pg_die($error, $query)
// Params:	$error -- The displayable error text.  Usually passed as pg_errormessage()
//		$query -- The query which was attempted

function pg_die($error = "", $query = "", $err_file = __FILE__, $err_line = __LINE__) {

	# function similar to like hyperlinking error.php

	# declare global variables
	global $strError,$strMySQLSaid, $strBack, $sql_query, $HTTP_REFERER, $SCRIPT_FILENAME, $link, $db, $table, $cfgDebug, $server, $strpgdie ; 
	
	# Display Error - File_Name -- Line: line#
	# Example Error - include/database.inc.php -- Line: 111
	$strpgdie[1] = $strError . "-". $err_file . "-- Line: " . $err_line ;

	# if $error is empty then $error is pg_errormessage (error that PosgreSQL generates) 
	if (empty($error)) {
		$error = pg_errormessage($link);
	}

	#Display "PostgreSQL said:  error message"
	$strpgdie[2] = $strMySQLSaid . $error;


	# set query to sql_query if empty
	if (empty($query)) {
		$query = $sql;
}
	
	# Display Query that caused error.
	if (!empty($query)) {
		$strpgdie[3] = "Your query: " . nl2br(htmlentities($query)) ;
	}

	# Print Connection String, Database, and Server, if Debug is turned on.i
	if ($cfgDebug) {
		$strpgdie[4] = "<br>Link: $link<br>DB: $db<br>Table: $table<br>Server: $server";
	}
#	echo "<p>";
	return $strpgdie;

	exit;
}


/*
// -----------------------------------------------------------------
// Function: 	pg_die($error, $query)
// Params:	$error -- The displayable error text.  Usually passed as pg_errormessage()
//		$query -- The query which was attempted

function pg_die($error = "", $query = "", $err_file = __FILE__, $err_line = __LINE__) {

	# declare global variables
	global $strError,$strMySQLSaid, $strBack, $sql_query, $HTTP_REFERER, $SCRIPT_FILENAME, $link, $db, $table, $cfgDebug, $server;
	
	# Display Error - File_Name -- Line: line#
	# Example Error - include/database.inc.php -- Line: 111
	echo "<br><b><font face=\"arial,helvetican,sans-serif\" color=\"red\">$strError - $err_file -- Line: $err_line</font></b><p>";

	# if $error is empty then $error is pg_errormessage 
	# JOE - WHAT IS THIS??	
#	if (empty($error)) {
		$error = @pg_errormessage();
#	}

	#Display "PostgreSQL said:  error message" in red font
	echo "<font face=\"arial,helvetican,sans-serif\" color=\"red\">", $strMySQLSaid . $error;

	# set query to sql_query if empty
	if (empty($query)) {
		$query = $sql_query;
	}

	# Display Query that caused error.
	if (!empty($query)) {
		echo "<br>Your query: <br><b>",  nl2br(htmlentities($query)), "</b>";
	}

	# Display BACK button
	echo "<br><a class=link href=\"javascript:history.back()\">$strBack</a></font>";
	
	
	# Print Connection String, Database, and Server, if Debug is turned on.
	if ($cfgDebug) {
		echo "<br>Link: $link<br>DB: $db<br>Table: $table<br>Server: $server";
	}
	echo "<p>";

#	include ("footer.inc.php");
	#Redirect to login.php
	#
	#$webpage = "loginpage.php";
	#include($site_vars["page_template"]);
	
	exit;
}

*/


//FUNCTIONS BELOW FUNCTIONS BELOW FUNCTIONS BELOW FUNCTIONS BELOW FUNCTIONS BELOW

//***************************************************************************************
//      Function:       select_box($settings)
//      Puspose:        Display a drop-down box
//      Params:         $settings -- Associative array containing all info about the select.
//                            - selected      -- The selected/default option
//                            - values        -- array containing all options.  Associative or normal array
//                            - multiple      -- specifies wether is a multiple select or not

function select_box($settings) {
	// Compile the attributes such as size etc.
	while (list($thiskey, $thisval) = each($settings)) {
		if ($thiskey == "multiple") {
			$attribs .= " multiple";
		} else if (($thiskey != "values") && ($thiskey != "name") && ($thiskey != "selected")) {
			$attribs .= " $thiskey=\"$thisval\"";
		} 
	}
	if (ereg("multiple", $attribs)) {
		$name = "$settings[name][]";
	} else {
		$name = "$settings[name]";
	}
	
	// Start the selectbox tag
	$strReturn .= "\n<select name=\"$name\" $attribs>";
	// Check if the valuse are in associative array or not
	if (count($settings[values]) > 0) {
		if (!isset($settings[values][0])) {
			while (list($disp, $val) = each($settings[values])) {
				$strReturn .= "\n<option value=\"".htmlentities(chop($val))."\"";
				// Check if the selected is an array
				if (is_array($settings[selected])) {
					// Loop through the selected array
					for ($iSelIndex = 0; $iSelIndex < count($settings[selected]); $iSelIndex++) {
						if ($val == chop($settings[selected][$iSelIndex]))  {
							$strReturn .= " selected";
						}
					}
				} else {
					if ($val == chop($settings[selected]))  {
						$strReturn .= " selected";
					}
				}
				$strReturn .= ">$disp";
			}
		} else { // If not in associative array
			for ($index = 0; $index < count($settings[values]); $index++) {
				$strReturn .= "\n<option value=\"".htmlentities(chop($settings[values][$index]))."\"";
				// Check if the selected is an array
				if (is_array($settings[selected])) {
					for ($iSelIndex = 0; $iSelIndex < count($settings[selected]); $iSelIndex++) {
						if (chop($settings[values][$index]) == chop($settings[selected][$iSelIndex])) {
							$strReturn .= " selected";
						}
					}
				} else {
					if (chop($settings[values][$index]) == chop($settings[selected])) {
						$strReturn .= " selected";
					}
				}
				$strReturn .= ">".$settings[values][$index];
			}
		}
	} else {
		$strReturn .= "<option value=\"0\">No Values";
	}
	$strReturn .= "\n</select>\n";
	return $strReturn;
}




// -----------------------------------------------------------------
// Function: 	pre_query($query)
// Params:	$query -- Query String to prepare
// Note:	This is usually called within the pg_exec function -- pg_exec($dbh, pre_query($sql_get_auth));
// -----------------------------------------------------------------

function pre_query($query) {

	# Declare version as global
	global $version;

	# Replace \n characters in $query string with "" for Versions before 7.x;
	# Otherwise, just return same $query that was passed to it.
	if ($version < 7 || empty($version)) { 
		$query = str_replace("\n", "", $query);
	}
		return $query;
}

//------------------------------------------------------------
	

// Return $tables CREATE definition 
// Returns a string containing the CREATE statement on success
// "
function get_table_def($link, $table, $crlf) {
	global $drop, $drop_field, $cfgQuotes, $noACL;
	unset($schema_create);
	if (!empty($drop)) {
//		$schema_create .= "DROP TABLE IF EXISTS $table;$crlf";
	}
	$schema_create .= "CREATE TABLE $cfgQuotes$table$cfgQuotes ($crlf";
	
	$sql_get_fields = "
		SELECT 
			a.attnum,
			a.attname AS field, 
			t.typname AS type, 
			a.attlen AS length,
			a.atttypmod AS lengthvar,
			a.attnotnull AS notnull
		FROM 
			pg_class c, 
			pg_attribute a, 
			pg_type t
		WHERE 
			c.relname = '$table'
			and a.attnum > 0
			and a.attrelid = c.oid
			and a.atttypid = t.oid
		ORDER BY a.attnum
	";

	$result = pg_exec($link, pre_query($sql_get_fields)) or pg_die(pg_errormessage(), $sql_get_fields, __FILE__, __LINE__);
	$i = 0;
	while ($row = @pg_fetch_array($result, $i++)) {
		if ($row[field] != $drop_field) {
			$sql_get_default = "
				SELECT d.adsrc AS rowdefault
				FROM pg_attrdef d, pg_class c 
				WHERE 
					c.relname = '$table' 
					AND c.oid = d.adrelid 
					AND d.adnum = $row[attnum]
			";
			$def_res = pg_exec($link, pre_query($sql_get_default)) or pg_die(pg_errormessage(), $sql_get_default, __FILE__, __LINE__);
			if (!$def_res) {
				unset($row[rowdefault]);
			} else {
				$row[rowdefault] = @pg_result($def_res, 0, "rowdefault");
			}
	
			if ($row[type] == "bpchar") {
				// Internally stored as bpchar, but isn't accepted in a CREATE TABLE
				$row[type] = "char";
			}
			
			$schema_create .= "   $cfgQuotes$row[field]$cfgQuotes $row[type]";
			if (eregi("char", $row[type])) {
				if ($row[lengthvar] > 0) {
					$schema_create .= "(" . ($row[lengthvar] - 4) . ")";
				}
			}
			if (eregi("numeric", $row[type])) {
				//Marcellus fixed problem on 5-25-00
				$schema_create .= "(";
				$schema_create .= sprintf("%s,%s", ($row[lengthvar] >> 16) & 0xffff, ($row[lengthvar] - 4) & 0xffff);
				$schema_create .= ")";
	
			}
			if (!empty($row[rowdefault])) {
				if (eregi("text|name|char|date|timestamp|bool", $row[type])) {
					//$delim = "'";
				} else {
					unset($delim);
				}
				$schema_create .= " DEFAULT ". $delim . $row[rowdefault] . $delim;
			}
			if ($row["notnull"] == "t") {
				$schema_create .= " NOT NULL";
			}
			$schema_create .= ",$crlf";
		}
	}

	// Generate constraint clauses for UNIQUE and PRIMARY KEY constraints
	$sql_pri_keys = "
		SELECT 
			ic.relname AS index_name, 
			bc.relname AS tab_name, 
			ta.attname AS column_name,
			i.indisunique AS unique_key,
			i.indisprimary AS primary_key
		FROM 
			pg_class bc,
			pg_class ic,
			pg_index i,
			pg_attribute ta,
			pg_attribute ia
		WHERE 
			bc.oid = i.indrelid
			AND ic.oid = i.indexrelid
			AND ia.attrelid = i.indexrelid
			AND ta.attrelid = bc.oid
			AND bc.relname = '$table'
			AND ta.attrelid = i.indrelid
			AND ta.attnum = i.indkey[ia.attnum-1]
		ORDER BY 
			index_name, tab_name, column_name
	";

	$result = @pg_exec($link, pre_query($sql_pri_keys)) or pg_die(pg_errormessage(), $sql_pri_keys, __FILE__, __LINE__);

	$i = 0;
	while ($row = @pg_fetch_array($result, $i++)) {
		if ($row[column_name] != $drop_field) {
			if ($row[primary_key] == "t") {
				if (!empty($primary_key)) {
					$primary_key .= ", ";
				}
				$primary_key .= "$cfgQuotes$row[column_name]$cfgQuotes";
				$primary_key_name = $row[index_name];
			} else {
				// We have to store all this info becuase it's possible that there is a multi-column key.. 
				// .. we can then loop through it again and build the statement
				$index_rows[$row[index_name]][table] = $table;
				$index_rows[$row[index_name]][unique] = ($row[unique_key] == "t") ? " UNIQUE" : "";
				$index_rows[$row[index_name]][column_names] .= "$cfgQuotes$row[column_name]$cfgQuotes, ";
			}
		}
	}
	if (!empty($index_rows)) {
		while (list($idx_name, $props) = each($index_rows)) {
			$props[column_names] = ereg_replace(", $", "", $props[column_names]);
			$index_create .= "CREATE " . $props[unique] . " INDEX $cfgQuotes$idx_name$cfgQuotes ON $cfgQuotes$table$cfgQuotes (" . $props[column_names] . ");$crlf";
		}
	}
	
	if (!empty($primary_key)) {
		$schema_create .= "   CONSTRAINT $cfgQuotes$primary_key_name$cfgQuotes PRIMARY KEY ($primary_key),$crlf";
	}

	// Generate constraint clauses for CHECK constraints
	$sql_checks = "
		SELECT 
			rcname as index_name, 
			rcsrc 
		FROM 
			pg_relcheck,
			pg_class bc
		WHERE 
			rcrelid = bc.oid 
			and bc.relname = '$table'
			and not exists 
			(select * from pg_relcheck as c, pg_inherits as i 
			where i.inhrelid = pg_relcheck.rcrelid 
			and c.rcname = pg_relcheck.rcname 
			and c.rcsrc = pg_relcheck.rcsrc 
			and c.rcrelid = i.inhparent)
	";

	$result = @pg_exec($link, $sql_checks) or pg_die(pg_errormessage(), $sql_checks, __FILE__, __LINE__);

	$i = 0;
	while ($row = @pg_fetch_array($result, $i++)) {
		$schema_create .= "   CONSTRAINT $cfgQuotes$row[index_name]$cfgQuotes CHECK $row[rcsrc],$crlf";
	}

	$schema_create = ereg_replace(",".$crlf."$", "", $schema_create);
	$index_create = ereg_replace(",".$crlf."$", "", $index_create);

	$schema_create .= "$crlf);$crlf";
	
	if (!empty($index_create)) {
		$schema_create .= $index_create;
	}
	
	if (!$noACL) {
		$sql_get_privilege = "SELECT relacl FROM pg_class WHERE relname = '$table'";
		if (!$res = @pg_exec($link, $sql_get_privilege)) {
			pg_die(pg_errormessage($link), $sql_get_privilege, __FILE__, __LINE__);
		} else {
			// query must return exactely one row (check this ?)
			$row = pg_fetch_array($res, 0);
			if (!empty($row[relacl])) {
				$priv = trim(ereg_replace("[\{\"]", "", $row[relacl]));
				$users = explode(",", $priv);
				for ($iUsers = 0; $iUsers < count($users); $iUsers++) {
					$aryUser = explode("=", $users[$iUsers]);
					if ($aryUser[0] == "") {
						$user = "PUBLIC";
					} else {
						if (eregi("^group", $aryUser[0])) {
							$user = eregi_replace("^group ([[:alnum:]]+)", "GROUP $cfgQuotes\\1$cfgQuotes", $aryUser[0]);
						} else {
							$user = "$cfgQuotes$aryUser[0]$cfgQuotes";
						}
					}
					$privileges = $aryUser[1]; 
					unset($acl_priv);	
					if (strchr($privileges, "a")) {
						$acl_priv .= "INSERT,";
					}
					if (strchr($privileges, "r")) {
						$acl_priv .= "SELECT,";
					}
					if (strchr($privileges, "w")) {
						$acl_priv .= "UPDATE,DELETE,";
					}
					if (strchr($privileges, "R")) {
						$acl_priv .= "RULE,";
					}
	
					$acl_priv = ereg_replace(",$", "", $acl_priv);
					
					if ($acl_priv == "INSERT,SELECT,UPDATE,DELETE,RULE") {
						$acl_priv = "ALL";
					}
					
					if (!empty($acl_priv)) {
						$acl_schema .= "GRANT $acl_priv ON $cfgQuotes$table$cfgQuotes TO $user;$crlf";
					} else {
						// $acl_schema .= "REVOKE ALL ON $cfgQuotes$table$cfgQuotes FROM $cfgQuotes$user$cfgQuotes;$crlf";
					}
					
				} // Close for loop
			}
			$schema_create .= $acl_schema;
		}
		
	}
	
	
	return (stripslashes($schema_create));
} 

// Get the content of $table as a series of INSERT statements.
// After every row, a custom callback function $handler gets called.
// $handler must accept one parameter ($sql_insert);
function get_table_content($link, $table, $handler) {
	global $cfgQuotes;
	$result = @pg_exec($link, "SELECT * FROM $cfgQuotes$table$cfgQuotes") or pg_die(pg_errormessage(), "", __FILE__, __LINE__);
	$iNumFields = pg_numfields($result);

	// Gather info about each column in the table	
	for ($iField = 0; $iField < $iNumFields; $iField++) {
		$aryType[] = pg_fieldtype($result, $iField);
		$aryName[] = pg_fieldname($result, $iField);
	}
	
	$iRec = 0;
	while ($row = @pg_fetch_array($result, $iRec++)) {
		unset($schema_vals);
		unset($schema_fields);
		unset($schema_insert);
		
		for ($iFieldVal = 0; $iFieldVal < $iNumFields; $iFieldVal++) {
			$strVal = $row[$aryName[$iFieldVal]];
			if (eregi("char|text|bool", $aryType[$iFieldVal])) {
				$strQuote = "'";
				$strEmpty = "";
				$strVal = addslashes($strVal);
			} elseif (eregi("date|timestamp", $aryType[$iFieldVal])) {
				if (empty($strVal)) {
					$strQuote = "";
				} else {
					$strQuote = "'";
				}
				$strEmpty = "NULL";
			} else {
				$strQuote = "";
				$strEmpty = "NULL";
			}
			if (empty($strVal) && $strVal != "0") {
				$strVal = $strEmpty;
			}
			$schema_vals .= " $strQuote$strVal$strQuote,";
			$schema_fields .= " $cfgQuotes$aryName[$iFieldVal]$cfgQuotes,";
		}
		
		$schema_vals = ereg_replace(",$", "", $schema_vals);
		$schema_vals = ereg_replace("^ ", "", $schema_vals);
		$schema_fields = ereg_replace(",$", "", $schema_fields);
		$schema_fields = ereg_replace("^ ", "", $schema_fields);
		$schema_insert = "INSERT INTO $cfgQuotes$table$cfgQuotes ($schema_fields) VALUES($schema_vals)";
		$handler(trim($schema_insert));
	}
	return (true);
}
 
function count_records ($link, $table) {
	global $strNoAuth, $cfgQuotes;
	//always quote table name when counting
	$countsql = "SELECT COUNT(*) AS num FROM ".dquotes($table);
	$result = pg_exec($link, $countsql);
	$num = pg_result($result, 0 ,"num");
	if (!empty($num) || $num == 0) {
		return $num;
	} else {
		#return $strNoAuth;
	}
}

// Get the content of $table as a CSV output.
// $sep contains the separation string.
// After every row, a custom callback function $handler gets called.
// $handler must accept one parameter ($sql_insert);

function get_table_csv($link, $table, $sep, $handler) {
	global $cfgQuotes;
	$result = pg_exec($link, "SELECT * FROM $cfgQuotes$table$cfgQuotes") or pg_die(pg_errormessage(), "", __FILE__, __LINE__);
	$i = 0;
	if (pg_numrows($result)) {
		while ($row = @pg_fetch_row($result, $i++)) {
			unset($schema_insert);
			for ($j = 0; $j < pg_numfields($result); $j++) {
				if (!isset($row[$j])) {
					$schema_insert .= "NULL".$sep;
				} elseif ($row[$j] != "") {
					$schema_insert .= "$row[$j]".$sep;
				} else {
					$schema_insert .= "".$sep;
				}
			}
			$schema_insert = ereg_replace($sep."$", "", $schema_insert);
			//       $schema_insert .= ")";
			$handler(trim($schema_insert));
		}
	} else {
		echo "$strNoData $strFound";
	}
	return (true);
}

function show_docu($link) {
	global $cfgManualBase, $strDocu;
	if (!empty($cfgManualBase)) {
		return("[<a class=link href=\"$cfgManualBase/$link\">$strDocu</a>]");
	}
}


function show_message($message,$bool) {
	echo "<div align=left>";
	echo "<table border=0>";
	echo "<tr>";
	echo "<td bgcolor="."\"#cccccc\"".">";
	echo "<font color=\"red\"><b>".$message."<b></font><br>";
	echo "</td>";
	echo "</tr>";
	
	if ($GLOBALS['cfgShowSQL'] == true && (!empty($GLOBALS['nsql_query'])) && ($bool))	{
	
		echo "<tr>";
		echo "<td bgcolor=\"#dddddd\">";

		#	if (isset($affected_rows)) {
		#		echo $GLOBALS['strAffected'].": $affected_rows<br>\n"; 
		#	}
	
		echo "<b><u>".$GLOBALS['strSQLQuery'].":\n</b></u><br>", stripslashes(nl2br(htmlentities($GLOBALS['nsql_query'])));
#		echo stripslashes(nl2br(htmlentities($GLOBALS['nsql_query'])));

		echo "</td></tr>";
	} 
	
	echo "</table></div><br>";
}

//***************************************************************************************
//      Function:       isInArray($value, $chkArray)
//      Puspose:        Check to see if $value is in $chkArray
//      Params:         $value, $chkArray

function isInArray($value, $chkArray) {
	for ($iTrav = 0; $iTrav < count($chkArray); $iTrav++) {
		if ($value == $chkArray[$iTrav]) {
			return 1;
		}
	}
	return 0;
}


function bool_YesNo($boolVal) {
	global $strNo, $strYes;
	if (eregi("^t|1|^y", $boolVal)) {
		return $strYes;
#	} elseif (eregi("^f|0|^n", $boolVal)) {
	} else {
		return $strNo;
	}
}

function noQuoteSplit($string, $sep, $delim) {
	$curpos = 0;
	$in = 0;
	unset($accum);
	$string = trim($string); 
	
	for ($i = 0, $n = strlen($string); $i < $n; $i++) {
		$char = $string[$i];
		$accum .= $char;
		if (($char == $delim) && ($string[$i - 1] != "\\")) {
			if ($in == 0) {
				$in = 1;
			} else {
				$in = 0;
			}
		} elseif ($char == $sep) {
			if ($in == 0) {
				$found[] = trim($accum);
				unset($accum);
			}
		}
	}
	if ($accum) {
		$found[] = $accum;
	}
	
	return $found;
}

// -----------------------------------------------------------------

// Array of standard postgres functions
$cfgFunctions = array(
	"",
	"CURVAL",
	"NEXTVAL",
	"TEXTCAT",
	"TEXTLEN",
	"COALESCE",
	"NULLIF",
	"ABS",
	"DEGREES",
	"EXP",
	"LN",
	"LOG",
	"PI",
	"POW",
	"RADIANS",
	"ROUND",
	"SQRT",
	"CBRT",
	"TRUNC",
	"FLOAT",
	"FLOAT4",
	"INTERGER",
	"ACOS",
	"ASIN",
	"ATAN",
	"ATAN2",
	"COS",
	"COT",
	"SIN",
	"TAN",
	"CHAR_LENGTH",
	"LOWER",
	"OCTET_LENGTH",
	"POSITION",
	"SUBSTRING",
	"TRIM",
	"UPPER",
	"CHAR",
	"INITCAP",
	"LPAD",
	"LTRIM",
	"TEXTPOS",
	"RPAD",
	"RTRIM",
	"SUBSTR",
	"TEXT",
	"TRANSLATE",
	"VARCHAR",
	"ABSTIME",
	"AGE",
	"DATE_PART",
	"DATE_TRUNC",
	"INTERVAL",
	"ISFINITE",
	"RELTIME",
	"TIMESTAMP",
	"TO_CHAR",
	"TO_DATE",
	"TO_TIMESTAMP",
	"TO_NUMBER",
	"AREA",
	"BOX",
	"CENTER",
	"DIAMETER",
	"HEIGHT",
	"ISCLOSED",
	"ISOPEN",
	"LENGTH",
	"PCLOSE",
	"NPOINT",
	"POPEN",
	"RADIUS",
	"WIDTH",
	"CIRCLE",
	"LSEG",
	"PATH",
	"POINT",
	"POLYGON",
	"ISOLDPATH",
	"REVERTPOLY",
	"UPGRADEPATH",
	"UPGRADEPOLY",
	"BROADCAST",
	"HOST",
	"MASKLEN",
	"NETMASK"
	);

#	$LIB_INC = 1;
#}

#include "include/database.inc.php";

/*
 * Function: RedirectTo($url)
 *
 * Description: Sends a redirection url and page
*/

function RedirectTo($url) {
        header("Refresh:0;URL=$url");
        echo " ";
}


// get array of NULL, NOT NULL
$aryNULL[0] = "";
$aryNULL[1] = "NULL";
$aryNULL[2] = "NOT NULL";

// get array of MATCH
$aryMatchType[0] = "";
$aryMatchType[1] = "MATCH FULL";
#$aryMatchType[2] = "MATCH PARTIAL";

// get array of ON DELETE / ON UPDATE
$aryOnAction[0] = "";
$aryOnAction[1] = "NO ACTION";
$aryOnAction[2] = "RESTRICT";
$aryOnAction[3] = "CASCADE";
$aryOnAction[4] = "SET NULL";
$aryOnAction[5] = "SET DEFAULT";

// get array of ON DELETE / ON UPDATE
$aryDeferred[0] = "";
$aryDeferred[1] = "NOT DEFERRABLE";
$aryDeferred[2] = "DEFERRABLE";
$aryDeferred[3] = "DEFERRABLE INITIALLY IMMEDIATE";
$aryDeferred[4] = "DEFERRABLE INITIALLY DEFERRED";

// get array of BEFORE or After
$aryBeforeAfter[0] = "BEFORE";
$aryBeforeAfter[1] = "AFTER";

// get array 
$aryIndexAccessMethods[0] = "";
$aryIndexAccessMethods[1] = "BTREE (Default)";
$aryIndexAccessMethods[2] = "RTREE";
$aryIndexAccessMethods[3] = "HASH";

// get array
$aryIdxUnique[0] = "";
$aryIdxUnique[1] = "UNIQUE";

// get array 
$aryOpClass[0] = "";
$aryOpClass[1] = "int4_ops";

// get array 
$aryEvent[0] = "";
$aryEvent[1] = "SELECT";
$aryEvent[2] = "INSERT";
$aryEvent[3] = "DELETE";
$aryEvent[4] = "UPDATE";

// get array 
$aryDo[0] = "DO";
$aryDo[1] = "DO INSTEAD";


?>
