/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class DateUtils {
    public static final String ISO8601_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String ISO8601_DATE_PATTERN = "yyyy-MM-dd";
    public static final String ISO8601_TIME_PATTERN = "HH:mm:ss";
    private static final MessageFormat MINUTE_SECONDS;
    private static final double[] LIMITS;
    private static final String[] MINUTES_PART;
    private static final String[] SECONDS_PART;
    private static final ChoiceFormat MINUTES_FORMAT;
    private static final ChoiceFormat SECONDS_FORMAT;

    private DateUtils() {
    }

    public static String format(long date, String pattern) {
        return DateUtils.format(new Date(date), pattern);
    }

    public static String format(Date date, String pattern) {
        DateFormat df = DateUtils.createDateFormat(pattern);
        return df.format(date);
    }

    public static String formatElapsedTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        Object[] args = new Object[]{new Long(minutes), new Long(seconds % 60L)};
        return MINUTE_SECONDS.format(args);
    }

    private static DateFormat createDateFormat(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(gmt);
        sdf.setLenient(true);
        return sdf;
    }

    public static int getPhaseOfMoon(Calendar cal) {
        int dayOfTheYear = cal.get(6);
        int yearInMetonicCycle = (cal.get(1) - 1900) % 19 + 1;
        int epact = (11 * yearInMetonicCycle + 18) % 30;
        if (epact == 25 && yearInMetonicCycle > 11 || epact == 24) {
            ++epact;
        }
        return ((dayOfTheYear + epact) * 6 + 11) % 177 / 22 & 7;
    }

    static {
        ISO8601_DATETIME_PATTERN = ISO8601_DATETIME_PATTERN;
        ISO8601_DATE_PATTERN = ISO8601_DATE_PATTERN;
        ISO8601_TIME_PATTERN = ISO8601_TIME_PATTERN;
        MINUTE_SECONDS = new MessageFormat("{0}{1}");
        LIMITS = new double[]{0.0, 1.0, 2.0};
        MINUTES_PART = new String[]{"", "1 minute ", "{0,number} minutes "};
        SECONDS_PART = new String[]{"0 seconds", "1 second", "{1,number} seconds"};
        MINUTES_FORMAT = new ChoiceFormat(LIMITS, MINUTES_PART);
        SECONDS_FORMAT = new ChoiceFormat(LIMITS, SECONDS_PART);
        MINUTE_SECONDS.setFormat(0, MINUTES_FORMAT);
        MINUTE_SECONDS.setFormat(1, SECONDS_FORMAT);
    }
}

