/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.DefaultMapEntry;
import org.apache.commons.collections.Transformer;

public class BeanMap
extends AbstractMap {
    private Object bean;
    private HashMap readMethods = new HashMap();
    private HashMap writeMethods = new HashMap();
    private HashMap types = new HashMap();
    public static final Object[] NULL_ARGUMENTS = new Object[0];
    public static HashMap defaultTransformers = new HashMap();

    public BeanMap() {
    }

    public BeanMap(Object object) {
        this.bean = object;
        this.initialise();
    }

    public Object clone() {
        Class<?> clazz = this.bean.getClass();
        try {
            Object obj = clazz.newInstance();
            BeanMap beanMap = new BeanMap(obj);
            beanMap.putAll(this);
            return beanMap;
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Could not create new instance of class: " + clazz);
        }
    }

    public void clear() {
        Class<?> clazz = this.bean.getClass();
        try {
            this.bean = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Could not create new instance of class: " + clazz);
        }
    }

    public boolean containsKey(String string) {
        Method method = this.getReadMethod(string);
        return method != null;
    }

    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    public Object get(Object object) {
        Method method;
        if (this.bean != null && (method = this.getReadMethod(object)) != null) {
            try {
                return method.invoke(this.bean, NULL_ARGUMENTS);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logWarn(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logWarn(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logWarn(invocationTargetException);
            }
            catch (NullPointerException nullPointerException) {
                this.logWarn(nullPointerException);
            }
        }
        return null;
    }

    public Object put(Object object, Object object2) throws IllegalArgumentException, ClassCastException {
        if (this.bean != null) {
            Object object3 = this.get(object);
            Method method = this.getWriteMethod(object);
            if (method == null) {
                throw new IllegalArgumentException("The bean of type: " + this.bean.getClass().getName() + " has no property called: " + object);
            }
            try {
                Object[] objectArray = this.createWriteMethodArguments(method, object2);
                method.invoke(this.bean, objectArray);
                Object object4 = this.get(object);
                this.firePropertyChange(object, object3, object4);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logInfo(invocationTargetException);
                throw new IllegalArgumentException(invocationTargetException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logInfo(illegalAccessException);
                throw new IllegalArgumentException(illegalAccessException.getMessage());
            }
            return object3;
        }
        return null;
    }

    public int size() {
        return this.readMethods.size();
    }

    public Set keySet() {
        return this.readMethods.keySet();
    }

    public Set entrySet() {
        return this.readMethods.keySet();
    }

    public Collection values() {
        ArrayList arrayList = new ArrayList(this.readMethods.size());
        Iterator iterator = this.valueIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public Class getType(String string) {
        return (Class)this.types.get(string);
    }

    public Iterator keyIterator() {
        return this.readMethods.keySet().iterator();
    }

    public Iterator valueIterator() {
        final Iterator iterator = this.keyIterator();
        return new Iterator(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                Object e = iterator.next();
                return BeanMap.this.get((String)e);
            }

            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    public Iterator entryIterator() {
        final Iterator iterator = this.keyIterator();
        return new Iterator(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                Object e = iterator.next();
                Object object = BeanMap.this.get((String)e);
                return new MyMapEntry(BeanMap.this, e, object);
            }

            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object object) {
        this.bean = object;
        this.reinitialise();
    }

    protected Method getReadMethod(Object object) {
        return (Method)this.readMethods.get(object);
    }

    protected Method getWriteMethod(Object object) {
        return (Method)this.writeMethods.get(object);
    }

    protected void reinitialise() {
        this.readMethods.clear();
        this.writeMethods.clear();
        this.types.clear();
        this.initialise();
    }

    private void initialise() {
        Class<?> clazz = this.getBean().getClass();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (propertyDescriptorArray != null) {
                int n = 0;
                while (n < propertyDescriptorArray.length) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
                    if (propertyDescriptor != null) {
                        String string = propertyDescriptor.getName();
                        Method method = propertyDescriptor.getReadMethod();
                        Method method2 = propertyDescriptor.getWriteMethod();
                        Class<?> clazz2 = propertyDescriptor.getPropertyType();
                        if (method != null) {
                            this.readMethods.put(string, method);
                        }
                        if (this.writeMethods != null) {
                            this.writeMethods.put(string, method2);
                        }
                        this.types.put(string, clazz2);
                    }
                    ++n;
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            this.logWarn(introspectionException);
        }
    }

    protected void firePropertyChange(Object object, Object object2, Object object3) {
    }

    protected Object[] createWriteMethodArguments(Method method, Object object) throws IllegalAccessException, ClassCastException {
        try {
            Object object2;
            Object[] objectArray;
            if (object != null && (objectArray = method.getParameterTypes()) != null && objectArray.length > 0 && !((Class)(object2 = objectArray[0])).isAssignableFrom(object.getClass())) {
                object = this.convertType((Class)object2, object);
            }
            objectArray = new Object[]{object};
            return objectArray;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logInfo(invocationTargetException);
            throw new IllegalArgumentException(invocationTargetException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            this.logInfo(instantiationException);
            throw new IllegalArgumentException(instantiationException.getMessage());
        }
    }

    protected Object convertType(Class clazz, Object object) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] classArray = new Class[]{object.getClass()};
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{object};
            return constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Transformer transformer = this.getTypeTransformer(clazz);
            if (transformer != null) {
                return transformer.transform(object);
            }
            return object;
        }
    }

    protected Transformer getTypeTransformer(Class clazz) {
        return (Transformer)defaultTransformers.get(clazz);
    }

    protected void logInfo(Exception exception) {
        System.out.println("INFO: Exception: " + exception);
    }

    protected void logWarn(Exception exception) {
        System.out.println("WARN: Exception: " + exception);
        exception.printStackTrace();
    }

    static {
        defaultTransformers.put(Boolean.TYPE, new Transformer(){

            public Object transform(Object object) {
                return Boolean.valueOf(object.toString());
            }
        });
        defaultTransformers.put(Character.TYPE, new Transformer(){

            public Object transform(Object object) {
                return new Character(object.toString().charAt(0));
            }
        });
        defaultTransformers.put(Byte.TYPE, new Transformer(){

            public Object transform(Object object) {
                return Byte.valueOf(object.toString());
            }
        });
        defaultTransformers.put(Short.TYPE, new Transformer(){

            public Object transform(Object object) {
                return Short.valueOf(object.toString());
            }
        });
        defaultTransformers.put(Integer.TYPE, new Transformer(){

            public Object transform(Object object) {
                return Integer.valueOf(object.toString());
            }
        });
        defaultTransformers.put(Long.TYPE, new Transformer(){

            public Object transform(Object object) {
                return Long.valueOf(object.toString());
            }
        });
        defaultTransformers.put(Float.TYPE, new Transformer(){

            public Object transform(Object object) {
                return Float.valueOf(object.toString());
            }
        });
        defaultTransformers.put(Double.TYPE, new Transformer(){

            public Object transform(Object object) {
                return Double.valueOf(object.toString());
            }
        });
    }

    protected static class MyMapEntry
    extends DefaultMapEntry {
        private BeanMap owner;

        protected MyMapEntry(BeanMap beanMap, Object object, Object object2) {
            super(object, object2);
            this.owner = beanMap;
        }

        public Object setValue(Object object) {
            Object object2 = this.getKey();
            Object object3 = this.owner.get(object2);
            this.owner.put(object2, object);
            Object object4 = this.owner.get(object2);
            super.setValue(object4);
            return object3;
        }
    }
}

