/*
 * Decompiled with CFR 0.152.
 */
package xcodegen.parser;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import xcodegen.exceptions.ParserException;
import xcodegen.parser.Parser;
import xcodegen.parser.ParserError;
import xcodegen.structure.AbstractXObject;
import xcodegen.structure.XClass;
import xcodegen.structure.XField;
import xcodegen.structure.XFinder;
import xcodegen.structure.XPackage;
import xcodegen.structure.XParameter;
import xcodegen.structure.XReference;

public class XMLParser
implements Parser {
    private static final Logger __logger = Logger.getLogger((Class)(class$xcodegen$parser$XMLParser == null ? (class$xcodegen$parser$XMLParser = XMLParser.class$("xcodegen.parser.XMLParser")) : class$xcodegen$parser$XMLParser));
    private HashMap _class = new HashMap();
    private Collection _error = new Vector();
    static /* synthetic */ Class class$xcodegen$parser$XMLParser;

    public XPackage[] parse(InputStream inputStream) throws ParserException {
        XPackage[] xPackageArray = null;
        try {
            this._error = new Vector();
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(inputStream);
            Element element = document.getRootElement();
            List list = element.getChildren("package");
            Iterator iterator = list.iterator();
            xPackageArray = new XPackage[list.size()];
            int n = 0;
            while (iterator.hasNext()) {
                xPackageArray[n] = this.parsePackage((Element)iterator.next());
                ++n;
            }
        }
        catch (JDOMException jDOMException) {
            this.addError("INVALID_FILE_FORMAT", (Object)jDOMException, null);
        }
        if (this._error.size() > 0) {
            throw new ParserException(this._error);
        }
        return xPackageArray;
    }

    private XPackage parsePackage(Element element) {
        String string = element.getAttributeValue("name");
        __logger.info((Object)("Package:   " + string));
        XPackage xPackage = new XPackage();
        xPackage.setName(string);
        Iterator iterator = element.getChildren("class").iterator();
        while (iterator.hasNext()) {
            this.parseClass((Element)iterator.next(), xPackage);
        }
        return xPackage;
    }

    private void parseClass(Element element, XPackage xPackage) {
        Object object;
        String string;
        String string2 = xPackage.getName();
        String string3 = element.getAttributeValue("name");
        String string4 = string2 + "." + string3;
        __logger.info((Object)("Class:     " + string4));
        XClass xClass = new XClass();
        xClass.setName(string3);
        xClass.setTable(element.getAttributeValue("table"));
        if (!xPackage.addClass(xClass)) {
            this.addError("DUPLICATE_CLASS", string3, xPackage);
            return;
        }
        this._class.put(string4, xClass);
        XClass xClass2 = null;
        String string5 = element.getAttributeValue("extends");
        if (string5 != null) {
            xClass2 = (XClass)this._class.get(string5);
            if (xClass2 == null) {
                this.addError("SUPERCLASS_NOT_FOUND", string5, xClass);
            } else if (xClass2 == xClass) {
                this.addError("INVALID_SUPERCLASS", string5, xClass);
            } else {
                xClass.setSuperclass(xClass2);
            }
        }
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            string = (Element)iterator.next();
            object = string.getName();
            if ("fields".equals(object)) {
                this.parseFields((Element)string, xClass);
                continue;
            }
            if ("finders".equals(object)) {
                this.parseFinders((Element)string, xClass);
                continue;
            }
            if ("author".equals(object)) {
                xClass.setAuthor(string.getText());
                continue;
            }
            if (!"description".equals(object)) continue;
            xClass.setDescription(string.getText());
        }
        string = element.getAttributeValue("primary-key");
        if (string == null) {
            if (xClass2 == null) {
                this.addError("MISSING_PK", xClass);
            }
        } else {
            if (xClass2 != null) {
                this.addError("SUBCLASS_WITH_PK", xClass);
            }
            if ((object = xClass.getField(string)) != null) {
                xClass.setPk((XField)object);
            } else {
                this.addError("PK_NOT_FOUND", string, xClass);
            }
        }
    }

    private void parseFields(Element element, XClass xClass) {
        Iterator iterator = element.getChildren("field").iterator();
        while (iterator.hasNext()) {
            this.parseField((Element)iterator.next(), xClass);
        }
    }

    private void parseField(Element element, XClass xClass) {
        String string;
        String string2 = element.getAttributeValue("name");
        __logger.info((Object)("Field:       " + string2));
        XField xField = new XField();
        xField.setName(string2);
        xField.setType(element.getAttributeValue("type"));
        xField.setColumn(element.getAttributeValue("column"));
        xField.setRequired("true".equals(element.getAttributeValue("required")));
        xField.setNullValue(element.getAttributeValue("null-value"));
        Element element2 = element.getChild("description");
        if (element2 != null) {
            xField.setDescription(element2.getText());
        }
        if (!xClass.addField(xField)) {
            this.addError("DUPLICATE_FIELD", string2, xClass);
            return;
        }
        String string3 = element.getAttributeValue("size");
        if (string3 != null) {
            try {
                xField.setSize(Integer.parseInt(string3));
            }
            catch (Exception exception) {
                this.addError("FIELD_SIZE_FORMAT", string2, xClass);
            }
        }
        if ((string = element.getAttributeValue("reference")) != null) {
            XReference xReference = new XReference();
            XClass xClass2 = (XClass)this._class.get(string);
            if (xClass2 != null) {
                xReference.setTarget(xClass2);
                xReference.setCascadeOnDelete("true".equals(element.getAttributeValue("cascade-delete")));
                xField.setReference(xReference);
            } else {
                this.addError("INVALID_REFERENCE", string, xClass);
            }
        }
    }

    private void parseFinders(Element element, XClass xClass) {
        Iterator iterator = element.getChildren("finder").iterator();
        while (iterator.hasNext()) {
            this.parseFinder((Element)iterator.next(), xClass);
        }
    }

    private XFinder parseFinder(Element element, XClass xClass) {
        String string;
        String string2 = element.getAttributeValue("name");
        __logger.info((Object)("Finder:      " + string2));
        XFinder xFinder = new XFinder();
        xFinder.setName(string2);
        xFinder.setReturnSet("true".equals(element.getAttributeValue("return-set")));
        if (!xClass.addFinder(xFinder)) {
            this.addError("DUPLICATE_FINDER", string2, xClass);
        }
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            string = (Element)iterator.next();
            String string3 = string.getName();
            if ("parameters".equals(string3)) {
                this.parseParameters((Element)string, xFinder);
                continue;
            }
            if ("where".equals(string3)) {
                xFinder.setWhere(string.getText());
                continue;
            }
            if (!"description".equals(string3)) continue;
            xFinder.setDescription(string.getText());
        }
        string = xFinder.getWhere();
        if (string != null) {
            int n = 0;
            int n2 = xFinder.getParameters().size();
            int n3 = 0;
            int n4 = string.length();
            while (n3 < n4) {
                if (string.charAt(n3) == '?') {
                    ++n;
                }
                ++n3;
            }
            if (n != n2) {
                this.addError("PARAMETER_COUNT", "Expecting " + n + " parameter(s), got " + n2, xFinder);
            }
        }
        return xFinder;
    }

    private void parseParameters(Element element, XFinder xFinder) {
        Iterator iterator = element.getChildren("parameter").iterator();
        while (iterator.hasNext()) {
            this.parseParameter((Element)iterator.next(), xFinder);
        }
    }

    private void parseParameter(Element element, XFinder xFinder) {
        String string = element.getAttributeValue("name");
        __logger.info((Object)("Parameter:     " + string));
        XParameter xParameter = new XParameter();
        xParameter.setName(string);
        xParameter.setType(element.getAttributeValue("type"));
        xParameter.setNullValue(element.getAttributeValue("null-value"));
        Element element2 = element.getChild("description");
        if (element2 != null) {
            xParameter.setDescription(element2.getText());
        }
        if (!xFinder.addParameter(xParameter)) {
            this.addError("DUPLICATE_PARAMETER", string, xFinder);
        }
    }

    private void addError(String string, AbstractXObject abstractXObject) {
        this.addError(string, null, abstractXObject);
    }

    private void addError(String string, Object object, AbstractXObject abstractXObject) {
        ParserError parserError = new ParserError(string, object, abstractXObject);
        __logger.error((Object)parserError.toString());
        this._error.add(parserError);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

