/*
 * Decompiled with CFR 0.152.
 */
package com.edb.stream;

import com.edb.Driver;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class EDBSQLOutput
implements SQLOutput {
    private String data = "";
    private int paramIndex = 0;

    public String toString() {
        return this.data;
    }

    private String getSeparator() {
        if (this.paramIndex > 0) {
            return ",";
        }
        return "";
    }

    public void writeArray(Array x) throws SQLException {
        this.writeString(x.toString());
    }

    public void writeAsciiStream(InputStream x) throws SQLException {
        this.writeBinaryStream(x);
    }

    public void writeBigDecimal(BigDecimal x) throws SQLException {
        this.data = this.data + this.getSeparator() + x.toString();
        ++this.paramIndex;
    }

    public void writeBinaryStream(InputStream x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void writeBlob(Blob x) throws SQLException {
        this.writeBinaryStream(x.getBinaryStream());
    }

    public void writeBoolean(boolean x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x + "'";
        ++this.paramIndex;
    }

    public void writeByte(byte x) throws SQLException {
        this.data = this.data + this.getSeparator() + Integer.toString(x);
        ++this.paramIndex;
    }

    public void writeBytes(byte[] x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void writeCharacterStream(Reader x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void writeClob(Clob x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void writeDate(Date x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x.toString() + "'";
        ++this.paramIndex;
    }

    public void writeDouble(double x) throws SQLException {
        this.data = this.data + this.getSeparator() + x;
        ++this.paramIndex;
    }

    public void writeFloat(float x) throws SQLException {
        this.data = this.data + this.getSeparator() + x;
        ++this.paramIndex;
    }

    public void writeInt(int x) throws SQLException {
        this.data = this.data + this.getSeparator() + x;
        ++this.paramIndex;
    }

    public void writeLong(long x) throws SQLException {
        this.data = this.data + this.getSeparator() + x;
        ++this.paramIndex;
    }

    public void writeObject(SQLData x) throws SQLException {
        this.data = this.data + "(";
        this.paramIndex = 0;
        x.writeSQL(this);
        this.data = this.data + ")";
    }

    public void writeRef(Ref x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void writeShort(short x) throws SQLException {
        this.data = this.data + this.getSeparator() + x;
        ++this.paramIndex;
    }

    public void writeString(String x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x + "'";
        ++this.paramIndex;
    }

    public void writeStruct(Struct x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void writeTime(Time x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x.toString() + "'";
        ++this.paramIndex;
    }

    public void writeTimestamp(Timestamp x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x.toString() + "'";
        ++this.paramIndex;
    }

    public void writeURL(URL x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x.toString() + "'";
        ++this.paramIndex;
    }
}

