/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.ssl;

import java.io.DataInputStream;
import java.io.IOException;
import net.sourceforge.jtds.ssl.Record;
import net.sourceforge.jtds.ssl.Sslv2ClientHelloRecord;
import net.sourceforge.jtds.ssl.TlsAlertRecord;
import net.sourceforge.jtds.ssl.TlsApplicationDataRecord;
import net.sourceforge.jtds.ssl.TlsChgCipherSpecRecord;
import net.sourceforge.jtds.ssl.TlsHandshakeRecord;
import net.sourceforge.jtds.util.BytesView;

class RecordFactory {
    RecordFactory() {
    }

    public static Record create(BytesView data) throws IOException {
        DataInputStream dis = new DataInputStream(data.getInputStream());
        byte contentType = dis.readByte();
        byte[] version = new byte[2];
        dis.read(version);
        short length = dis.readShort();
        if (!RecordFactory.isTlsRecord(contentType, length, data)) {
            return new Sslv2ClientHelloRecord(data);
        }
        if (contentType == 23) {
            return new TlsApplicationDataRecord(contentType, version, length, data);
        }
        if (contentType == 20) {
            return new TlsChgCipherSpecRecord(contentType, version, length, data);
        }
        if (contentType == 22) {
            return new TlsHandshakeRecord(contentType, version, length, data);
        }
        if (contentType == 21) {
            return new TlsAlertRecord(contentType, version, length, data);
        }
        return null;
    }

    private static boolean isTlsRecord(byte contentType, short length, BytesView data) {
        boolean isTlsType = contentType >= 20 && contentType <= 23;
        return isTlsType && length + 5 == data.getLength();
    }
}

