/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.ssl;

import java.io.DataInputStream;
import java.io.IOException;
import net.sourceforge.jtds.ssl.TlsHandshakeBody;
import net.sourceforge.jtds.util.BytesView;

class TlsHandshakeBodyFactory {
    TlsHandshakeBodyFactory() {
    }

    public static TlsHandshakeBody create(BytesView data) throws IOException {
        DataInputStream dis = new DataInputStream(data.getInputStream());
        byte handshakeType = dis.readByte();
        int ch1 = dis.readByte() & 0xFF;
        int ch2 = dis.readByte() & 0xFF;
        int ch3 = dis.readByte() & 0xFF;
        int length = (ch1 << 16) + (ch2 << 8) + (ch3 << 0);
        if (data.getLength() != length + 4) {
            return null;
        }
        return new TlsHandshakeBody(handshakeType, length);
    }
}

