/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.util;

import net.sourceforge.jtds.util.Logger;

public class SSPIJNIClient {
    private static SSPIJNIClient thisInstance = null;
    private static boolean libraryLoaded = false;
    private boolean initialized = false;

    private native void initialize();

    private native void unInitialize();

    private native byte[] prepareSSORequest();

    private native byte[] prepareSSOSubmit(byte[] var1, long var2);

    private SSPIJNIClient() {
    }

    public static SSPIJNIClient getInstance() throws Exception {
        if (thisInstance == null) {
            if (!libraryLoaded) {
                throw new Exception("Native SSPI library not loaded.");
            }
            thisInstance = new SSPIJNIClient();
            thisInstance.invokeInitialize();
        }
        return thisInstance;
    }

    public void invokeInitialize() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    public void invokeUnInitialize() {
        if (this.initialized) {
            this.unInitialize();
            this.initialized = false;
        }
    }

    public byte[] invokePrepareSSORequest() throws Exception {
        if (!this.initialized) {
            throw new Exception("SSPI Not Initialized");
        }
        return this.prepareSSORequest();
    }

    public byte[] invokePrepareSSOSubmit(byte[] buf) throws Exception {
        if (!this.initialized) {
            throw new Exception("SSPI Not Initialized");
        }
        return this.prepareSSOSubmit(buf, buf.length);
    }

    public static void main(String[] args) {
        try {
            System.out.println("instance request.");
            SSPIJNIClient client = new SSPIJNIClient();
            System.out.println("instance done..");
            System.out.println("init request..");
            client.invokeInitialize();
            System.out.println("init..done");
            System.out.println("preare req request..");
            byte[] str = client.invokePrepareSSORequest();
            SSPIJNIClient.hexDump(str);
            System.out.println("\nRequest.length: " + str.length);
            System.out.println("prepare done...");
            System.out.println("Submit: " + str);
            System.out.println("uninit request..");
            client.invokeUnInitialize();
            System.out.println("uninit done..");
        }
        catch (Error e) {
            System.out.println("Error occured");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Exception occured");
            e.printStackTrace();
        }
    }

    private static void hexDump(byte[] data) {
        int loc;
        int end;
        int off = 0;
        int len = data.length;
        int base = 10;
        System.out.println("Buffer.Size :" + len);
        if (off >= data.length) {
            off = data.length;
        }
        if ((end = off + len) >= data.length) {
            end = data.length;
        }
        if ((len = end - off) <= 0) {
            return;
        }
        int i = loc = off / 16 * 16;
        while (i < end) {
            int ch;
            int d;
            int v = base + loc;
            int j = 28;
            while (j >= 0) {
                d = v >>> j & 0xF;
                d = d < 10 ? d + 48 : d - 10 + 65;
                System.out.print((char)d);
                j -= 4;
            }
            System.out.print("  ");
            j = 0;
            while (i + j < off) {
                System.out.print(".. ");
                ++j;
            }
            while (j < 16 && i + j < end) {
                if (j == 8) {
                    System.out.print(' ');
                }
                d = (d = (ch = data[i + j] & 0xFF) >>> 4) < 10 ? d + 48 : d - 10 + 65;
                System.out.print((char)d);
                d = ch & 0xF;
                d = d < 10 ? d + 48 : d - 10 + 65;
                System.out.print((char)d);
                System.out.print(' ');
                ++j;
            }
            while (j < 16) {
                if (j == 8) {
                    System.out.print(' ');
                }
                System.out.print(".. ");
                ++j;
            }
            System.out.print(" |");
            j = 0;
            while (i + j < off) {
                System.out.print(' ');
                ++j;
            }
            while (j < 16 && i + j < end) {
                ch = data[i + j] & 0xFF;
                if (ch < 32 || ch >= 127 && ch < 160 || ch > 255) {
                    ch = 46;
                }
                System.out.print((char)ch);
                ++j;
            }
            while (j < 16) {
                System.out.print(' ');
                ++j;
            }
            System.out.println("|");
            i += 16;
            loc += 16;
        }
    }

    static {
        try {
            System.loadLibrary("ntlmauth");
            libraryLoaded = true;
        }
        catch (UnsatisfiedLinkError err) {
            Logger.println("Unable to load library: " + err);
        }
    }
}

