/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.lang.ref.PhantomReference;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.V3Query;

class SimpleQuery
implements V3Query {
    private final String[] fragments;
    private String statementName;
    private byte[] encodedStatementName;
    private PhantomReference cleanupRef;
    static final SimpleParameterList NO_PARAMETERS = new SimpleParameterList(0);

    SimpleQuery(String[] fragments) {
        this.fragments = fragments;
    }

    public ParameterList createParameterList() {
        if (this.fragments.length == 1) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.fragments.length - 1);
    }

    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.fragments[0]);
        for (int i = 1; i < this.fragments.length; ++i) {
            sbuf.append(parameters.toString(i));
            sbuf.append(this.fragments[i]);
        }
        return sbuf.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public void close() {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
            this.cleanupRef = null;
        }
    }

    public SimpleQuery[] getSubqueries() {
        return null;
    }

    String[] getFragments() {
        return this.fragments;
    }

    void setStatementName(String statementName) {
        this.statementName = statementName;
        this.encodedStatementName = statementName == null ? null : Utils.encodeUTF8(statementName);
    }

    String getStatementName() {
        return this.statementName;
    }

    byte[] getEncodedStatementName() {
        return this.encodedStatementName;
    }

    void setCleanupRef(PhantomReference cleanupRef) {
        this.cleanupRef = cleanupRef;
    }
}

