; -------------------------------------------------------------------------------------------------------------------------------
;
; Author: Mark Dootson
; eMail: mark.dootson@znix.com
;
; MDAC and DCOM install based on scripts by Michael Reitz  eMail: innosetup@assimilate.de
;
; This InnoSetup script installs the ODBC and OleDb clients for PostgreSQL together with DCOM and MDAC.
;
; MDAC and DCOM components are downloaded from the MS website as required.
;
; MDAC 2.8 Is not supported on Windows 95 although it will install. Unsupported software installed at your own risk etc.
;
; It may not be possible to install DCOM95 and MDAC in sequence (without a reboot between them) on Windows 95 systems,
; because Windows 95 comes without any DCOM version.
; Therefore MDAC is installed on Windows 95 systems by a HKCU\...\RunOnce registry entry after reboot, which requires
; that the same user (who executed the setup) logs in after the reboot for successfully installing MDAC.
; (It is not possible to use a HKLM\...\RunOnce entry, because there are timing problems with the after-reboot processes
;  of the DCOM installation.)
; The mdac_typ.exe file stays in the {%TEMP}/ {tmp} folder after installation.
; {%TEMP} and {tmp} are used alternatively as {tmp} may not exist on some versions.
;
; -------------------------------------------------------------------------------------------------------------------------------
; This script was created using ISTool for Inno Setup
; http://www.innosetup.com
; http://www.istool.org
; -------------------------------------------------------------------------------------------------------------------------------


[Setup]
OutputDir=..\setup\pgw32cli
OutputBaseFilename=pgw32cli-web
MinVersion=4.0,4.0
AdminPrivilegesRequired=true
CreateAppDir=true
DisableStartupPrompt=true
Uninstallable=true

AppName=PostgreSQL Win32 ODBC and OLEDB Clients
AppVerName=PG Clients 1.0.0.1
AppPublisher=Mark Dootson
AppPublisherURL=http://pgfoundry.org/projects/pgw32cli/
AppSupportURL=http://pgfoundry.org/projects/pgw32cli/
AppUpdatesURL=http://pgfoundry.org/projects/pgw32cli/
DefaultDirName={pf}\PgW32cli
;DefaultGroupName=PostgreSQL Win32 Clients
LicenseFile=..\pgw32cli\fulllicence.txt
Compression=lzma
SolidCompression=true
VersionInfoVersion=1.0.0.1
VersionInfoCompany=Mark Dootson
VersionInfoDescription=PG Win32 CLients 1.0.0.1
VersionInfoTextVersion=1.0.0.1
AppCopyright=Mark Dootson 2005
UserInfoPage=false
DefaultUserInfoSerial=1234567890
ShowLanguageDialog=no
ShowTasksTreeLines=true
AppID={{26065794-8C0A-47DE-9AC9-8A224059D44E}
UsePreviousUserInfo=false
UsePreviousAppDir=false
DisableProgramGroupPage=true
UsePreviousGroup=false
FlatComponentsList=false
UsePreviousSetupType=false
UsePreviousTasks=false
LanguageDetectionMethod=none
AppVersion=1.0.0.1
UninstallDisplayName=PostgreSQL Win32 Clients
InfoAfterFile=..\pgw32cli\after.txt
InfoBeforeFile=..\pgw32cli\Before.rtf
WizardImageFile=..\pgw32cli\largsetup.bmp
WizardSmallImageFile=..\pgw32cli\smallsetup.bmp

[Tasks]
Name: DCOM95; Description: DCOM 1.3 for Windows 95; Flags: checkedonce restart; MinVersion: 4.0,0; OnlyBelowVersion: 4.1,0
Name: DCOM98; Description: DCOM 1.3 for Windows 98; Flags: checkedonce; MinVersion: 4.1,0; OnlyBelowVersion: 4.9,0
Name: MDAC95; Description: Microsoft Data Access Components 2.8; Flags: checkedonce restart; MinVersion: 4.0,0; OnlyBelowVersion: 4.1,0
Name: MDAC; Description: Microsoft Data Access Components 2.8; Flags: checkedonce restart; MinVersion: 4.1,4.0; OnlyBelowVersion: 0,5.01.2600sp2

[Files]

Source: ..\Redist\PGCONNECT\libintl-2.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: OLEDB
Source: ..\Redist\PGCONNECT\libiconv-2.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: OLEDB
Source: ..\Redist\PGCONNECT\libpq.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: OLEDB
Source: ..\Redist\PGCONNECT\psqlodbc.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: ODBC
Source: ..\Redist\PGCONNECT\PgOleDb.dll; DestDir: {app}\libs; Flags: regserver sharedfile uninsneveruninstall replacesameversion; Components: OLEDB
Source: ..\Redist\OpenSSL\libeay32.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: OLEDB
Source: ..\Redist\OpenSSL\ssleay32.dll; DestDir: {app}\libs; Flags: sharedfile uninsneveruninstall replacesameversion; Components: OLEDB

[Registry]
; Delay MDAC installation on Win95 machines
Root: HKCU; Subkey: SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce; ValueType: string; ValueName: MDAC_Setup; ValueData: """{%TEMP}\MDAC_TYP.EXE"" /Q:A /C:""dasetup /Q:D /N"""; MinVersion: 4.0,0; OnlyBelowVersion: 4.1,0; Tasks: MDAC95
; PostgreSQL ODBC Settings
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\ODBC Drivers; ValueType: string; ValueName: PostgreSQL; ValueData: Installed; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: APILevel; ValueData: 1; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: ConnectFunctions; ValueData: YYN; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: Driver; ValueData: {app}\libs\psqlodbc.dll; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: DriverODBCVer; ValueData: 03.00; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: FileUsage; ValueData: 0; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: SQLLevel; ValueData: 1; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: string; ValueName: Setup; ValueData: {app}\libs\psqlodbc.dll; Components: ODBC
Root: HKLM; Subkey: SOFTWARE\ODBC\ODBCINST.INI\PostgreSQL; ValueType: dword; ValueName: UsageCount; ValueData: 1; Components: ODBC

[Run]
; START DCOM
Filename: {%TEMP}\DC95Inst.EXE; Parameters: /r:n /q:u; WorkingDir: {%TEMP}; Flags: skipifdoesntexist; Tasks: DCOM95; MinVersion: 4.0,0; OnlyBelowVersion: 4.1,0
Filename: {tmp}\dcom98.exe; Parameters: /r:n /q:u; WorkingDir: {tmp}; Flags: skipifdoesntexist; Tasks: DCOM98; MinVersion: 4.1,0; OnlyBelowVersion: 4.9,0
; END DCOM
; START MDAC 2.8 (see also: http://msdn.microsoft.com/library/default.asp?url=/library/en-us/mdacsdk/htm/wphistory_redistributemdac.asp)
Filename: {tmp}\MDAC_TYP.EXE; Parameters: "/Q:A /C:""dasetup /Q:D /N"""; WorkingDir: {tmp}; Flags: skipifdoesntexist; Tasks: MDAC; MinVersion: 4.1,4.0; OnlyBelowVersion: 0,5.01.2600sp2
; END MDAC 2.8
[Dirs]
Name: {app}\libs
[Components]
Name: OLEDB; Description: OLEDB Driver for PostgreSQL; Types: full
Name: ODBC; Description: ODBC Driver for PostgreSQL; Types: full

[_ISToolDownload]
Source: http://download.microsoft.com/download/c/d/f/cdfd58f1-3973-4c51-8851-49ae3777586f/MDAC_TYP.EXE; DestDir: {%TEMP}; DestName: MDAC_TYP.EXE; Tasks: MDAC95
Source: http://download.microsoft.com/download/c/d/f/cdfd58f1-3973-4c51-8851-49ae3777586f/MDAC_TYP.EXE; DestDir: {tmp}; DestName: MDAC_TYP.EXE; Tasks: MDAC
Source: http://download.microsoft.com/download/platformsdk/Redist/4.71.1015.0/W95/EN-US/DC95Inst.EXE; DestDir: {%TEMP}; DestName: DC95Inst.EXE; Tasks: DCOM95
Source: http://download.microsoft.com/download/d/1/3/d13cd456-f0cf-4fb2-a17f-20afc79f8a51/DCOM98.EXE; DestDir: {tmp}; DestName: DCOM98.EXE; Tasks: DCOM98

[Code]
// Function generated by ISTool.
function NextButtonClick(CurPage: Integer): Boolean;
begin
	Result := istool_download(CurPage);
end;
