/* $Id: heaptuple.h,v 1.4 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/tup.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/tup.h,v 1.2 2004/10/08 20:18:51 flaw
 * if/src/tup.h,v 1.13 2004/09/28 15:42:26 flaw
 *//*
 * Postgres HeapTuple interface for Python
 */
#ifndef PyPg_heaptuple_H
#define PyPg_heaptuple_H 0
#ifdef __cplusplus
extern "C" {
#endif

#define PyPgHeapTuple_HEAD	\
	PyObject_HEAD				\
	HeapTuple	ht_htup;		\
	PyObj			ht_desc;

typedef struct PyPgHeapTuple {
	PyPgHeapTuple_HEAD
} * PyPgHeapTuple;

extern PyTypeObject PyPgHeapTuple_Type;
PyObj PyPgHeapTuple_Initialize(PyObj, PyObj, HeapTuple);

#define PyPgHeapTuple_NEW() \
	((PyObj) PyPgHeapTuple_Type.tp_alloc(&PyPgHeapTuple_Type, 0))
#define PyPgHeapTuple_New(TD, HT) \
	(PyPgHeapTuple_Initialize(PyPgHeapTuple_NEW(), TD, HT))

#define PyPgHeapTuple_Check(OB) \
	(PyObject_TypeCheck(OB, &PyPgHeapTuple_Type))
#define PyPgHeapTuple_CheckExact(OB) \
	(OB->ob_type == &PyPgHeapTuple_Type)

#define PyPgHeapTuple(OB) ((PyPgHeapTuple) OB)

/* Fetch the HeapTuple from a PyPgHeapTuple */
#define PyPgHeapTuple_FetchHeapTuple(OB) \
	((HeapTuple) (PyPgHeapTuple(OB)->ht_htup))

/* Fetch the HeapTuple's Descriptor Object from a PyPgHeapTuple */
#define PyPgHeapTuple_FetchPyPgTupleDesc(SELF) \
	(PyPgHeapTuple(SELF)->ht_desc)
#define PyPgHeapTuple_FetchTupleDesc(SELF) \
	(PyPgTupleDesc_FetchTupleDesc(PyPgHeapTuple_FetchPyPgTupleDesc(SELF)))

#define PyPgHeapTuple_FixHeapTuple(SELF, HT) \
	(PyPgHeapTuple_FetchHeapTuple(SELF) = HT)
#define PyPgHeapTuple_FixPyPgTupleDesc(SELF, OB) \
	(PyPgHeapTuple_FetchPyPgTupleDesc(SELF) = OB)

#define PyPgHeapTuple_FetchOid(OB) \
	HeapTuple_FetchOid(PyPgHeapTuple_FetchHeapTuple(OB))
#define PyPgHeapTuple_FetchTableOid(OB) \
	HeapTuple_FetchTableOid(PyPgHeapTuple_FetchHeapTuple(OB))
#define PyPgHeapTuple_FetchNatts(OB) \
	HeapTuple_FetchNatts(PyPgHeapTuple_FetchHeapTuple(OB))
#define PyPgHeapTuple_FetchXmin(OB) \
	HeapTuple_FetchXmin(PyPgHeapTuple_FetchHeapTuple(OB))
#define PyPgHeapTuple_FetchXmax(OB) \
	HeapTuple_FetchXmax(PyPgHeapTuple_FetchHeapTuple(OB))
#define PyPgHeapTuple_FetchXvac(OB) \
	HeapTuple_FetchXvac(PyPgHeapTuple_FetchHeapTuple(OB))
#define PyPgHeapTuple_FetchCmin(OB) \
	HeapTuple_FetchCmin(PyPgHeapTuple_FetchHeapTuple(OB))
#define PyPgHeapTuple_FetchCmax(OB) \
	HeapTuple_FetchCmax(PyPgHeapTuple_FetchHeapTuple(OB))
#define PyPgHeapTuple_FetchTID(OB) \
	HeapTuple_FetchTID(PyPgHeapTuple_FetchHeapTuple(OB))

#define PyPgHeapTuple_FixTableOid(OB, OID) \
	HeapTuple_FixTableOid(PyPgHeapTuple_FetchHeapTuple(OB), OID)

/* Fetch an attribute's type oid */
#define PyPgHeapTuple_FetchAttrTypeOid(OB, ATT) \
	(PyPgHeapTuple_FetchTDOTD(OB)->attrs[ATT]->atttypid)

/* Fetch an attribute's type tuple */
#define PyPgHeapTuple_FetchAttrTTO(OB, ATT) \
	PyPgHeapTuple_FromTypeOid(PyPgHeapTuple_FetchAttrTypeOid(OB, ATT))

#define HeapTuple_FetchAttribute(ht, attn, td, isnull) \
	(attn < 0 || attn > td->natts) ? \
	(Datum) PyErr_Format(PyExc_IndexError, \
		"Tuple has no such attribute %d.", (int)attn) \
	: heap_getattr(ht, attn + 1, td, isnull)

#define PyPgHeapTuple_FetchAttribute(tup, attn, isnull) \
	HeapTuple_FetchAttribute(PyPgHeapTuple_FetchHeapTuple(self), attn, \
			PyPgHeapTuple_FetchTDOTD(self), isnull)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_heaptuple_H */
/*
 * vim: ts=3:sw=3:noet:
 */
