/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBFUNCTIONMANAGER_H
#define DBFUNCTIONMANAGER_H

#include <string>
#include "../../exceptions/sqlexception.h"
#include "../types/dbtypemanager.h"
#include "dbfunctionset.h"
#include "../dbconnection.h"
#include "../dbbasemanager.h"

/**
 * This class is used to manage operations concerning database tables. The class
 * provides many generic functions that can be used to retrieve/create/modify
 * database functions (stored procedures).
 */
class DBFunctionManager : public DBBaseManager
{
protected:

	DBTypeManager m_oDBTypeMgr;
					
public:

	/**
 	 * Constructor
   */		
  DBFunctionManager();

	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBFunctionManager(DBConnection *poDBConn);
	
	/**
 	 * Destructor
   */		
	~DBFunctionManager();

	/**
	 * Used to set the database connection object
	 * @param poDBConn
	 */
	void setDBConnection(DBConnection * poDBConn);
				
	/**
	 * Used to retrieve the list of functions for this connection.
	 * @return	a DBFunctionSet object that contains the function details
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void retrieveListOfFunctions(DBFunctionSet & roDBFunctionSet) throw (SQLException, DBConnectionException);

	/**
	 * Used to modify the function comment.
	 * @param			rstrFunctionName		the function name
	 * @param			rvstrArgumentTypes	the list of argument types
	 * @param			rstrComment					the comment to set for the function
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void modifyFunctionComment(const string & rstrFunctionName, const vector<string> & rvstrArgumentTypes,
				const string & rstrComment)
				throw (SQLException, DBConnectionException);			
			
};

#endif

