/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBTABLE_H
#define DBTABLE_H

#include <string>

/**
 * This class is used to represent a database table.
 */
class DBTable
{

protected:
	string m_strTableName;
	string m_strTableComment;
	string m_strTableOwner;
				
public:
	
	/**
 	 * Constructor
   */		
	DBTable();
	
	/**
 	 * Destructor
   */		
	~DBTable();

	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void clear();
		
	/**
 	 * Used to set the table name.
   */			    	
	void setTableName(const string &rstrTableName);

	/**
 	 * Used to retrieve the table name.
   */			    			
	const string & getTableName() const;

	/**
 	 * Used to set the table comment.
   */			    						
	void setTableComment(const string &rstrComment);

	/**
 	 * Used to retrieve the table comment.
   */			    			
	const string & getTableComment() const;			

	/**
 	 * Used to set the table owner.
   */			    						
	void setTableOwner(const string &rstrOwner);

	/**
 	 * Used to retrieve the table owner.
   */			    			
	const string & getTableOwner() const;			
	
};

#endif

