/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbviewset.h"
#include "../dbconnection.h"
#include "../../utils/debugger.h"

	/**
 	 * Constructor 	
   */		
  DBViewSet::DBViewSet()
  {
  	// do nothing
  } // end constructor
	
	/**
 	 * Destructor
   */		
	DBViewSet::~DBViewSet()
	{
		// do nothing
	} // end destructor

	/**
	 * Used to indicate if the record set is empty.
	 * @return	true if record set is empty, false otherwise
	 */
	bool DBViewSet::isEmpty()
	{
		return m_oViewList.isEmpty();
	} // end isEmpty

	/**
	 * Used to get the current index location.
	 * @return	the current index
	 */
	int DBViewSet::getCurrentIndex()
	{
		return m_oViewList.getCurrentIndex();
	} // end getCurrentIndex
		
	/**
	 * Used to move to the next record in the record set. This function must be called before
	 * the first result can be retrieved. When a record set is initially set, the internal
	 * pointer points to a location before the first record. The reason for this is so that
	 * the record set may sit in a while loop with calls to next indicating if more records
	 * are to come. The function returns true when more records exist and false when no more
	 * records are to come.
	 *
	 * @return	true when more records to come, false when no more records
	 */
	bool DBViewSet::next()
	{
		return m_oViewList.next();	
	} // end next

	/**
	 * Used to move to the previous record in the record set. The function returns true when
	 * a previous record exists, it will return false when the begining of the set is reached.
	 *
	 * @return	true when previous record exists, false when first record reached (or when empty record set)
	 */
	bool DBViewSet::previous()
	{
		return m_oViewList.previous();
	} // end previous

	/**
	 * Used to move the cursor back to a position before the first record. This is used when
	 * the recordset needs to be used but then reset, so that next() function can be used
	 * correctly.
	 */
	void DBViewSet::reset()
	{
		m_oViewList.reset();
	} // end reset
	
	/**
	 * Used to move to the first record.
	 * @exception	throws NoRecordException when empty record
	 */
	void DBViewSet::first() throw (NoRecordException)
	{
		return m_oViewList.first();
	} // end first

	/**
	 * Used to move to the last record.
	 * @exception	throws NoRecordException when empty record	
	 */
	void DBViewSet::last() throw (NoRecordException)
	{
		return m_oViewList.last();	
	} // end last
				
	/**
	 * Used to get the number of records in this record set.
	 * @return 	the number of records
	 */
	int DBViewSet::getRecordCount()
	{
		return m_oViewList.getRecordCount();		
	} // end getRecordCount

	/**
	 * Used to get the current view.
	 * @param	roDBView the a DBView object used to return output for current record
	 * @exception	throws NoRecordException when empty record	
	 */
	void DBViewSet::getDBView(DBView & roDBView) throw (NoRecordException)
	{
		string strMethodName = "DBViewSet::getDBView";
		
		Debugger::entered(strMethodName);
		
		if (isEmpty())
		{
			throw NoRecordException("Cannot retrieve DBView object, no records exist.", "DBViewSet", "getDBView");
		} // end if empty
		try
		{
			roDBView.setViewName(m_oViewList.getFieldValue("viewname"));
			roDBView.setViewComment(m_oViewList.getFieldValue("comment"));			
			roDBView.setViewOwner(m_oViewList.getFieldValue("viewowner"));						
			roDBView.setDefinition(m_oViewList.getFieldValue("definition"));									
		} // end try
		catch (VPException e)
		{
			Debugger::logException(strMethodName, e);
		} // end catch	
		
		Debugger::exited(strMethodName);
		
	} // end getDBTable

