/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include <qlineedit.h>
#include "databaseconnectform.h"
#include "databaseitempopup.h"
#include "databaselistviewitem.h"
#include "mainlistview.h"
#include "../utils/debugger.h"
#include "../utils/stringutils.h"
#include "common/infodialogs.h"

	/**
 	 * Constructor
   */		
  DatabaseConnectForm::DatabaseConnectForm(QWidget* pqoParent, bool bAutoConnect, bool bModal)
  	: UicDatabaseConnectForm(pqoParent, 0, bModal)
  {
  	m_bAutoConnect = bAutoConnect;
		// lets update all the database fields
  	DatabaseListViewItem *poDatabaseListViewItem = ((DatabaseItemPopup*)parentWidget())->getDatabaseListViewItem();
		
  	QString qstrTemp = (poDatabaseListViewItem->getDatabaseName()).c_str();
  	m_pqtxtDatabase->setText(qstrTemp);  	
  	qstrTemp = (poDatabaseListViewItem->getUserName()).c_str();  	
  	m_pqtxtUserName->setText(qstrTemp);  			
  	qstrTemp = (poDatabaseListViewItem->getPassword()).c_str();  	  	
  	m_pqtxtPassword->setText(qstrTemp);  	
  	
  } // end constructor

	/**
	 * This method is used to make a database connection.
	 */
	void DatabaseConnectForm::saveConnectDetails()
	{
		string strMethodName = "DatabaseConnectForm::saveConnectDetails";
		Debugger::entered(strMethodName);
		
  	// lets get the connection properties
  	DatabaseListViewItem *poDatabaseListViewItem = ((DatabaseItemPopup*)parentWidget())->getDatabaseListViewItem();
		poDatabaseListViewItem->setText(0, m_pqtxtDatabase->text());  	
		poDatabaseListViewItem->setDatabaseName((m_pqtxtDatabase->text()).latin1());  	
		poDatabaseListViewItem->setUserName((m_pqtxtUserName->text()).latin1());  			
		poDatabaseListViewItem->setPassword((m_pqtxtPassword->text()).latin1());  					
  	  	
  	// set password has been entered
  	poDatabaseListViewItem->setPasswordEntered(true);
  	// update the details
  	poDatabaseListViewItem->updateDescription();		  	
		// lets signal to change the description
		((MainListView*)(poDatabaseListViewItem->listView()))->changeItemDescription(poDatabaseListViewItem);
  	
		// lets see if auto-connect has been specified
		if (m_bAutoConnect == true)
		{
			try
			{
				poDatabaseListViewItem->connect();
			} // end try to connect
			catch (DBConnectionException e)
			{
  			Debugger::logException(strMethodName, e);
  			// report error to user
  			InfoDialogs::infoDBConnectionException(this, e);
				// lets close up the expanded list
	  		poDatabaseListViewItem->setExpanded(false);
  			// set to be not open		  	
  			poDatabaseListViewItem->setOpen(false);	  	
				
			} // end catch database connection exception
			
		} // end if auto-connect is ON  	
  	close(true);	// lets close the form
		Debugger::exited(strMethodName);  	
	} // end saveConnectDetails

	/**
	 * This method is used to close the form.
	 */
	void DatabaseConnectForm::closeForm()
	{
		// lets tell the database list view item not to connect
		if (m_bAutoConnect == true)
		{
	  	DatabaseListViewItem *poDatabaseListViewItem = ((DatabaseItemPopup*)parentWidget())->getDatabaseListViewItem();			
	  	// set password as not entered
  		poDatabaseListViewItem->setPasswordEntered(false);		  	
	  	// set to be not expanded yet
  		poDatabaseListViewItem->setExpanded(false);
  		// set to be not open		  	
  		poDatabaseListViewItem->setOpen(false);	  	
		} // end if auto-connect on
		close(true);
	} // end closeForm
	