/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "sequencegroupitempopup.h"
#include "sequencegrouplistviewitem.h"

	/**
	 * Constructor
	 */
	SequenceGroupItemPopup::SequenceGroupItemPopup(QWidget *pqoParent, SequenceGroupListViewItem *poSequenceGroupItem)
		: QPopupMenu(pqoParent)
	{
		m_poSequenceGroupItem = poSequenceGroupItem;	// keep a reference to the Sequence group item
		
		// setup all the items and their slots
		//insertSeparator();
		insertItem("Refresh", this, SLOT(refreshListOfSequences()));		
	} // end constructor

	/**
	 * Used to access the Sequence group list view item.
	 */
	SequenceGroupListViewItem * SequenceGroupItemPopup::getSequenceGroupListViewItem() const
	{
		return m_poSequenceGroupItem;
	} // end getViewGroupListViewItem
	
	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the view list.
   */	
	void SequenceGroupItemPopup::refreshListOfSequences()
	{
		// lets refresh the list as requested
		m_poSequenceGroupItem->refreshList();
	} // end refreshListOfSequences
