/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef XMLUTILS_H
#define XMLUTILS_H

#include <qdom.h>
#include <qstring.h>
#include "../exceptions/xmlparseexception.h"
#include "../exceptions/openfileexception.h"

/**
 * This class contains some xml manipulation utilities.
 */
class XmlUtils
{
				
public:	
		
	/**
 	 * Used to parse an xml file and converts this into a QDomDocument object.
 	 * @param		rqstrFileName 	the file name that is to be open and parsed
 	 * @param		rqoXmlDoc				the output Dom object
 	 * @exception	XmlParseException	is thrown if the document cannot be parsed
 	 * @exception FileNotFoundException is thrown if the file does not exist
   */			    	
	static void parseXmlFile(const QString & rqstrFileName, QDomDocument & rqoXmlDoc)
			throw (XmlParseException, OpenFileException);

	/**
 	 * Used to save an xml document into a file.
 	 * @param		rqstrFileName 	the file name that is to be open and saved into
 	 * @param		rqoXmlDoc				the Dom object that is to written out to file
 	 * @exception FileNotFoundException is thrown if the file cannot be created/opened
   */			    	
	static void saveXmlDocument(const QString & rqstrFileName, QDomDocument & rqobjXmlDoc)
			throw (OpenFileException);
										
};


#endif

