/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef FUNCTIONITEMPOPUP_H
#define FUNCTIONITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "functionlistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a function item in the list viewer.
 */
class FunctionItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	FunctionListViewItem * m_poFunctionListViewItem;	
	
public:
	/**
	 * Constructor
	 */
	FunctionItemPopup(QWidget *pqoParent, FunctionListViewItem *poFunctionListViewItem);

	/**
	 * Used to get a reference to the function item that this popup was generated from.
	 */
	FunctionListViewItem * getFunctionListViewItem() const;
	
protected slots:	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void editComment();
	
private:

};


#endif

