/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBMASTERMANAGER_H
#define DBMASTERMANAGER_H

#include <string>
#include "dbbasemanager.h"
#include "tables/dbtablemanager.h"
#include "tables/indicies/dbindexmanager.h"
#include "tables/triggers/dbtriggermanager.h"
#include "tables/foreignkeys/dbforeignkeymanager.h"
#include "views/dbviewmanager.h"
#include "functions/dbfunctionmanager.h"
#include "sequences/dbsequencemanager.h"

/**
 * This class holds a reference to all the db managers. This class will allow
 * references to database managers and database connections to be more easily passed
 * between objects.
 */
class DBMasterManager : public DBBaseManager
{
protected:
	DBTableManager m_oDBTableMgr;
	DBIndexManager m_oDBIndexMgr;
	DBTriggerManager m_oDBTriggerMgr;
	DBForeignKeyManager m_oDBForeignKeyMgr;
	DBViewManager m_oDBViewMgr;
	DBFunctionManager m_oDBFunctionMgr;
	DBSequenceManager m_oDBSequenceMgr;
					
public:

	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBMasterManager();
	
	/**
 	 * Destructor
   */		
	~DBMasterManager();

	/**
	 * Used to set the database connection object of itself and its managers.
	 * This method overrides its parent.
	 * @param poDBConn
	 */
	void setDBConnection(DBConnection * poDBConn);
		
	/**
	 * Used to get a pointer reference to a table manager
	 * @return a pointer to a table manager
	 */
	DBTableManager * getDBTableManager();

	/**
	 * Used to get a pointer reference to a index manager
	 * @return a pointer to a index manager
	 */
	DBIndexManager * getDBIndexManager();

	/**
	 * Used to get a pointer reference to a trigger manager
	 * @return a pointer to a trigger manager
	 */
	DBTriggerManager * getDBTriggerManager();
			
	/**
	 * Used to get a pointer reference to a foreign key manager
	 * @return a pointer to a foreign key manager
	 */
	DBForeignKeyManager * getDBForeignKeyManager();

	/**
	 * Used to get a pointer reference to a view manager
	 * @return a pointer to a view manager
	 */
	DBViewManager * getDBViewManager();
	
	/**
	 * Used to get a pointer reference to a function manager
	 * @return a pointer to a function manager
	 */
	DBFunctionManager * getDBFunctionManager();

	/**
	 * Used to get a pointer reference to a sequence manager
	 * @return a pointer to a sequence manager
	 */
	DBSequenceManager * getDBSequenceManager();
				
};

#endif

