/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef INFODIALOGS_H
#define INFODIALOGS_H

#include <qwidget.h>
#include "../../exceptions/sqlexception.h"
#include "../../exceptions/dbconnectionexception.h"

/**
 * This class contains static methods used to display generic info dialogs.
 */
class InfoDialogs
{										 			
public:
	
  /**
   * This method is used to display an error message when a SQL exception occurs.
   */
  static void infoSQLException(QWidget * pqoParent, const SQLException & roSQLException);

  /**
   * This method is used to display an error message when a database connection exception occurs.
   */
  static void infoDBConnectionException(QWidget * pqoParent, const DBConnectionException & roDBConnectionException);
	 	
};


#endif


