/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "comboboxtableitem.h"	
#include <qcombobox.h>

	/**
	 * Constructor
	 */
	ComboBoxTableItem::ComboBoxTableItem(QTable * pqtblParent, EditType nEditType, const QString & rqstrText)
		: QTableItem(pqtblParent, nEditType, rqstrText)
	{
		m_bManualEdit = true;
	} // end constructor		

	/**
	 * Sets the selection list for the combo box.
	 */
	void ComboBoxTableItem::setStringList(QStringList rqoStringList)
	{
		m_qoStringList = rqoStringList;
	} // end setStringList

	/**
	 * Sets the if manual editing is allowed.
	 */
	void ComboBoxTableItem::setManualEdit(bool bManualEdit)
	{
		m_bManualEdit = bManualEdit;
	} // end setManualEdit
		
	/**
	 * Overrided implementation from QTableItem
	 */
	QWidget * ComboBoxTableItem::createEditor() const
	{
		QComboBox * pqcbxOptionList = new QComboBox(m_bManualEdit, table()->viewport());
		pqcbxOptionList->insertStringList(m_qoStringList);
		// look for current text
		bool bFound = false;
		for (int nStrIdx = 0; nStrIdx < pqcbxOptionList->count(); nStrIdx++)
		{
			if (pqcbxOptionList->text(nStrIdx) == text())
			{
				pqcbxOptionList->setCurrentItem(nStrIdx);
				bFound = true;
				break;
			} // end if this is the selected text
		} // end for look for selected string
		if (bFound == false && m_bManualEdit == true)
		{
			pqcbxOptionList->setEditText(text());
		}			
		return pqcbxOptionList;
	} // end createEditor
	
	/**
	 * Overrided implementation from QTableItem
	 */
	void ComboBoxTableItem::setContentFromEditor(QWidget * pqoWidget)
	{
		setText(((QComboBox*)pqoWidget)->currentText());
	} // end setContentFromEditor


