/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef SERVERITEMPOPUP_H
#define SERVERITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "serverlistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a server item in the list viewer.
 */
class ServerItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	ServerListViewItem * m_poServerListViewItem;	
	
public:
	/**
	 * Constructor
	 */
	ServerItemPopup(QWidget *pqoParent, ServerListViewItem *poServerListViewItem);

	/**
	 * Used to get a reference to the database item that this popup was generated from.
	 */
	ServerListViewItem * getServerListViewItem() const;
	
protected slots:
	/**
 	 * This slot is called by the popup menu itself when new database is called
   */	
	void createDatabaseItem();
	
	/**
 	 * This slot is called by the popup menu itself when edit properties is selected.
   */	
	void editProperties();

	/**
	 * This slot is called by the popup menu itself when delete server is selected.
	 */
	void deleteServerItem();
		
};


#endif

