/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "serverpropertiesform.h"
#include "serverlistviewitem.h"
#include "serveritempopup.h"
#include "mainlistview.h"
#include <qlineedit.h>
#include <qcheckbox.h>

	/**
 	 * Constructor
   */		
  ServerPropertiesForm::ServerPropertiesForm(QWidget* pqoParent)
  	: UicServerPropertiesForm(pqoParent)
  {
		// lets update all the server fields
  	ServerListViewItem *poServerListViewItem = ((ServerItemPopup*)parentWidget())->getServerListViewItem();
		
  	QString qstrTemp = (poServerListViewItem->getServerName()).c_str();
  	m_pqtxtServerName->setText(qstrTemp);  	
  	m_pqchkLocalServer->setChecked(poServerListViewItem->isLocalServer());
		m_pqtxtPortNumber->setText(qstrTemp.setNum(poServerListViewItem->getPortNumber()));

  } // end constructor

	/**
	 * This method is used to save server properties.
	 */
	void ServerPropertiesForm::saveServerProperties()
	{
		// lets update all the server fields
  	ServerListViewItem *poServerListViewItem = ((ServerItemPopup*)parentWidget())->getServerListViewItem();
		
  	poServerListViewItem->setServerName((m_pqtxtServerName->text()).latin1());  	
  	poServerListViewItem->setLocalServer(m_pqchkLocalServer->isChecked());
		poServerListViewItem->setPortNumber((m_pqtxtPortNumber->text()).toInt());
		
		// lets update the list view name
		poServerListViewItem->setText(0, m_pqtxtServerName->text());
		
  	// update the details
  	poServerListViewItem->updateDescription();		  	
		// lets signal to change the description
		((MainListView*)(poServerListViewItem->listView()))->changeItemDescription(poServerListViewItem);
		
		close(true);	// lets close the form
		
	} // end saveServerProperties

	/**
	 * This method is used to close the form.
	 */
	void ServerPropertiesForm::closeForm()
	{
		close(true);
	} // end closeForm