/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "sequencelistviewitem.h"
#include "sequenceitempopup.h"
#include "../../utils/stringutils.h"
#include "../../utils/debugger.h"
#include "../common/constants.h"
#include <iostream.h>

	SequenceListViewItem::SequenceListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBSequence(), DBMasterManagerRef()
	{
	} // end constructor

	SequenceListViewItem::SequenceListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBSequence(), DBMasterManagerRef()
	{
	} // end constructor

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void SequenceListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		string strMethodName = "SequenceListViewItem::showRightPressedMenu";
		Debugger::entered(strMethodName);
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new SequenceItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
		Debugger::exited(strMethodName);
	} // end showRightPressedMenu		
		
	/**
 	 * Used to update the description.
   */			    	
	void SequenceListViewItem::updateDescription()
	{
 		// format string to appear on description
 		string strOutputDesc = "<h1>Sequence</h1><hr><p><strong>Name</strong><br>"
 														+ StringUtils::htmlstr(getSequenceName()) +
 														"</p><p><strong>Comment</strong><br>";
 		if (getSequenceComment().size() == 0)
 		{
 			strOutputDesc += StringUtils::htmlstr(Constants::NO_COMMENT);
 		} // end if no comment															
 		else
 		{
 			strOutputDesc	+= StringUtils::htmlstr(getSequenceComment());
 		} // end else comment exists
			
 		strOutputDesc +=				"</p><p><strong>Owner</strong><br>"
 														+ getSequenceOwner() + "</p>";
 		m_qstrDescription = strOutputDesc.c_str();
	
	} // end updateDescription
			
