/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "tableitempopup.h"
#include "tablelistviewitem.h"
#include "tableschemaform.h"
#include "droptableform.h"
#include "../common/commentform.h"
#include "../../utils/debugger.h"

	/**
	 * Constructor
	 */
	TableItemPopup::TableItemPopup(QWidget *pqoParent, TableListViewItem *poTableListViewItem)
		: QPopupMenu(pqoParent)
	{
		m_poTableListViewItem = poTableListViewItem;	// keep a reference to the table item
		
		// setup all the items and their slots
		insertItem("View/Edit Schema", this, SLOT(editTableSchema()));
		//insertItem("View Data", this, SLOT(viewTableData()));		
		insertItem("View/Edit Comment", this, SLOT(editComment()));
		insertSeparator();
		insertItem("Drop Table", this, SLOT(dropTableSchema()));												
	} // end constructor

	/**
	 * Destructor
	 */
	TableItemPopup::~TableItemPopup()
	{
		string strMethodName = "TableItemPopup::~TableItemPopup";
		Debugger::entered(strMethodName);
		Debugger::exited(strMethodName);
	} // end destructor
	
	/**
	 * Used to get a reference to the table item that this popup was generated from.
	 */
	TableListViewItem * TableItemPopup::getTableListViewItem() const
	{
		return m_poTableListViewItem;
	} // end getTableListViewItem
	
	/**
 	 * This slot is called by the popup menu itself when view/edit schema is selected.
   */	
	void TableItemPopup::editTableSchema()
	{
		// bring up schema viewer
		TableSchemaForm *poTableSchemaForm = new TableSchemaForm(this, *((m_poTableListViewItem->getDBMasterManager())->getDBConnection()), m_poTableListViewItem->getTableName());		
		poTableSchemaForm->getSchemaDetails();
		poTableSchemaForm->show();		
	} // end editTableSchema

	/**
 	 * This slot is called by the popup menu itself when drop schema is selected.
   */	
	void TableItemPopup::dropTableSchema()
	{
		// bring up drop table prompt
		DropTableForm *poDropTableForm = new DropTableForm(this, *((m_poTableListViewItem->getDBMasterManager())->getDBConnection()), m_poTableListViewItem->getTableName());		
		poDropTableForm->show();			
	} // end dropTableSchema
		
	/**
	 * This slot is called by the popup menu itself when view data is selected.
	 */
	void TableItemPopup::viewTableData()
	{
	} // end viewTableData
	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void TableItemPopup::editComment()
	{
		// bring up edit comment form
		CommentForm *poCommentForm = new CommentForm(this, *((m_poTableListViewItem->getDBMasterManager())->getDBConnection()), CommentForm::TableComment);
		poCommentForm->setObjectName(m_poTableListViewItem->getTableName());		
		poCommentForm->setComment(m_poTableListViewItem->getTableComment().c_str());
		poCommentForm->show();				
	} // end editComment

