/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "triggergrouplistviewitem.h"
#include "triggerlistviewitem.h"
#include "triggergroupitempopup.h"
#include "../../common/infodialogs.h"
#include "../../../utils/debugger.h"

#include <iostream.h>

	TriggerGroupListViewItem::TriggerGroupListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBMasterManagerRef()
	{
		m_strTableName = "";
		QString qstrTriggers("Triggers");
		setText(0, qstrTriggers);
		m_qstrDescription = "<h1>Triggers</h1><hr><p>Lists all the triggers for this database table.</p>";		
	} // end constructor

	TriggerGroupListViewItem::TriggerGroupListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBMasterManagerRef()
	{
		m_strTableName = "";
		QString qstrTriggers("Triggers");
		setText(0, qstrTriggers);
		m_qstrDescription = "<h1>Triggers</h1><hr><p>Lists all the triggers for this database table.</p>";		
	} // end constructor

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void TriggerGroupListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		string strMethodName = "TriggerGroupListViewItem::showRightPressedMenu";
		Debugger::entered(strMethodName);
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new TriggerGroupItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
		Debugger::exited(strMethodName);
	} // end showRightPressedMenu		
	
	/**
 	 * Used to set the table name.
 	 * @param rstrTableName	the table name
   */			    	
	void TriggerGroupListViewItem::setTableName(const string & rstrTableName)
	{
		m_strTableName = rstrTableName;
	} // end setTableName
					
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	void TriggerGroupListViewItem::initChildren()
	{	
		string strMethodName = "TriggerGroupListViewItem::initChildren";	
		
		Debugger::entered(strMethodName);
		
		DBTriggerSet oDBTriggerSet;
		
		try
		{		
			getDBMasterManager()->getDBTriggerManager()->retrieveListOfTriggers(m_strTableName, oDBTriggerSet);
		} // end try
		catch (SQLException e)
		{
			Debugger::logException(strMethodName, e);
			// report error to user
			InfoDialogs::infoSQLException(listView(), e);			
			return;
		} // end catch
		while (oDBTriggerSet.next())
		{
			TriggerListViewItem *poTriggerItem = new TriggerListViewItem(this);
			// retrieve trigger details
			oDBTriggerSet.getDBTrigger(*poTriggerItem);
			poTriggerItem->setText(0, QString(poTriggerItem->getTriggerName().c_str()));					
			// set master manager
			poTriggerItem->setDBMasterManager(getDBMasterManager());
			poTriggerItem->updateDescription();
		} // end while more

		Debugger::exited(strMethodName);
	} // end initChildren
	