/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBVIEWMANAGER_H
#define DBVIEWMANAGER_H

#include <string>
#include "../../exceptions/sqlexception.h"
#include "dbviewset.h"
#include "../dbconnection.h"
#include "../dbbasemanager.h"

/**
 * This class is used to manage operations concerning database tables. The class
 * provides many generic functions that can be used to retrieve/create/modify
 * database views.
 */
class DBViewManager : public DBBaseManager
{
					
public:

	/**
 	 * Constructor
   */		
  DBViewManager();

	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBViewManager(DBConnection *poDBConn);
	
	/**
 	 * Destructor
   */		
	~DBViewManager();
			
	/**
	 * Used to retrieve the list of views for this connection.
	 * @return	a DBViewSet object that contains the view details
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void retrieveListOfViews(DBViewSet & roDBViewSet) throw (SQLException, DBConnectionException);

	/**
	 * Used to modify the view comment.
	 * @param			rstrViewName		the name of the view
	 * @param			rstrComment			the comment to set for the view
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void modifyViewComment(const string & rstrViewName, const string & rstrComment)
				throw (SQLException, DBConnectionException);			
};

#endif

