/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef MAINLISTVIEW_H
#define MAINLISTVIEW_H

#include <qlistview.h>
#include <qstring.h>

/**
 * The main list view.
 */
class MainListView: public QListView
{
	Q_OBJECT
public:
	/**
	 * Constructor
	 */
	MainListView(QWidget *pqoParent);

public slots:

	/**
 	 * This slot should be called when a list item is left pressed. The function should signal to
 	 * the text browser widget that the description needs to be updated.
   *
   * @param 	*pqoListViewItem	the item that was left pressed
   */	
	void changeItemDescription(QListViewItem *pqoListViewItem);
	
	/**
	 * This slot is used to add a new group item.
	 */
	void addGroupItem();
	
protected slots:
	/**
 	 * This slot should be called when a list item is right pressed. The function should call the
 	 * showRightClickedMenu function from the list view item. Also sets the text of the browser
 	 * text widget.
   *
   * @param 	*pqoListViewItem	the item that was right pressed
   * @param		rqoPoint					the point at which the item was clicked
   * @param		nColumn						the column the item belongs to
   */
	void showRightPressedMenu(QListViewItem *pqoListViewItem, const QPoint & rqoPoint, int nColumn);
			
	/**
 	 * This slot should be called when a list item is expanded. The function should call the
 	 * set the initGrandChildren function of the item. This will tell the children to prepare to be
 	 * viewed.
   *
   * @param 	*pqoListViewItem	the item that was expanded
   */		
	void prepareGrandChildren(QListViewItem *pqoListViewItem);		

signals:
	/**
	 * This signal is used to tell another widget that the item description needs to be updated.
	 */
	void itemDescriptionChanged(const QString & rqstrDescription);
	
};


#endif
