/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbindex.h"

	/**
 	 * Constructor
   */		
	DBIndex::DBIndex()
	{
		clear();
	} // end constructor
	
	/**
 	 * Destructor
   */		
	DBIndex::~DBIndex()
	{
	} // end destructor

	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void DBIndex::clear()
	{
		m_strIndexName = "";
		m_strTableName = "";
		m_strIndexComment = "";
		m_bUnique = false;
		m_bPrimary = false;
		m_vstrIndexedColumns.clear();
	} // end clear
	
	/**
 	 * Used to add an indexed column to the list.
   */			    			
	void DBIndex::addIndexedColumn(const string & rstrIndexedColumn)
	{
		m_vstrIndexedColumns.push_back(rstrIndexedColumn);
	} // end addIndexedColumn
	
	/**
 	 * Used to retrieve an indexed column.
   */			    			
	const string & DBIndex::getIndexedColumn(int nColumnIndex) const throw (IndexOutOfRangeException)
	{
		if (nColumnIndex < 0 || nColumnIndex >= getNumberOfColumns())
		{
			throw IndexOutOfRangeException("Index out of range.", "DBIndex", "getIndexedColumn");					
		} // end if out of range
		return m_vstrIndexedColumns[nColumnIndex];
	
	} // end getIndexedColumn
	
	/**
	 * Used to get the number columns for this index.
	 */
	int DBIndex::getNumberOfColumns() const
	{
		return m_vstrIndexedColumns.size();
	} // end getNumberOfColumns 			
			
	/**
 	 * Used to set the table name.
   */			    	
	void DBIndex::setTableName(const string &rstrTableName)
	{
		m_strTableName = rstrTableName;
	} // end setTableName

	/**
 	 * Used to retrieve the table name.
   */			    			
	const string & DBIndex::getTableName() const
	{
		return m_strTableName;
	} // end getTableName

	/**
 	 * Used to set the index name.
   */			    						
	void DBIndex::setIndexName(const string &rstrIndexName)
	{
		m_strIndexName = rstrIndexName;
	} // end setIndexName

	/**
 	 * Used to retrieve the index name.
   */			    			
	const string & DBIndex::getIndexName() const
	{
		return m_strIndexName;
	} // end getIndexName			

	/**
 	 * Used to set the index comment.
   */			    						
	void DBIndex::setIndexComment(const string &rstrIndexComment)
	{
		m_strIndexComment = rstrIndexComment;
	} // end setIndexComment

	/**
 	 * Used to retrieve the index comment.
   */			    			
	const string & DBIndex::getIndexComment() const
	{
		return m_strIndexComment;
	} // end getIndexComment
	
	/**
 	 * Used to set the unique property.
   */			    						
	void DBIndex::setUnique(bool bUnique)
	{
		m_bUnique = bUnique;
	} // end setIsUnique

	/**
 	 * Used to get the unique property.
   */			    						
	bool DBIndex::isUnique()
	{
		return m_bUnique;
	} // end isUnique
	
	/**
 	 * Used to set the primary key property.
   */			    						
	void DBIndex::setPrimary(bool bPrimary)
	{
		m_bPrimary = bPrimary;
	} // end setIsPrimary

	/**
 	 * Used to get the primary key property.
   */			    						
	bool DBIndex::isPrimary()
	{
		return m_bPrimary;
	} // end isPrimary

