/* $PostgresPy: if/src/utils.h,v 1.14 2004/07/27 09:18:39 flaw Exp $
 * 
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Postgres utilities header.
 */
#ifndef PyPg_UTILS_H
#define PyPg_UTILS_H "utils.h"
#ifdef __cplusplus
extern "C" {
#endif

void PySpec(PyObj);

PyObj PyObj_FromDatumAndTypeTuple(Datum, HeapTuple);
PyObj PyObj_FromDatumAndTypeOid(Datum, Oid);
Oid TypeOidMod_FromPyObject(PyObj, int32*);
Oid TypeOid_FromPyObject(PyObj);
ArrayType * Array_FromTypeTupleAndPySequence(HeapTuple, PyObj);

Datum Datum_Cast(Datum, Oid, Oid);
TupleDesc RelationOidGetDescr(Oid);
TupleDesc TupleDesc_FromTypeOid(Oid);
ParamListInfo ParamListInfo_FromDatumsAndNulls(unsigned long, Datum *, char *);
char * PgTypeName_FromOid(Oid);

PyObj PyErr_SetPgError(void);

#define PgErr_TRAP(_CODE) \
do { \
	EXC_DECLARE(); \
	volatile bool broke = false;\
\
	EXCEPT( \
		PyErr_SetPgError(); \
		broke = true; \
		break; /* Don't raise the Postgres Error */ \
	); \
\
	if (!broke) {_CODE EXC_RESTORE();} \
} while(0)

#define TypeHT_FromTypeOid(O) SearchSysCacheCopy(TYPEOID,(Datum)O,0,0,0)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_UTILS_H */
