/* Module:          SQLGetFunctions.c
 *
 * Description:     Returns information about whether a driver supports a specific ODBC function. 
 *
 * Classes:         
 *
 * API functions:   SQLGetFunctions
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLGetFunctions(
								  SQLHDBC		hDrvDbc,
								  SQLUSMALLINT	fFunction,
								  SQLUSMALLINT	*pfExists
								  )
{
	static char *func="SQLGetFunctions";

	mylog( "%s: entering...\n", func);

    if (fFunction == SQL_API_ALL_FUNCTIONS)
	{

		if (globals.lie)
		{
			int i;
			memset(pfExists, 0, sizeof(SQLUSMALLINT)*100);

			pfExists[SQL_API_SQLALLOCENV] = TRUE;
			pfExists[SQL_API_SQLFREEENV] = TRUE;
			for (i = SQL_API_SQLALLOCCONNECT; i <= SQL_NUM_FUNCTIONS; i++)
				pfExists[i] = TRUE;
			for (i = SQL_EXT_API_START; i <= SQL_EXT_API_LAST; i++)
				pfExists[i] = TRUE;
		}
		else 
		{
			memset(pfExists, 0, sizeof(SQLUSMALLINT)*100);

			/* ODBC core functions */
			pfExists[SQL_API_SQLALLOCCONNECT]     = TRUE;
			pfExists[SQL_API_SQLALLOCENV]         = TRUE;
			pfExists[SQL_API_SQLALLOCSTMT]        = TRUE;
			pfExists[SQL_API_SQLBINDCOL]          = TRUE;  
			pfExists[SQL_API_SQLCANCEL]           = TRUE;
			pfExists[SQL_API_SQLCOLATTRIBUTES]    = TRUE;
			pfExists[SQL_API_SQLCONNECT]          = TRUE;
			pfExists[SQL_API_SQLDESCRIBECOL]      = TRUE;  /* partial */
			pfExists[SQL_API_SQLDISCONNECT]       = TRUE;
			pfExists[SQL_API_SQLERROR]            = TRUE;
			pfExists[SQL_API_SQLEXECDIRECT]       = TRUE;
			pfExists[SQL_API_SQLEXECUTE]          = TRUE;
			pfExists[SQL_API_SQLFETCH]            = TRUE;
			pfExists[SQL_API_SQLFREECONNECT]      = TRUE;
			pfExists[SQL_API_SQLFREEENV]          = TRUE;
			pfExists[SQL_API_SQLFREESTMT]         = TRUE;
			pfExists[SQL_API_SQLGETCURSORNAME]    = TRUE;
			pfExists[SQL_API_SQLNUMRESULTCOLS]    = TRUE;
			pfExists[SQL_API_SQLPREPARE]          = TRUE;  /* complete? */
			pfExists[SQL_API_SQLROWCOUNT]         = TRUE;
			pfExists[SQL_API_SQLSETCURSORNAME]    = TRUE;
			pfExists[SQL_API_SQLSETPARAM]         = FALSE; /* odbc 1.0 */
			pfExists[SQL_API_SQLTRANSACT]         = TRUE;

			/* ODBC level 1 functions */
			pfExists[SQL_API_SQLBINDPARAMETER]    = TRUE;
			pfExists[SQL_API_SQLCOLUMNS]          = TRUE;
			pfExists[SQL_API_SQLDRIVERCONNECT]    = TRUE;
			pfExists[SQL_API_SQLGETCONNECTOPTION] = TRUE;  /* partial */
			pfExists[SQL_API_SQLGETDATA]          = TRUE;
			pfExists[SQL_API_SQLGETFUNCTIONS]     = TRUE;                                                       
			pfExists[SQL_API_SQLGETINFO]          = TRUE;
			pfExists[SQL_API_SQLGETSTMTOPTION]    = TRUE;  /* partial */
			pfExists[SQL_API_SQLGETTYPEINFO]      = TRUE;
			pfExists[SQL_API_SQLPARAMDATA]        = TRUE;
			pfExists[SQL_API_SQLPUTDATA]          = TRUE;
			pfExists[SQL_API_SQLSETCONNECTOPTION] = TRUE;  /* partial */
			pfExists[SQL_API_SQLSETSTMTOPTION]    = TRUE;
			pfExists[SQL_API_SQLSPECIALCOLUMNS]   = TRUE;
			pfExists[SQL_API_SQLSTATISTICS]       = TRUE;
			pfExists[SQL_API_SQLTABLES]           = TRUE;

			/* ODBC level 2 functions */
			pfExists[SQL_API_SQLBROWSECONNECT]    = FALSE;
			pfExists[SQL_API_SQLCOLUMNPRIVILEGES] = FALSE;
			pfExists[SQL_API_SQLDATASOURCES]      = FALSE;  /* only implemented by DM */
			pfExists[SQL_API_SQLDESCRIBEPARAM]    = FALSE;	/* not properly implemented */
			pfExists[SQL_API_SQLDRIVERS]          = FALSE;  /* only implemented by DM */
			pfExists[SQL_API_SQLEXTENDEDFETCH]    = TRUE;
			pfExists[SQL_API_SQLFOREIGNKEYS]      = TRUE;
			pfExists[SQL_API_SQLMORERESULTS]      = TRUE;
			pfExists[SQL_API_SQLNATIVESQL]        = TRUE;
			pfExists[SQL_API_SQLNUMPARAMS]        = TRUE;
			pfExists[SQL_API_SQLPARAMOPTIONS]     = FALSE;
			pfExists[SQL_API_SQLPRIMARYKEYS]      = TRUE;
			pfExists[SQL_API_SQLPROCEDURECOLUMNS] = FALSE;
			pfExists[SQL_API_SQLPROCEDURES]       = FALSE;
			pfExists[SQL_API_SQLSETPOS]           = TRUE;
			pfExists[SQL_API_SQLSETSCROLLOPTIONS] = TRUE;	/* odbc 1.0 */
			pfExists[SQL_API_SQLTABLEPRIVILEGES]  = FALSE;
		}
    } 
	else
	{

		if (globals.lie)
		{
			*pfExists = TRUE;
		}
		else 
		{

			switch(fFunction) {
			case SQL_API_SQLALLOCCONNECT:     *pfExists = TRUE; break;
			case SQL_API_SQLALLOCENV:         *pfExists = TRUE; break;
			case SQL_API_SQLALLOCSTMT:        *pfExists = TRUE; break;
			case SQL_API_SQLBINDCOL:          *pfExists = TRUE; break;
			case SQL_API_SQLCANCEL:           *pfExists = TRUE; break;
			case SQL_API_SQLCOLATTRIBUTES:    *pfExists = TRUE; break;
			case SQL_API_SQLCONNECT:          *pfExists = TRUE; break;
			case SQL_API_SQLDESCRIBECOL:      *pfExists = TRUE; break;  /* partial */
			case SQL_API_SQLDISCONNECT:       *pfExists = TRUE; break;
			case SQL_API_SQLERROR:            *pfExists = TRUE; break;
			case SQL_API_SQLEXECDIRECT:       *pfExists = TRUE; break;
			case SQL_API_SQLEXECUTE:          *pfExists = TRUE; break;
			case SQL_API_SQLFETCH:            *pfExists = TRUE; break;
			case SQL_API_SQLFREECONNECT:      *pfExists = TRUE; break;
			case SQL_API_SQLFREEENV:          *pfExists = TRUE; break;
			case SQL_API_SQLFREESTMT:         *pfExists = TRUE; break;
			case SQL_API_SQLGETCURSORNAME:    *pfExists = TRUE; break;
			case SQL_API_SQLNUMRESULTCOLS:    *pfExists = TRUE; break;
			case SQL_API_SQLPREPARE:          *pfExists = TRUE; break;
			case SQL_API_SQLROWCOUNT:         *pfExists = TRUE; break;
			case SQL_API_SQLSETCURSORNAME:    *pfExists = TRUE; break;
			case SQL_API_SQLSETPARAM:         *pfExists = FALSE; break; /* odbc 1.0 */
			case SQL_API_SQLTRANSACT:         *pfExists = TRUE; break;

				/* ODBC level 1 functions */
			case SQL_API_SQLBINDPARAMETER:    *pfExists = TRUE; break;
			case SQL_API_SQLCOLUMNS:          *pfExists = TRUE; break;
			case SQL_API_SQLDRIVERCONNECT:    *pfExists = TRUE; break;
			case SQL_API_SQLGETCONNECTOPTION: *pfExists = TRUE; break;  /* partial */
			case SQL_API_SQLGETDATA:          *pfExists = TRUE; break;
			case SQL_API_SQLGETFUNCTIONS:     *pfExists = TRUE; break;
			case SQL_API_SQLGETINFO:          *pfExists = TRUE; break;
			case SQL_API_SQLGETSTMTOPTION:    *pfExists = TRUE; break;  /* partial */
			case SQL_API_SQLGETTYPEINFO:      *pfExists = TRUE; break;
			case SQL_API_SQLPARAMDATA:        *pfExists = TRUE; break;
			case SQL_API_SQLPUTDATA:          *pfExists = TRUE; break;
			case SQL_API_SQLSETCONNECTOPTION: *pfExists = TRUE; break;  /* partial */
			case SQL_API_SQLSETSTMTOPTION:    *pfExists = TRUE; break;
			case SQL_API_SQLSPECIALCOLUMNS:   *pfExists = TRUE; break;
			case SQL_API_SQLSTATISTICS:       *pfExists = TRUE; break;
			case SQL_API_SQLTABLES:           *pfExists = TRUE; break;

				/* ODBC level 2 functions */
			case SQL_API_SQLBROWSECONNECT:    *pfExists = FALSE; break;
			case SQL_API_SQLCOLUMNPRIVILEGES: *pfExists = FALSE; break;
			case SQL_API_SQLDATASOURCES:      *pfExists = FALSE; break;  /* only implemented by DM */
			case SQL_API_SQLDESCRIBEPARAM:    *pfExists = FALSE; break;  /* not properly implemented */
			case SQL_API_SQLDRIVERS:          *pfExists = FALSE; break;  /* only implemented by DM */
			case SQL_API_SQLEXTENDEDFETCH:    *pfExists = TRUE; break;
			case SQL_API_SQLFOREIGNKEYS:      *pfExists = TRUE; break;
			case SQL_API_SQLMORERESULTS:      *pfExists = TRUE; break;
			case SQL_API_SQLNATIVESQL:        *pfExists = TRUE; break;
			case SQL_API_SQLNUMPARAMS:        *pfExists = TRUE; break;
			case SQL_API_SQLPARAMOPTIONS:     *pfExists = FALSE; break;
			case SQL_API_SQLPRIMARYKEYS:      *pfExists = TRUE; break;
			case SQL_API_SQLPROCEDURECOLUMNS: *pfExists = FALSE; break;
			case SQL_API_SQLPROCEDURES:       *pfExists = FALSE; break;
			case SQL_API_SQLSETPOS:           *pfExists = TRUE; break;
			case SQL_API_SQLSETSCROLLOPTIONS: *pfExists = TRUE; break;	/* odbc 1.0 */
			case SQL_API_SQLTABLEPRIVILEGES:  *pfExists = FALSE; break;
			}
		}
    }

    return SQL_SUCCESS;
}
