/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class LineContains
extends BaseParamFilterReader
implements ChainableReader {
    private static final String CONTAINS_KEY = "contains";
    private Vector contains = new Vector();
    private String line = null;

    public LineContains() {
    }

    public LineContains(Reader in) {
        super(in);
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int ch = -1;
        if (this.line != null) {
            ch = this.line.charAt(0);
            this.line = this.line.length() == 1 ? null : this.line.substring(1);
        } else {
            this.line = this.readLine();
            if (this.line == null) {
                ch = -1;
            } else {
                int containsSize = this.contains.size();
                int i = 0;
                while (i < containsSize) {
                    String containsStr = (String)this.contains.elementAt(i);
                    if (this.line.indexOf(containsStr) == -1) {
                        this.line = null;
                        break;
                    }
                    ++i;
                }
                return this.read();
            }
        }
        return ch;
    }

    public final void addConfiguredContains(Contains contains) {
        this.contains.addElement(contains.getValue());
    }

    private void setContains(Vector contains) {
        this.contains = contains;
    }

    private final Vector getContains() {
        return this.contains;
    }

    public final Reader chain(Reader rdr) {
        LineContains newFilter = new LineContains(rdr);
        newFilter.setContains(this.getContains());
        newFilter.setInitialized(true);
        return newFilter;
    }

    private final void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (CONTAINS_KEY.equals(params[i].getType())) {
                    this.contains.addElement(params[i].getValue());
                }
                ++i;
            }
        }
    }

    static {
        CONTAINS_KEY = CONTAINS_KEY;
    }

    public static class Contains {
        private String value;

        public final void setValue(String contains) {
            this.value = contains;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

