/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbcx.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbcx.base.BaseConnectionWrapper;
import com.microsoft.jdbcx.base.BaseDependent;
import com.microsoft.jdbcx.base.BaseStatementWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class BaseResultSetWrapper
implements ResultSet,
BaseDependent {
    private static String footprint = "$Revision:   1.0  $";
    ResultSet realResultSet;
    private BaseConnectionWrapper connectionWrapper;
    private BaseStatementWrapper statementWrapper;
    private boolean isClosed;
    private BaseExceptions exceptions;

    BaseResultSetWrapper(BaseStatementWrapper baseStatementWrapper, ResultSet resultSet, BaseConnectionWrapper baseConnectionWrapper) throws SQLException {
        this.realResultSet = resultSet;
        this.connectionWrapper = baseConnectionWrapper;
        this.statementWrapper = baseStatementWrapper;
    }

    BaseResultSetWrapper(ResultSet resultSet, BaseConnectionWrapper baseConnectionWrapper) throws SQLException {
        this.realResultSet = resultSet;
        this.connectionWrapper = baseConnectionWrapper;
        baseConnectionWrapper.addDependent(this);
    }

    public boolean absolute(int n) throws SQLException {
        return this.realResultSet.absolute(n);
    }

    public void afterLast() throws SQLException {
        this.realResultSet.afterLast();
    }

    public void beforeFirst() throws SQLException {
        this.realResultSet.beforeFirst();
    }

    public void cancelRowUpdates() throws SQLException {
        this.realResultSet.cancelRowUpdates();
    }

    public void clearWarnings() throws SQLException {
        this.realResultSet.clearWarnings();
    }

    public void close() throws SQLException {
        this.realResultSet.close();
        if (this.statementWrapper == null) {
            this.connectionWrapper.removeFromDependents(this);
        }
        this.isClosed = true;
    }

    public void deleteRow() throws SQLException {
        this.realResultSet.deleteRow();
    }

    public void doClose() {
    }

    protected void finalize() throws Throwable {
        if (this.statementWrapper == null && !this.isClosed) {
            this.connectionWrapper.notifyResultSetGarbage();
        }
        super.finalize();
    }

    public int findColumn(String string) throws SQLException {
        return this.realResultSet.findColumn(string);
    }

    public boolean first() throws SQLException {
        return this.realResultSet.first();
    }

    public Array getArray(int n) throws SQLException {
        return this.realResultSet.getArray(n);
    }

    public Array getArray(String string) throws SQLException {
        return this.realResultSet.getArray(string);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.realResultSet.getAsciiStream(n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.realResultSet.getAsciiStream(string);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.realResultSet.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.realResultSet.getBigDecimal(n, n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.realResultSet.getBigDecimal(string);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.realResultSet.getBigDecimal(string, n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.realResultSet.getBinaryStream(n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.realResultSet.getBinaryStream(string);
    }

    public Blob getBlob(int n) throws SQLException {
        return this.realResultSet.getBlob(n);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.realResultSet.getBlob(string);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.realResultSet.getBoolean(n);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.realResultSet.getBoolean(string);
    }

    public byte getByte(int n) throws SQLException {
        return this.realResultSet.getByte(n);
    }

    public byte getByte(String string) throws SQLException {
        return this.realResultSet.getByte(string);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.realResultSet.getBytes(n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.realResultSet.getBytes(string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this.realResultSet.getCharacterStream(n);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.realResultSet.getCharacterStream(string);
    }

    public Clob getClob(int n) throws SQLException {
        return this.realResultSet.getClob(n);
    }

    public Clob getClob(String string) throws SQLException {
        return this.realResultSet.getClob(string);
    }

    public int getConcurrency() throws SQLException {
        return this.realResultSet.getConcurrency();
    }

    public String getCursorName() throws SQLException {
        return this.realResultSet.getCursorName();
    }

    public Date getDate(int n) throws SQLException {
        return this.realResultSet.getDate(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.realResultSet.getDate(n, calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.realResultSet.getDate(string);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.realResultSet.getDate(string, calendar);
    }

    public double getDouble(int n) throws SQLException {
        return this.realResultSet.getDouble(n);
    }

    public double getDouble(String string) throws SQLException {
        return this.realResultSet.getDouble(string);
    }

    public int getFetchDirection() throws SQLException {
        return this.realResultSet.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.realResultSet.getFetchSize();
    }

    public float getFloat(int n) throws SQLException {
        return this.realResultSet.getFloat(n);
    }

    public float getFloat(String string) throws SQLException {
        return this.realResultSet.getFloat(string);
    }

    public int getInt(int n) throws SQLException {
        return this.realResultSet.getInt(n);
    }

    public int getInt(String string) throws SQLException {
        return this.realResultSet.getInt(string);
    }

    public long getLong(int n) throws SQLException {
        return this.realResultSet.getLong(n);
    }

    public long getLong(String string) throws SQLException {
        return this.realResultSet.getLong(string);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.realResultSet.getMetaData();
    }

    public Object getObject(int n) throws SQLException {
        return this.realResultSet.getObject(n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.realResultSet.getObject(n, map);
    }

    public Object getObject(String string) throws SQLException {
        return this.realResultSet.getObject(string);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.realResultSet.getObject(string, map);
    }

    public Ref getRef(int n) throws SQLException {
        return this.realResultSet.getRef(n);
    }

    public Ref getRef(String string) throws SQLException {
        return this.realResultSet.getRef(string);
    }

    public int getRow() throws SQLException {
        return this.realResultSet.getRow();
    }

    public short getShort(int n) throws SQLException {
        return this.realResultSet.getShort(n);
    }

    public short getShort(String string) throws SQLException {
        return this.realResultSet.getShort(string);
    }

    public Statement getStatement() throws SQLException {
        this.realResultSet.getStatement();
        return this.statementWrapper;
    }

    public String getString(int n) throws SQLException {
        return this.realResultSet.getString(n);
    }

    public String getString(String string) throws SQLException {
        return this.realResultSet.getString(string);
    }

    public Time getTime(int n) throws SQLException {
        return this.realResultSet.getTime(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.realResultSet.getTime(n, calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.realResultSet.getTime(string);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.realResultSet.getTime(string, calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.realResultSet.getTimestamp(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.realResultSet.getTimestamp(n, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.realResultSet.getTimestamp(string);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.realResultSet.getTimestamp(string, calendar);
    }

    public int getType() throws SQLException {
        return this.realResultSet.getType();
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.realResultSet.getUnicodeStream(n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.realResultSet.getUnicodeStream(string);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.realResultSet.getWarnings();
    }

    public void insertRow() throws SQLException {
        this.realResultSet.insertRow();
    }

    public boolean isAfterLast() throws SQLException {
        return this.realResultSet.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.realResultSet.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.realResultSet.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.realResultSet.isLast();
    }

    public boolean last() throws SQLException {
        return this.realResultSet.last();
    }

    public void moveToCurrentRow() throws SQLException {
        this.realResultSet.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.realResultSet.moveToInsertRow();
    }

    public boolean next() throws SQLException {
        return this.realResultSet.next();
    }

    public boolean previous() throws SQLException {
        return this.realResultSet.previous();
    }

    public Object realObject() {
        return this.realResultSet;
    }

    public void refreshRow() throws SQLException {
        this.realResultSet.refreshRow();
    }

    public boolean relative(int n) throws SQLException {
        return this.realResultSet.relative(n);
    }

    public boolean rowDeleted() throws SQLException {
        return this.realResultSet.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.realResultSet.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.realResultSet.rowUpdated();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.realResultSet.setFetchDirection(n);
    }

    public void setFetchSize(int n) throws SQLException {
        this.realResultSet.setFetchSize(n);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.realResultSet.updateAsciiStream(n, inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.realResultSet.updateAsciiStream(string, inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.realResultSet.updateBigDecimal(n, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.realResultSet.updateBigDecimal(string, bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.realResultSet.updateBinaryStream(n, inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.realResultSet.updateBinaryStream(string, inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.realResultSet.updateBoolean(n, bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.realResultSet.updateBoolean(string, bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.realResultSet.updateByte(n, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.realResultSet.updateByte(string, by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.realResultSet.updateBytes(n, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.realResultSet.updateBytes(string, byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.realResultSet.updateCharacterStream(n, reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.realResultSet.updateCharacterStream(string, reader, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.realResultSet.updateDate(n, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.realResultSet.updateDate(string, date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.realResultSet.updateDouble(n, d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.realResultSet.updateDouble(string, d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.realResultSet.updateFloat(n, f);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.realResultSet.updateFloat(string, f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.realResultSet.updateInt(n, n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.realResultSet.updateInt(string, n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.realResultSet.updateLong(n, l);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.realResultSet.updateLong(string, l);
    }

    public void updateNull(int n) throws SQLException {
        this.realResultSet.updateNull(n);
    }

    public void updateNull(String string) throws SQLException {
        this.realResultSet.updateNull(string);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.realResultSet.updateObject(n, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.realResultSet.updateObject(n, object, n2);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.realResultSet.updateObject(string, object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.realResultSet.updateObject(string, object, n);
    }

    public void updateRow() throws SQLException {
        this.realResultSet.updateRow();
    }

    public void updateShort(int n, short s) throws SQLException {
        this.realResultSet.updateShort(n, s);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.realResultSet.updateShort(string, s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.realResultSet.updateString(n, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.realResultSet.updateString(string, string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.realResultSet.updateTime(n, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.realResultSet.updateTime(string, time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.realResultSet.updateTimestamp(n, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.realResultSet.updateTimestamp(string, timestamp);
    }

    public boolean wasNull() throws SQLException {
        return this.realResultSet.wasNull();
    }
}

