VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form Form1 
   Caption         =   "Access to PostgreSQL database convertion tool"
   ClientHeight    =   7365
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8490
   LinkTopic       =   "Form1"
   ScaleHeight     =   7365
   ScaleWidth      =   8490
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox chkAddColumns 
      Caption         =   "Add columns"
      Height          =   255
      Left            =   6990
      TabIndex        =   22
      ToolTipText     =   "Generate ALTER TABLE ADD COLUMN instead of CREATE for columns (Agregar Columnas)"
      Top             =   2550
      Width           =   1575
   End
   Begin VB.CheckBox chkErase 
      Caption         =   "Drop/Delete"
      Height          =   255
      Left            =   6990
      TabIndex        =   21
      ToolTipText     =   "Erase current data and schema on destination database (Bajar/eliminar)"
      Top             =   2820
      Width           =   1575
   End
   Begin VB.CommandButton btnAbout 
      Caption         =   "About / Help"
      Height          =   435
      Left            =   6960
      TabIndex        =   20
      Top             =   120
      Width           =   1365
   End
   Begin VB.CommandButton btnList 
      Caption         =   "List Tables"
      Height          =   435
      Left            =   6930
      TabIndex        =   19
      ToolTipText     =   "Open original database and show its tables (Listar Tablas)"
      Top             =   840
      Width           =   1395
   End
   Begin VB.CheckBox chkSchema 
      Caption         =   "Create Schema"
      Height          =   255
      Left            =   6870
      TabIndex        =   18
      ToolTipText     =   "Generate and execute DDL CREATE TABLE/SEQUENCE ... (Crear esquema)"
      Top             =   2280
      Value           =   1  'Checked
      Width           =   1575
   End
   Begin VB.CheckBox chkCopy 
      Caption         =   "Copy Data"
      Height          =   255
      Left            =   6870
      TabIndex        =   17
      ToolTipText     =   "Actually copy information (Copiar Datos)"
      Top             =   3090
      Value           =   1  'Checked
      Width           =   1575
   End
   Begin VB.CommandButton btnApplyIndexes 
      Caption         =   "Apply Indexes"
      Height          =   435
      Left            =   6840
      TabIndex        =   16
      ToolTipText     =   "Execute CREATE INDEX ...  (Aplicar Indices)"
      Top             =   6750
      Width           =   1545
   End
   Begin VB.CommandButton btnApplyConstraints 
      Caption         =   "Apply Constraints"
      Height          =   435
      Left            =   6870
      TabIndex        =   15
      ToolTipText     =   "Execute ALTER TABLE ADD CONSTRAINT ... (Aplicar restricciones)"
      Top             =   5220
      Width           =   1515
   End
   Begin MSComctlLib.ProgressBar ProgressBar1 
      Height          =   255
      Left            =   1200
      TabIndex        =   14
      Top             =   2280
      Width           =   5535
      _ExtentX        =   9763
      _ExtentY        =   450
      _Version        =   393216
      Appearance      =   1
   End
   Begin VB.TextBox txtIndexes 
      Height          =   1485
      Left            =   1200
      MultiLine       =   -1  'True
      TabIndex        =   12
      Top             =   5700
      Width           =   5535
   End
   Begin VB.TextBox txtConstraints 
      Height          =   1485
      Left            =   1200
      MultiLine       =   -1  'True
      TabIndex        =   10
      Top             =   4170
      Width           =   5535
   End
   Begin MSComctlLib.ImageList ImageList1 
      Left            =   7320
      Top             =   1320
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   5
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Form1.frx":0000
            Key             =   "TABLE"
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Form1.frx":0352
            Key             =   "VIEW"
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Form1.frx":06A4
            Key             =   "DELETE"
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Form1.frx":0A36
            Key             =   "INSERT"
         EndProperty
         BeginProperty ListImage5 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Form1.frx":0D60
            Key             =   "UPDATE"
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.ListView lvwTables 
      Height          =   1425
      Left            =   1200
      TabIndex        =   8
      Top             =   780
      Width           =   5535
      _ExtentX        =   9763
      _ExtentY        =   2514
      View            =   3
      MultiSelect     =   -1  'True
      LabelWrap       =   -1  'True
      HideSelection   =   0   'False
      _Version        =   393217
      Icons           =   "ImageList1"
      SmallIcons      =   "ImageList1"
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   3
      BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Text            =   "Nombre"
         Object.Width           =   3528
      EndProperty
      BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   1
         Text            =   "#"
         Object.Width           =   1323
      EndProperty
      BeginProperty ColumnHeader(3) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   2
         Text            =   "Estado"
         Object.Width           =   2540
      EndProperty
   End
   Begin VB.TextBox fCnnStr0 
      Height          =   285
      Left            =   1200
      TabIndex        =   3
      ToolTipText     =   "access connection string (cadena de conexin a access)"
      Top             =   60
      Width           =   5535
   End
   Begin VB.TextBox fCnnStr1 
      Height          =   285
      Left            =   1200
      TabIndex        =   2
      ToolTipText     =   "postgresql connection string (cadena de conexin a postgresql)"
      Top             =   390
      Width           =   5535
   End
   Begin VB.TextBox txtData 
      Height          =   1485
      Left            =   1200
      MultiLine       =   -1  'True
      TabIndex        =   1
      Top             =   2580
      Width           =   5535
   End
   Begin VB.CommandButton btnMigrate 
      Caption         =   "Migrate"
      Height          =   435
      Left            =   6930
      TabIndex        =   0
      ToolTipText     =   "Process selected tables (Migrar)"
      Top             =   3630
      Width           =   1395
   End
   Begin VB.Label lblIndexes 
      Caption         =   "Indexes:"
      Height          =   225
      Left            =   90
      TabIndex        =   13
      ToolTipText     =   "ndices:"
      Top             =   5670
      Width           =   945
   End
   Begin VB.Label lblConstraints 
      Caption         =   "Constraints:"
      Height          =   225
      Left            =   90
      TabIndex        =   11
      ToolTipText     =   "Restricciones:"
      Top             =   4140
      Width           =   1095
   End
   Begin VB.Label lblTaables 
      Caption         =   "Tables:"
      Height          =   225
      Left            =   150
      TabIndex        =   9
      ToolTipText     =   "Tablas:"
      Top             =   810
      Width           =   975
   End
   Begin VB.Label lblIn 
      Caption         =   "IN:"
      Height          =   225
      Left            =   150
      TabIndex        =   7
      ToolTipText     =   "Entrada:"
      Top             =   120
      Width           =   975
   End
   Begin VB.Label lblOut 
      Caption         =   "OUT:"
      Height          =   225
      Left            =   150
      TabIndex        =   6
      ToolTipText     =   "Salida:"
      Top             =   420
      Width           =   975
   End
   Begin VB.Label lblSchema 
      Caption         =   "SQL Schema:"
      Height          =   225
      Left            =   120
      TabIndex        =   5
      ToolTipText     =   "Esquema SQL:"
      Top             =   2610
      Width           =   1035
   End
   Begin VB.Label lblProgress 
      Caption         =   "Progress:"
      Height          =   225
      Left            =   120
      TabIndex        =   4
      ToolTipText     =   "Progreso:"
      Top             =   2280
      Width           =   975
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Access (MDB) to PostgreSQL convertion tool
' Uses Activex Data Objects (ADO 2.8)
' Requires PsqlODBC to be installed
' Possibly works for other input databases too
' Copyright 2007-2010 (C) Mariano Reingart reingart@gmail.com

Option Explicit

Dim cn0 As New ADODB.Connection, cn1 As New ADODB.Connection

Private Sub btnAbout_Click()
    Dim lUsage As String
    lUsage = vbCrLf & "Usage:" & vbCrLf & _
        "- Complete IN and OUT connection strings (access and postgresql databases respectively)" & vbCrLf & _
        "- Select tables to migrate (ctrl/shift click)" & vbCrLf & _
        "- Check migration options accordly (create schema, copy data, etc.)" & vbCrLf & _
        "- Press Migrate button to start convertion process" & vbCrLf & _
        "- When migration is finished, apply constraints and indexes (if any)" & vbCrLf
    MsgBox App.FileDescription & vbCrLf & vbCrLf & App.Comments & vbCrLf & App.LegalCopyright & vbCrLf & App.CompanyName & vbCrLf & lUsage, vbInformation, _
    App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
End Sub

Private Sub btnMigrate_Click()
    Me.MousePointer = vbHourglass
    On Error GoTo btnMigrate_error
    ProcessTables
    MsgBox "Done", vbOKOnly + vbInformation, App.Title
    Me.MousePointer = vbNormal
    Exit Sub
btnMigrate_error:
    MsgBox Err.Description, vbExclamation, "Error " & Err.Number
    Debug.Assert False
    Me.MousePointer = vbNormal
End Sub

Sub ListTables()
    Dim rs As ADODB.Recordset, rs0 As Recordset, rs1 As Recordset
    
    Dim itmx As ListItem
    
    cn0.Open fCnnStr0
    cn1.Open fCnnStr1
    
    lvwTables.ListItems.Clear
    Set rs = cn0.OpenSchema(adSchemaTables, Array(Empty, Empty, Empty, "TABLE"))
    Do Until rs.EOF
        If rs(3) = "TABLE" And Not rs(2) Like "MSys*" Then ' access system table
            Set itmx = lvwTables.ListItems.Add(, , rs!TABLE_NAME)
            
            itmx.Tag = rs(3)
            itmx.SmallIcon = IIf(rs(3) = "TABLE", 1, 2)
            itmx.Icon = itmx.SmallIcon
            Set rs0 = New Recordset
            
            rs0.Open "SELECT Count(*) FROM [" & rs!TABLE_NAME & "]", cn0, adOpenForwardOnly, , adCmdText
            itmx.SubItems(1) = rs0(0)
            rs0.Close
            itmx.Selected = True
        End If
        rs.MoveNext
    Loop
End Sub

Sub ProcessTables()
    Dim itmx As ListItem
    
    For Each itmx In lvwTables.ListItems
        If itmx.Selected And Not itmx.Text Like "~*" Then
            itmx.SubItems(2) = "Procesando (processing)..."
            itmx.EnsureVisible
            ProcessTable itmx.Text, CLng(itmx.SubItems(1))
            itmx.SubItems(2) = "Ok!"
            Me.ProgressBar1.Value = 0
        End If
    Next
End Sub

Sub ProcessTable(pTable As String, pTotal As Long)
    Dim rs As New Recordset, fd As Field, fd1 As Field, rs0 As Recordset
    Dim rs1 As Recordset, i As Long, lColName As String
    Dim sql As String, comma As Boolean, s As String, lTrans As Boolean
    Dim lSequenceName As String, lSequenceNumber As String
    
    On Error GoTo errorhandler
    
    sql = "CREATE TABLE """ & LCase(pTable) & """ ( "
    
    If chkAddColumns.Value = 1 Then sql = sql & "); " & vbCrLf
    
    rs.Open "[" & pTable & "]", cn0, adOpenForwardOnly, , adCmdTable
    
    For Each fd In rs.Fields
        If chkAddColumns.Value = 1 Then
            sql = sql & "ALTER TABLE """ & LCase(pTable) & """ ADD COLUMN "
        Else
            If Not comma Then comma = True Else sql = sql & ","
        End If
        sql = sql & vbCrLf
        lColName = convert(fd.Name)
        If InStr(lColName, " ") = 0 And InStr(lColName, "_") = 0 Then
            sql = sql & " " & lColName
        Else
            sql = sql & " """ & lColName & """ "
        End If
        
        Select Case fd.Type
            Case adBoolean
                s = "bool"
            Case adSingle
                s = "float4"
            Case adDecimal, adCurrency
                s = "numeric"
            Case adDouble
                s = "float8"
            Case adTinyInt, adUnsignedTinyInt, adSmallInt, adUnsignedSmallInt
                s = "smallint"
            Case adInteger, adNumeric, adUnsignedInt
                s = "integer"
            Case adBigInt, adUnsignedBigInt
                s = "bigint"
            Case adChar, adWChar
                s = "char(" & fd.DefinedSize & ")"
            Case adDate
                Debug.Print fd.Precision
                s = "date"
            Case adVarChar, adVarWChar
                s = "varchar(" & fd.DefinedSize & ")"
            Case adDBTime
                s = "time"
            Case adDate, adDBDate
                s = "date"
            Case adDBTimeStamp
                s = "timestamp"
            Case adLongVarChar, adLongVarWChar
                s = "text"
            Case Else
                Debug.Print pTable, fd.Name, fd.Type
                Debug.Assert False
        End Select
    
        If fd.Properties("ISAUTOINCREMENT").Value Then
            s = "SERIAL"
            Set rs1 = New Recordset
            rs1.Open "SELECT MAX([" & lColName & "]) FROM [" & pTable & "]", cn0, adOpenForwardOnly, , adCmdText
            If Not rs1.EOF Then
                If Not IsNull(rs1(0)) Then
                    lSequenceName = LCase(pTable) & "_" & lColName & "_seq"
                    lSequenceNumber = rs1(0) + 1
                End If
            End If
        End If
        
        sql = sql & " " & s
        
        'If (fd.Attributes And ADODB.FieldAttributeEnum.adFldIsNullable) Or (fd.Attributes And ADODB.FieldAttributeEnum.adFldMayBeNull) Then
        If CBool(fd.Attributes And adFldIsNullable) Then ' Or CBool(fd.Attributes And adColNullable)
            'sql = sql & " NULL"
        Else
            sql = sql & " NOT NULL "
        End If
        
        Set rs1 = cn0.OpenSchema(adSchemaColumns, Array(Empty, Empty, pTable, fd.Name))
        If rs1!COLUMN_HASDEFAULT Then
            Select Case LCase(rs1!COLUMN_DEFAULT)
                Case "date()"
                    s = "CURRENT_DATE"
                Case "now()"
                    s = "CURRENT_TIMESTAMP"
                Case Else
                    Select Case s
                        Case "bool"
                            s = IIf(CBool(Val(rs1!COLUMN_DEFAULT)), "TRUE", "FALSE")
                        Case "float4", "numeric", "float8", "smallint", "integer", "bigint"
                            s = rs1!COLUMN_DEFAULT
                        Case "char(" & fd.DefinedSize & ")", "varchar(" & fd.DefinedSize & ")", "text"
                            s = rs1!COLUMN_DEFAULT
                            If Left(s, 1) = """" And Right(s, 1) = """" Then
                                s = Mid(s, 2, Len(s) - 2)
                            End If
                            s = "'" & s & "'"
                        Case "date", "time", "timestamp"
                            s = "" & rs1!COLUMN_DEFAULT & ""
                        Case Else
                            s = rs1!COLUMN_DEFAULT
                    End Select
            End Select
            sql = sql & " DEFAULT " & s
        ElseIf s = "bool" Then
            sql = sql & " DEFAULT False "
        End If
        If chkAddColumns.Value = 1 Then
            sql = sql & ";" & vbCrLf
        End If
    Next
    If Not chkAddColumns.Value = 1 Then sql = sql & ");" & vbCrLf
    Debug.Print sql
    s = ""
    Set rs1 = cn0.OpenSchema(adSchemaPrimaryKeys, Array(Empty, Empty, pTable))
    Do Until rs1.EOF
        'For Each fd1 In rs.Fields
        '    Debug.Print fd1.Name, "=", fd1.Value
        'Next
        s = IIf(s <> "", s & ",", "") & rs1!COLUMN_NAME
        rs1.MoveNext
    Loop
    
    If s <> "" Then
        sql = sql & "ALTER TABLE " & pTable & " ADD CONSTRAINT " & pTable & "_PK PRIMARY KEY (" & s & ");" & vbCrLf
    End If
    
    If lSequenceName <> "" Then
        sql = sql & "ALTER SEQUENCE " & lSequenceName & " RESTART " & lSequenceNumber & ";" & vbCrLf
    End If
    
    txtData.Text = txtData.Text & vbCrLf & sql
    
    DoEvents
    If chkCopy.Value = 1 Then
        On Error Resume Next
        If chkSchema.Value = 1 And chkErase.Value = 1 Then
            cn1.Execute "DROP TABLE " & pTable & " CASCADE "
        ElseIf chkErase.Value = 1 Then
            cn1.Execute "DELETE FROM " & pTable & " "
        End If
        On Error GoTo errorhandler
        If chkSchema.Value = 1 Then
            Debug.Print sql
            cn1.Execute sql
        End If
        
        cn1.BeginTrans
        lTrans = True
        Set rs1 = New Recordset
        rs1.CursorLocation = adUseServer
        rs1.Open """" & LCase(pTable) & """", cn1, adOpenDynamic, adLockOptimistic, adCmdTable
        i = 0
        Do Until rs.EOF
            If i Mod 10 = 0 Then
                On Error Resume Next
                Me.ProgressBar1.Value = CSng(i / pTotal * 100#)
                On Error GoTo errorhandler
                DoEvents
            End If
            i = i + 1
            rs1.Cancel
            Debug.Print rs(0)
            rs1.AddNew
            For Each fd In rs.Fields
                rs1(convert(fd.Name)) = rs(fd.Name)
            Next
            rs1.Update
            rs.MoveNext
        Loop
        cn1.CommitTrans
    End If
    
    Set rs = cn0.OpenSchema(adSchemaIndexes, Array(Empty, Empty, Empty, Empty, pTable))
    Dim lIndex As String, lUnique As Boolean, lClustered As Boolean, b As Boolean
    s = ""
    Do Until rs.EOF
        'For Each fd1 In rs.Fields
        '    Debug.Print fd1.Name, "=", fd1.Value
        'Next
        If lIndex = "" Then
            lIndex = rs!INDEX_NAME
        End If
        s = IIf(s <> "", s & ", ", "") & convert(rs!COLUMN_NAME)
        rs.MoveNext
        If rs.EOF Then
            b = True
        ElseIf lIndex <> rs!INDEX_NAME Then
            b = True
        End If
        If b Then
            txtIndexes.Text = txtIndexes.Text & "CREATE " & IIf(lUnique, " UNIQUE ", "") & " INDEX " & pTable & "_" & lIndex & "_ndx ON " & pTable & " (" & s & ");" & vbCrLf
            If lClustered Then
                txtIndexes.Text = txtIndexes.Text & "ALTER TABLE " & pTable & " CLUSTER ON (" & s & ");" & vbCrLf
            End If
            s = ""
            If Not rs.EOF Then
                lIndex = rs!INDEX_NAME
            End If
        End If
        b = False
    Loop
    
    Set rs = cn0.OpenSchema(adSchemaTableConstraints, Array(Empty, Empty, Empty, Empty, Empty, pTable, Empty))
    Do Until rs.EOF
        'For Each fd1 In rs.Fields
        '    Debug.Print fd1.Name, "=", fd1.Value
        'Next
        Dim lFkCols As String, lFkTable As String, lCols As String, lOnUpdate, lOnDelete
        Select Case rs("CONSTRAINT_TYPE")
            Case "FOREIGN KEY"
                Set rs1 = cn0.OpenSchema(adSchemaForeignKeys) 'adSchemaKeyColumnUsage)
                lFkTable = "": lFkCols = "": lCols = ""
                lOnUpdate = "": lOnDelete = ""
                Do Until rs1.EOF
                    If rs1!FK_NAME = rs!CONSTRAINT_NAME Then
                        For Each fd1 In rs1.Fields
                            Debug.Print fd1.Name, "=", fd1.Value
                        Next
                        lCols = IIf(lCols <> "", lCols & ",", "") & convert(rs1!FK_COLUMN_NAME)
                        lFkCols = IIf(lFkCols <> "", lFkCols & ",", "") & convert(rs1!PK_COLUMN_NAME)
                        lFkTable = rs1!PK_TABLE_NAME
                        If rs1!UPDATE_RULE <> "" Then lOnUpdate = "ON UPDATE " & rs1!UPDATE_RULE
                        If rs1!DELETE_RULE <> "" Then lOnDelete = "ON DELETE " & rs1!DELETE_RULE
                    End If
                    rs1.MoveNext
                Loop
                Set rs1 = Nothing
                txtConstraints.Text = txtConstraints.Text & "ALTER TABLE " & pTable & " ADD CONSTRAINT " & rs!CONSTRAINT_NAME & " FOREIGN KEY (" & lCols & ") REFERENCES " & lFkTable & "(" & lFkCols & ") " & lOnUpdate & " " & lOnDelete & ";" & vbCrLf
        End Select
        rs.MoveNext
    Loop
    'Set rs = con.OpenSchema(adSchemaIndexes, Array(Empty, Empty, Empty, Empty, "JOB"))

    'txtData.Text = txtData.Text & vbCrLf & sql
    Exit Sub
errorhandler:
    MsgBox Err.Description, vbExclamation, "Error " & Err.Number
    Debug.Assert False
    If lTrans Then cn1.RollbackTrans
    Exit Sub
    Resume Next
End Sub

Private Sub btnApplyConstraints_Click()
    Me.MousePointer = vbHourglass
    cn1.BeginTrans
    On Error GoTo Command2_error
    cn1.Execute txtConstraints.Text
    cn1.CommitTrans
    Me.MousePointer = vbNormal
    MsgBox "OK!"
    Exit Sub
Command2_error:
    Me.MousePointer = vbNormal
    MsgBox Err.Description, vbExclamation, "Error " & Err.Number
    Debug.Assert False
    cn1.RollbackTrans
End Sub

Private Sub btnApplyIndexes_Click()
    Me.MousePointer = vbHourglass
    cn1.BeginTrans
    On Error GoTo Command3_error
    cn1.Execute txtIndexes.Text
    Me.MousePointer = vbNormal
    MsgBox "OK!"
    Exit Sub
Command3_error:
    Me.MousePointer = vbNormal
    MsgBox Err.Description, vbExclamation, "Error " & Err.Number
    Debug.Assert False
    cn1.RollbackTrans
End Sub

Function convert(ss As String) As String
    Dim i As Integer, s As String
    For i = 1 To Len(ss)
        Select Case Mid(ss, i, 1)
            Case " ", ":"
                s = s & "_"
            Case Else
                s = s & Mid(ss, i, 1)
        End Select
    Next
    s = LCase(s)
    If s = "xmin" Then s = "__xmin"
    Select Case Left(s, 1)
        Case "0" To "9"
            s = "__" & s
    End Select
    convert = s
End Function


Private Sub btnList_Click()
    Me.MousePointer = vbHourglass
    ListTables
    Me.MousePointer = vbNormal
End Sub

Private Sub Form_Load()
    Dim lMDBPath, lMDBPassword, lPgDatabase
    ' default values:
    lMDBPath = "C:\my_database.mdb"
    lMDBPassword = "saraza"
    lPgDatabase = "my_database"
    fCnnStr0 = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & lMDBPath & ";Jet OLEDB:Database Password=" & lMDBPassword & ";"
    fCnnStr1 = "Provider=MSDASQL;Driver={PostgreSQL ANSI};SERVER=localhost;DATABASE=" & lPgDatabase & ";UID=sistema;PWD=saraza;CONNSETTINGS=SET Datestyle TO 'DMY'%3b;BOOLSASCHAR=0;TEXTASLONGVARCHAR=1;TrueIsMinus1=1;SSLMODE=require;"
End Sub
