/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class jTPCCTerminal
implements jTPCCConfig,
Runnable {
    private String terminalName;
    private Connection conn = null;
    private Statement stmt = null;
    private Statement stmt1 = null;
    private ResultSet rs = null;
    private int terminalWarehouseID;
    private int terminalDistrictID;
    private int paymentWeight;
    private int orderStatusWeight;
    private int deliveryWeight;
    private int stockLevelWeight;
    private JOutputArea terminalOutputArea;
    private JOutputArea errorOutputArea;
    private boolean debugMessages;
    private jTPCC parent;
    private Random gen;
    private int transactionCount = 1;
    private int numTransactions;
    private int numWarehouses;
    private int newOrderCounter;
    private StringBuffer query = null;
    private int result = 0;
    private boolean stopRunningSignal = false;
    private PreparedStatement stmtGetCustWhse = null;
    private PreparedStatement stmtGetDist = null;
    private PreparedStatement stmtInsertNewOrder = null;
    private PreparedStatement stmtUpdateDist = null;
    private PreparedStatement stmtInsertOOrder = null;
    private PreparedStatement stmtGetItem = null;
    private PreparedStatement stmtGetStock = null;
    private PreparedStatement stmtUpdateStock = null;
    private PreparedStatement stmtInsertOrderLine = null;
    private PreparedStatement payUpdateWhse = null;
    private PreparedStatement payGetWhse = null;
    private PreparedStatement payUpdateDist = null;
    private PreparedStatement payGetDist = null;
    private PreparedStatement payCountCust = null;
    private PreparedStatement payCursorCustByName = null;
    private PreparedStatement payGetCust = null;
    private PreparedStatement payGetCustCdata = null;
    private PreparedStatement payUpdateCustBalCdata = null;
    private PreparedStatement payUpdateCustBal = null;
    private PreparedStatement payInsertHist = null;
    private PreparedStatement ordStatCountCust = null;
    private PreparedStatement ordStatGetCust = null;
    private PreparedStatement ordStatGetNewestOrd = null;
    private PreparedStatement ordStatGetCustBal = null;
    private PreparedStatement ordStatGetOrder = null;
    private PreparedStatement ordStatGetOrderLines = null;
    private PreparedStatement delivGetOrderId = null;
    private PreparedStatement delivDeleteNewOrder = null;
    private PreparedStatement delivGetCustId = null;
    private PreparedStatement delivUpdateCarrierId = null;
    private PreparedStatement delivUpdateDeliveryDate = null;
    private PreparedStatement delivSumOrderAmount = null;
    private PreparedStatement delivUpdateCustBalDelivCnt = null;
    private PreparedStatement stockGetDistOrderId = null;
    private PreparedStatement stockGetCountStock = null;

    public jTPCCTerminal(String terminalName, int terminalWarehouseID, int terminalDistrictID, Connection conn, int numTransactions, JOutputArea terminalOutputArea, JOutputArea errorOutputArea, boolean debugMessages, int paymentWeight, int orderStatusWeight, int deliveryWeight, int stockLevelWeight, int numWarehouses, jTPCC parent) throws SQLException {
        this.terminalName = terminalName;
        this.conn = conn;
        this.stmt = conn.createStatement();
        this.stmt.setMaxRows(200);
        this.stmt.setFetchSize(100);
        this.stmt1 = conn.createStatement();
        this.stmt1.setMaxRows(1);
        this.terminalWarehouseID = terminalWarehouseID;
        this.terminalDistrictID = terminalDistrictID;
        this.terminalOutputArea = terminalOutputArea;
        this.errorOutputArea = errorOutputArea;
        this.debugMessages = debugMessages;
        this.parent = parent;
        this.numTransactions = numTransactions;
        this.paymentWeight = paymentWeight;
        this.orderStatusWeight = orderStatusWeight;
        this.deliveryWeight = deliveryWeight;
        this.stockLevelWeight = stockLevelWeight;
        this.numWarehouses = numWarehouses;
        this.newOrderCounter = 0;
        this.terminalMessage("Terminal '" + terminalName + "' has WarehouseID=" + terminalWarehouseID + " and DistrictID=" + terminalDistrictID + ".");
    }

    public void run() {
        this.gen = new Random(System.currentTimeMillis() * (long)this.conn.hashCode());
        this.executeTransactions(this.numTransactions);
        try {
            this.printMessage("Closing statement and connection...");
            this.stmt.close();
            this.conn.close();
        }
        catch (Exception e) {
            this.printMessage("An error occurred!");
            this.logException(e);
        }
        this.printMessage("Terminal '" + this.terminalName + "' finished after " + (this.transactionCount - 1) + " transaction(s).");
        this.parent.signalTerminalEnded(this, this.newOrderCounter);
    }

    public void stopRunningWhenPossible() {
        this.stopRunningSignal = true;
        this.printMessage("Terminal received stop signal!");
        this.printMessage("Finishing current transaction before exit...");
    }

    private void executeTransactions(int numTransactions) {
        boolean stopRunning = false;
        if (numTransactions != -1) {
            this.printMessage("Executing " + numTransactions + " transactions...");
        } else {
            this.printMessage("Executing for a limited time...");
        }
        for (int i = 0; !(i >= numTransactions && numTransactions != -1 || stopRunning); ++i) {
            String transactionTypeName;
            long transactionType = jTPCCUtil.randomNumber(1, 100, this.gen);
            int skippedDeliveries = 0;
            int newOrder = 0;
            long transactionStart = System.currentTimeMillis();
            if (transactionType <= (long)this.paymentWeight) {
                this.executeTransaction(2);
                transactionTypeName = "Payment";
            } else if (transactionType <= (long)(this.paymentWeight + this.stockLevelWeight)) {
                this.executeTransaction(5);
                transactionTypeName = "Stock-Level";
            } else if (transactionType <= (long)(this.paymentWeight + this.stockLevelWeight + this.orderStatusWeight)) {
                this.executeTransaction(3);
                transactionTypeName = "Order-Status";
            } else if (transactionType <= (long)(this.paymentWeight + this.stockLevelWeight + this.orderStatusWeight + this.deliveryWeight)) {
                skippedDeliveries = this.executeTransaction(4);
                transactionTypeName = "Delivery";
            } else {
                this.executeTransaction(1);
                transactionTypeName = "New-Order";
                ++this.newOrderCounter;
                newOrder = 1;
            }
            long transactionEnd = System.currentTimeMillis();
            if (!transactionTypeName.equals("Delivery")) {
                this.parent.signalTerminalEndedTransaction(this.terminalName, transactionTypeName, transactionEnd - transactionStart, null, newOrder);
            } else {
                this.parent.signalTerminalEndedTransaction(this.terminalName, transactionTypeName, transactionEnd - transactionStart, skippedDeliveries == 0 ? "None" : "" + skippedDeliveries + " delivery(ies) skipped.", newOrder);
            }
            if (!this.stopRunningSignal) continue;
            stopRunning = true;
        }
    }

    private int executeTransaction(int transaction) {
        int result = 0;
        switch (transaction) {
            case 1: {
                int districtID = jTPCCUtil.randomNumber(1, 10, this.gen);
                int customerID = jTPCCUtil.getCustomerID(this.gen);
                int numItems = jTPCCUtil.randomNumber(5, 15, this.gen);
                int[] itemIDs = new int[numItems];
                int[] supplierWarehouseIDs = new int[numItems];
                int[] orderQuantities = new int[numItems];
                int allLocal = 1;
                for (int i = 0; i < numItems; ++i) {
                    itemIDs[i] = jTPCCUtil.getItemID(this.gen);
                    if (jTPCCUtil.randomNumber(1, 100, this.gen) > 1) {
                        supplierWarehouseIDs[i] = this.terminalWarehouseID;
                    } else {
                        do {
                            supplierWarehouseIDs[i] = jTPCCUtil.randomNumber(1, this.numWarehouses, this.gen);
                        } while (supplierWarehouseIDs[i] == this.terminalWarehouseID && this.numWarehouses > 1);
                        allLocal = 0;
                    }
                    orderQuantities[i] = jTPCCUtil.randomNumber(1, 10, this.gen);
                }
                if (jTPCCUtil.randomNumber(1, 100, this.gen) == 1) {
                    itemIDs[numItems - 1] = -12345;
                }
                this.terminalMessage("\nStarting transaction #" + this.transactionCount + " (New-Order)...");
                this.newOrderTransaction(this.terminalWarehouseID, districtID, customerID, numItems, allLocal, itemIDs, supplierWarehouseIDs, orderQuantities);
                break;
            }
            case 2: {
                int customerWarehouseID;
                int customerDistrictID;
                int districtID = jTPCCUtil.randomNumber(1, 10, this.gen);
                int x = jTPCCUtil.randomNumber(1, 100, this.gen);
                if (x <= 85) {
                    customerDistrictID = districtID;
                    customerWarehouseID = this.terminalWarehouseID;
                } else {
                    customerDistrictID = jTPCCUtil.randomNumber(1, 10, this.gen);
                    while ((customerWarehouseID = jTPCCUtil.randomNumber(1, this.numWarehouses, this.gen)) == this.terminalWarehouseID && this.numWarehouses > 1) {
                    }
                }
                long y = jTPCCUtil.randomNumber(1, 100, this.gen);
                String customerLastName = null;
                int customerID = -1;
                boolean customerByName = false;
                customerID = jTPCCUtil.getCustomerID(this.gen);
                float paymentAmount = (float)((double)jTPCCUtil.randomNumber(100, 500000, this.gen) / 100.0);
                this.terminalMessage("\nStarting transaction #" + this.transactionCount + " (Payment)...");
                this.paymentTransaction(this.terminalWarehouseID, customerWarehouseID, paymentAmount, districtID, customerDistrictID, customerID, customerLastName, customerByName);
                break;
            }
            case 5: {
                int threshold = jTPCCUtil.randomNumber(10, 20, this.gen);
                this.terminalMessage("\nStarting transaction #" + this.transactionCount + " (Stock-Level)...");
                this.stockLevelTransaction(this.terminalWarehouseID, this.terminalDistrictID, threshold);
                break;
            }
            case 3: {
                boolean customerByName;
                int districtID = jTPCCUtil.randomNumber(1, 10, this.gen);
                long y = jTPCCUtil.randomNumber(1, 100, this.gen);
                String customerLastName = null;
                int customerID = -1;
                if (y <= 60L) {
                    customerByName = true;
                    customerLastName = jTPCCUtil.getLastName(this.gen);
                } else {
                    customerByName = false;
                    customerID = jTPCCUtil.getCustomerID(this.gen);
                }
                this.terminalMessage("\nStarting transaction #" + this.transactionCount + " (Order-Status)...");
                this.orderStatusTransaction(this.terminalWarehouseID, districtID, customerID, customerLastName, customerByName);
                break;
            }
            case 4: {
                int orderCarrierID = jTPCCUtil.randomNumber(1, 10, this.gen);
                this.terminalMessage("\nStarting transaction #" + this.transactionCount + " (Delivery)...");
                result = this.deliveryTransaction(this.terminalWarehouseID, orderCarrierID);
                break;
            }
            default: {
                this.error("EMPTY-TYPE");
            }
        }
        ++this.transactionCount;
        return result;
    }

    private int deliveryTransaction(int w_id, int o_carrier_id) {
        int skippedDeliveries = 0;
        Oorder oorder = new Oorder();
        OrderLine order_line = new OrderLine();
        NewOrder new_order = new NewOrder();
        new_order.no_w_id = w_id;
        try {
            int[] orderIDs = new int[10];
            for (int d_id = 1; d_id <= 10; ++d_id) {
                boolean newOrderRemoved;
                int no_o_id;
                new_order.no_d_id = d_id;
                do {
                    no_o_id = -1;
                    if (this.delivGetOrderId == null) {
                        this.delivGetOrderId = this.conn.prepareStatement("SELECT no_o_id FROM new_order WHERE no_d_id = ? AND no_w_id = ? ORDER BY no_o_id ASC");
                    }
                    this.delivGetOrderId.setInt(1, d_id);
                    this.delivGetOrderId.setInt(2, w_id);
                    this.rs = this.delivGetOrderId.executeQuery();
                    if (this.rs.next()) {
                        no_o_id = this.rs.getInt("no_o_id");
                    }
                    orderIDs[d_id - 1] = no_o_id;
                    this.rs.close();
                    this.rs = null;
                    newOrderRemoved = false;
                    if (no_o_id == -1) continue;
                    new_order.no_o_id = no_o_id;
                    if (this.delivDeleteNewOrder == null) {
                        this.delivDeleteNewOrder = this.conn.prepareStatement("DELETE FROM new_order WHERE no_d_id = ? AND no_w_id = ? AND no_o_id = ?");
                    }
                    this.delivDeleteNewOrder.setInt(1, d_id);
                    this.delivDeleteNewOrder.setInt(2, w_id);
                    this.delivDeleteNewOrder.setInt(3, no_o_id);
                    this.result = this.delivDeleteNewOrder.executeUpdate();
                    if (this.result <= 0) continue;
                    newOrderRemoved = true;
                } while (no_o_id != -1 && !newOrderRemoved);
                if (no_o_id == -1) continue;
                if (this.delivGetCustId == null) {
                    this.delivGetCustId = this.conn.prepareStatement("SELECT o_c_id FROM oorder WHERE o_id = ? AND o_d_id = ? AND o_w_id = ?");
                }
                this.delivGetCustId.setInt(1, no_o_id);
                this.delivGetCustId.setInt(2, d_id);
                this.delivGetCustId.setInt(3, w_id);
                this.rs = this.delivGetCustId.executeQuery();
                if (!this.rs.next()) {
                    throw new Exception("O_ID=" + no_o_id + " O_D_ID=" + d_id + " O_W_ID=" + w_id + " not found!");
                }
                int c_id = this.rs.getInt("o_c_id");
                this.rs.close();
                this.rs = null;
                if (this.delivUpdateCarrierId == null) {
                    this.delivUpdateCarrierId = this.conn.prepareStatement("UPDATE oorder SET o_carrier_id = ? WHERE o_id = ? AND o_d_id = ? AND o_w_id = ?");
                }
                this.delivUpdateCarrierId.setInt(1, o_carrier_id);
                this.delivUpdateCarrierId.setInt(2, no_o_id);
                this.delivUpdateCarrierId.setInt(3, d_id);
                this.delivUpdateCarrierId.setInt(4, w_id);
                this.result = this.delivUpdateCarrierId.executeUpdate();
                if (this.result != 1) {
                    throw new Exception("O_ID=" + no_o_id + " O_D_ID=" + d_id + " O_W_ID=" + w_id + " not found!");
                }
                if (this.delivUpdateDeliveryDate == null) {
                    this.delivUpdateDeliveryDate = this.conn.prepareStatement("UPDATE order_line SET ol_delivery_d = ? WHERE ol_o_id = ? AND ol_d_id = ? AND ol_w_id = ?");
                }
                this.delivUpdateDeliveryDate.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                this.delivUpdateDeliveryDate.setInt(2, no_o_id);
                this.delivUpdateDeliveryDate.setInt(3, d_id);
                this.delivUpdateDeliveryDate.setInt(4, w_id);
                this.result = this.delivUpdateDeliveryDate.executeUpdate();
                if (this.result == 0) {
                    throw new Exception("OL_O_ID=" + no_o_id + " OL_D_ID=" + d_id + " OL_W_ID=" + w_id + " not found!");
                }
                if (this.delivSumOrderAmount == null) {
                    this.delivSumOrderAmount = this.conn.prepareStatement("SELECT SUM(ol_amount) AS ol_total FROM order_line WHERE ol_o_id = ? AND ol_d_id = ? AND ol_w_id = ?");
                }
                this.delivSumOrderAmount.setInt(1, no_o_id);
                this.delivSumOrderAmount.setInt(2, d_id);
                this.delivSumOrderAmount.setInt(3, w_id);
                this.rs = this.delivSumOrderAmount.executeQuery();
                if (!this.rs.next()) {
                    throw new Exception("OL_O_ID=" + no_o_id + " OL_D_ID=" + d_id + " OL_W_ID=" + w_id + " not found!");
                }
                float ol_total = this.rs.getFloat("ol_total");
                this.rs.close();
                this.rs = null;
                if (this.delivUpdateCustBalDelivCnt == null) {
                    this.delivUpdateCustBalDelivCnt = this.conn.prepareStatement("UPDATE customer SET c_balance = c_balance + ?, c_delivery_cnt = c_delivery_cnt + 1 WHERE c_id = ? AND c_d_id = ? AND c_w_id = ?");
                }
                this.delivUpdateCustBalDelivCnt.setFloat(1, ol_total);
                this.delivUpdateCustBalDelivCnt.setInt(2, c_id);
                this.delivUpdateCustBalDelivCnt.setInt(3, d_id);
                this.delivUpdateCustBalDelivCnt.setInt(4, w_id);
                this.result = this.delivUpdateCustBalDelivCnt.executeUpdate();
                if (this.result != 0) continue;
                throw new Exception("C_ID=" + c_id + " C_W_ID=" + w_id + " C_D_ID=" + d_id + " not found!");
            }
            this.conn.commit();
            StringBuffer terminalMessage = new StringBuffer();
            terminalMessage.append("\n+---------------------------- DELIVERY ---------------------------+\n");
            terminalMessage.append(" Date: ");
            terminalMessage.append(jTPCCUtil.getCurrentTime());
            terminalMessage.append("\n\n Warehouse: ");
            terminalMessage.append(w_id);
            terminalMessage.append("\n Carrier:   ");
            terminalMessage.append(o_carrier_id);
            terminalMessage.append("\n\n Delivered Orders\n");
            for (int i = 1; i <= 10; ++i) {
                if (orderIDs[i - 1] >= 0) {
                    terminalMessage.append("  District ");
                    terminalMessage.append(i < 10 ? " " : "");
                    terminalMessage.append(i);
                    terminalMessage.append(": Order number ");
                    terminalMessage.append(orderIDs[i - 1]);
                    terminalMessage.append(" was delivered.\n");
                    continue;
                }
                terminalMessage.append("  District ");
                terminalMessage.append(i < 10 ? " " : "");
                terminalMessage.append(i);
                terminalMessage.append(": No orders to be delivered.\n");
                ++skippedDeliveries;
            }
            terminalMessage.append("+-----------------------------------------------------------------+\n\n");
            this.terminalMessage(terminalMessage.toString());
        }
        catch (Exception e) {
            this.error("DELIVERY");
            this.logException(e);
            try {
                this.terminalMessage("Performing ROLLBACK...");
                this.conn.rollback();
            }
            catch (Exception e1) {
                this.error("DELIVERY-ROLLBACK");
                this.logException(e1);
            }
        }
        return skippedDeliveries;
    }

    private void orderStatusTransaction(int w_id, int d_id, int c_id, String c_last, boolean c_by_name) {
        int o_id = -1;
        int o_carrier_id = -1;
        Date entdate = null;
        Vector<String> orderLines = new Vector<String>();
        try {
            float c_balance;
            String c_middle;
            String c_first;
            if (c_by_name) {
                if (this.ordStatCountCust == null) {
                    this.ordStatCountCust = this.conn.prepareStatement("SELECT count(*) AS namecnt FROM customer WHERE c_last = ? AND c_d_id = ? AND c_w_id = ?");
                }
                this.ordStatCountCust.setString(1, c_last);
                this.ordStatCountCust.setInt(2, d_id);
                this.ordStatCountCust.setInt(3, w_id);
                this.rs = this.ordStatCountCust.executeQuery();
                if (!this.rs.next()) {
                    throw new Exception("C_LAST=" + c_last + " C_D_ID=" + d_id + " C_W_ID=" + w_id + " not found!");
                }
                int namecnt = this.rs.getInt("namecnt");
                this.rs.close();
                this.rs = null;
                if (this.ordStatGetCust == null) {
                    this.ordStatGetCust = this.conn.prepareStatement("SELECT c_balance, c_first, c_middle, c_id FROM customer WHERE c_last = ? AND c_d_id = ? AND c_w_id = ? ORDER BY c_w_id, c_d_id, c_last, c_first");
                }
                this.ordStatGetCust.setString(1, c_last);
                this.ordStatGetCust.setInt(2, d_id);
                this.ordStatGetCust.setInt(3, w_id);
                this.rs = this.ordStatGetCust.executeQuery();
                if (!this.rs.next()) {
                    throw new Exception("C_LAST=" + c_last + " C_D_ID=" + d_id + " C_W_ID=" + w_id + " not found!");
                }
                if (namecnt % 2 == 1) {
                    ++namecnt;
                }
                for (int i = 1; i < namecnt / 2; ++i) {
                    this.rs.next();
                }
                c_id = this.rs.getInt("c_id");
                c_first = this.rs.getString("c_first");
                c_middle = this.rs.getString("c_middle");
                c_balance = this.rs.getFloat("c_balance");
                this.rs.close();
                this.rs = null;
            } else {
                if (this.ordStatGetCustBal == null) {
                    this.ordStatGetCustBal = this.conn.prepareStatement("SELECT c_balance, c_first, c_middle, c_last FROM customer WHERE c_id = ? AND c_d_id = ? AND c_w_id = ?");
                }
                this.ordStatGetCustBal.setInt(1, c_id);
                this.ordStatGetCustBal.setInt(2, d_id);
                this.ordStatGetCustBal.setInt(3, w_id);
                this.rs = this.ordStatGetCustBal.executeQuery();
                if (!this.rs.next()) {
                    throw new Exception("C_ID=" + c_id + " C_D_ID=" + d_id + " C_W_ID=" + w_id + " not found!");
                }
                c_last = this.rs.getString("c_last");
                c_first = this.rs.getString("c_first");
                c_middle = this.rs.getString("c_middle");
                c_balance = this.rs.getFloat("c_balance");
                this.rs.close();
                this.rs = null;
            }
            if (this.ordStatGetNewestOrd == null) {
                this.ordStatGetNewestOrd = this.conn.prepareStatement("SELECT MAX(o_id) AS maxorderid FROM oorder WHERE o_w_id = ? AND o_d_id = ? AND o_c_id = ?");
            }
            this.ordStatGetNewestOrd.setInt(1, w_id);
            this.ordStatGetNewestOrd.setInt(2, d_id);
            this.ordStatGetNewestOrd.setInt(3, c_id);
            this.rs = this.ordStatGetNewestOrd.executeQuery();
            if (this.rs.next()) {
                o_id = this.rs.getInt("maxorderid");
                this.rs.close();
                this.rs = null;
                if (this.ordStatGetOrder == null) {
                    this.ordStatGetOrder = this.conn.prepareStatement("SELECT o_carrier_id, o_entry_d FROM oorder WHERE o_w_id = ? AND o_d_id = ? AND o_c_id = ? AND o_id = ?");
                }
                this.ordStatGetOrder.setInt(1, w_id);
                this.ordStatGetOrder.setInt(2, d_id);
                this.ordStatGetOrder.setInt(3, c_id);
                this.ordStatGetOrder.setInt(4, o_id);
                this.rs = this.ordStatGetOrder.executeQuery();
                if (this.rs.next()) {
                    o_carrier_id = this.rs.getInt("o_carrier_id");
                    entdate = this.rs.getDate("o_entry_d");
                }
            }
            this.rs.close();
            this.rs = null;
            if (this.ordStatGetOrderLines == null) {
                this.ordStatGetOrderLines = this.conn.prepareStatement("SELECT ol_i_id, ol_supply_w_id, ol_quantity, ol_amount, ol_delivery_d FROM order_line WHERE ol_o_id = ? AND ol_d_id =? AND ol_w_id = ?");
            }
            this.ordStatGetOrderLines.setInt(1, o_id);
            this.ordStatGetOrderLines.setInt(2, d_id);
            this.ordStatGetOrderLines.setInt(3, w_id);
            this.rs = this.ordStatGetOrderLines.executeQuery();
            while (this.rs.next()) {
                StringBuffer orderLine = new StringBuffer();
                orderLine.append("[");
                orderLine.append(this.rs.getLong("ol_supply_w_id"));
                orderLine.append(" - ");
                orderLine.append(this.rs.getLong("ol_i_id"));
                orderLine.append(" - ");
                orderLine.append(this.rs.getLong("ol_quantity"));
                orderLine.append(" - ");
                orderLine.append(jTPCCUtil.formattedDouble(this.rs.getDouble("ol_amount")));
                orderLine.append(" - ");
                if (this.rs.getDate("ol_delivery_d") != null) {
                    orderLine.append(this.rs.getDate("ol_delivery_d"));
                } else {
                    orderLine.append("99-99-9999");
                }
                orderLine.append("]");
                orderLines.add(orderLine.toString());
            }
            this.rs.close();
            this.rs = null;
            StringBuffer terminalMessage = new StringBuffer();
            terminalMessage.append("\n");
            terminalMessage.append("+-------------------------- ORDER-STATUS -------------------------+\n");
            terminalMessage.append(" Date: ");
            terminalMessage.append(jTPCCUtil.getCurrentTime());
            terminalMessage.append("\n\n Warehouse: ");
            terminalMessage.append(w_id);
            terminalMessage.append("\n District:  ");
            terminalMessage.append(d_id);
            terminalMessage.append("\n\n Customer:  ");
            terminalMessage.append(c_id);
            terminalMessage.append("\n   Name:    ");
            terminalMessage.append(c_first);
            terminalMessage.append(" ");
            terminalMessage.append(c_middle);
            terminalMessage.append(" ");
            terminalMessage.append(c_last);
            terminalMessage.append("\n   Balance: ");
            terminalMessage.append(c_balance);
            terminalMessage.append("\n\n");
            if (o_id == -1) {
                terminalMessage.append(" Customer has no orders placed.\n");
            } else {
                terminalMessage.append(" Order-Number: ");
                terminalMessage.append(o_id);
                terminalMessage.append("\n    Entry-Date: ");
                terminalMessage.append(entdate);
                terminalMessage.append("\n    Carrier-Number: ");
                terminalMessage.append(o_carrier_id);
                terminalMessage.append("\n\n");
                if (orderLines.size() != 0) {
                    terminalMessage.append(" [Supply_W - Item_ID - Qty - Amount - Delivery-Date]\n");
                    Enumeration orderLinesEnum = orderLines.elements();
                    while (orderLinesEnum.hasMoreElements()) {
                        terminalMessage.append(" ");
                        terminalMessage.append((String)orderLinesEnum.nextElement());
                        terminalMessage.append("\n");
                    }
                } else {
                    this.terminalMessage(" This Order has no Order-Lines.\n");
                }
            }
            terminalMessage.append("+-----------------------------------------------------------------+\n\n");
            this.terminalMessage(terminalMessage.toString());
        }
        catch (Exception e) {
            this.error("ORDER-STATUS");
            this.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void newOrderTransaction(int w_id, int d_id, int c_id, int o_ol_cnt, int o_all_local, int[] itemIDs, int[] supplierWarehouseIDs, int[] orderQuantities) {
        block44: {
            float d_tax = 0.0f;
            int o_id = -1;
            String c_last = null;
            String c_credit = null;
            String ol_dist_info = null;
            float[] itemPrices = new float[o_ol_cnt];
            float[] orderLineAmounts = new float[o_ol_cnt];
            String[] itemNames = new String[o_ol_cnt];
            int[] stockQuantities = new int[o_ol_cnt];
            char[] brandGeneric = new char[o_ol_cnt];
            float total_amount = 0.0f;
            Warehouse whse = new Warehouse();
            Customer cust = new Customer();
            District dist = new District();
            NewOrder nwor = new NewOrder();
            Oorder ordr = new Oorder();
            OrderLine orln = new OrderLine();
            Stock stck = new Stock();
            Item item = new Item();
            if (this.stmtGetCustWhse == null) {
                this.stmtGetCustWhse = this.conn.prepareStatement("SELECT c_discount, c_last, c_credit, w_tax  FROM customer, warehouse WHERE w_id = ? AND w_id = c_w_id AND c_d_id = ? AND c_id = ?");
            }
            this.stmtGetCustWhse.setInt(1, w_id);
            this.stmtGetCustWhse.setInt(2, d_id);
            this.stmtGetCustWhse.setInt(3, c_id);
            this.rs = this.stmtGetCustWhse.executeQuery();
            if (!this.rs.next()) {
                throw new Exception("W_ID=" + w_id + " C_D_ID=" + d_id + " C_ID=" + c_id + " not found!");
            }
            float c_discount = this.rs.getFloat("c_discount");
            c_last = this.rs.getString("c_last");
            c_credit = this.rs.getString("c_credit");
            float w_tax = this.rs.getFloat("w_tax");
            this.rs.close();
            this.rs = null;
            boolean newOrderRowInserted = false;
            while (!newOrderRowInserted) {
                if (this.stmtGetDist == null) {
                    this.stmtGetDist = this.conn.prepareStatement("SELECT d_next_o_id, d_tax FROM district WHERE d_id = ? AND d_w_id = ? FOR UPDATE");
                }
                this.stmtGetDist.setInt(1, d_id);
                this.stmtGetDist.setInt(2, w_id);
                this.rs = this.stmtGetDist.executeQuery();
                if (!this.rs.next()) {
                    throw new Exception("D_ID=" + d_id + " D_W_ID=" + w_id + " not found!");
                }
                int d_next_o_id = this.rs.getInt("d_next_o_id");
                d_tax = this.rs.getFloat("d_tax");
                this.rs.close();
                this.rs = null;
                o_id = d_next_o_id;
                try {
                    if (this.stmtInsertNewOrder == null) {
                        this.stmtInsertNewOrder = this.conn.prepareStatement("INSERT INTO NEW_ORDER (no_o_id, no_d_id, no_w_id) VALUES ( ?, ?, ?)");
                    }
                    this.stmtInsertNewOrder.setInt(1, o_id);
                    this.stmtInsertNewOrder.setInt(2, d_id);
                    this.stmtInsertNewOrder.setInt(3, w_id);
                    this.stmtInsertNewOrder.executeUpdate();
                    newOrderRowInserted = true;
                }
                catch (SQLException e2) {
                    this.printMessage("The row was already on table new_order. Restarting...");
                }
            }
            if (this.stmtUpdateDist == null) {
                this.stmtUpdateDist = this.conn.prepareStatement("UPDATE district SET d_next_o_id = d_next_o_id + 1  WHERE d_id = ? AND d_w_id = ?");
            }
            this.stmtUpdateDist.setInt(1, d_id);
            this.stmtUpdateDist.setInt(2, w_id);
            this.result = this.stmtUpdateDist.executeUpdate();
            if (this.result == 0) {
                throw new Exception("Error!! Cannot update next_order_id on DISTRICT for D_ID=" + d_id + " D_W_ID=" + w_id);
            }
            if (this.stmtInsertOOrder == null) {
                this.stmtInsertOOrder = this.conn.prepareStatement("INSERT INTO OORDER  (o_id, o_d_id, o_w_id, o_c_id, o_entry_d, o_ol_cnt, o_all_local) VALUES (?, ?, ?, ?, ?, ?, ?)");
            }
            this.stmtInsertOOrder.setInt(1, o_id);
            this.stmtInsertOOrder.setInt(2, d_id);
            this.stmtInsertOOrder.setInt(3, w_id);
            this.stmtInsertOOrder.setInt(4, c_id);
            this.stmtInsertOOrder.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            this.stmtInsertOOrder.setInt(6, o_ol_cnt);
            this.stmtInsertOOrder.setInt(7, o_all_local);
            this.stmtInsertOOrder.executeUpdate();
            for (int ol_number = 1; ol_number <= o_ol_cnt; ++ol_number) {
                float ol_amount;
                int ol_supply_w_id = supplierWarehouseIDs[ol_number - 1];
                int ol_i_id = itemIDs[ol_number - 1];
                int ol_quantity = orderQuantities[ol_number - 1];
                if (item.i_id == -12345) {
                    throw new IllegalAccessException("Expected NEW-ORDER error condition excersing rollback functionality");
                }
                if (this.stmtGetItem == null) {
                    this.stmtGetItem = this.conn.prepareStatement("SELECT i_price, i_name , i_data FROM item WHERE i_id = ?");
                }
                this.stmtGetItem.setInt(1, ol_i_id);
                this.rs = this.stmtGetItem.executeQuery();
                if (!this.rs.next()) {
                    throw new IllegalAccessException("I_ID=" + ol_i_id + " not found!");
                }
                float i_price = this.rs.getFloat("i_price");
                String i_name = this.rs.getString("i_name");
                String i_data = this.rs.getString("i_data");
                this.rs.close();
                this.rs = null;
                itemPrices[ol_number - 1] = i_price;
                itemNames[ol_number - 1] = i_name;
                if (this.stmtGetStock == null) {
                    this.stmtGetStock = this.conn.prepareStatement("SELECT s_quantity, s_data, s_dist_01, s_dist_02, s_dist_03, s_dist_04, s_dist_05,        s_dist_06, s_dist_07, s_dist_08, s_dist_09, s_dist_10 FROM stock WHERE s_i_id = ? AND s_w_id = ? FOR UPDATE");
                }
                this.stmtGetStock.setInt(1, ol_i_id);
                this.stmtGetStock.setInt(2, ol_supply_w_id);
                this.rs = this.stmtGetStock.executeQuery();
                if (!this.rs.next()) {
                    throw new Exception("I_ID=" + ol_i_id + " not found!");
                }
                int s_quantity = this.rs.getInt("s_quantity");
                String s_data = this.rs.getString("s_data");
                String s_dist_01 = this.rs.getString("s_dist_01");
                String s_dist_02 = this.rs.getString("s_dist_02");
                String s_dist_03 = this.rs.getString("s_dist_03");
                String s_dist_04 = this.rs.getString("s_dist_04");
                String s_dist_05 = this.rs.getString("s_dist_05");
                String s_dist_06 = this.rs.getString("s_dist_06");
                String s_dist_07 = this.rs.getString("s_dist_07");
                String s_dist_08 = this.rs.getString("s_dist_08");
                String s_dist_09 = this.rs.getString("s_dist_09");
                String s_dist_10 = this.rs.getString("s_dist_10");
                this.rs.close();
                this.rs = null;
                stockQuantities[ol_number - 1] = s_quantity;
                s_quantity = s_quantity - ol_quantity >= 10 ? (s_quantity -= ol_quantity) : (s_quantity += -ol_quantity + 91);
                int s_remote_cnt_increment = ol_supply_w_id == w_id ? 0 : 1;
                if (this.stmtUpdateStock == null) {
                    this.stmtUpdateStock = this.conn.prepareStatement("UPDATE stock SET s_quantity = ? , s_ytd = s_ytd + ?, s_remote_cnt = s_remote_cnt + ?  WHERE s_i_id = ? AND s_w_id = ?");
                }
                this.stmtUpdateStock.setInt(1, s_quantity);
                this.stmtUpdateStock.setInt(2, ol_quantity);
                this.stmtUpdateStock.setInt(3, s_remote_cnt_increment);
                this.stmtUpdateStock.setInt(4, ol_i_id);
                this.stmtUpdateStock.setInt(5, ol_supply_w_id);
                this.stmtUpdateStock.addBatch();
                orderLineAmounts[ol_number - 1] = ol_amount = (float)ol_quantity * i_price;
                total_amount += ol_amount;
                brandGeneric[ol_number - 1] = i_data.indexOf("GENERIC") != -1 && s_data.indexOf("GENERIC") != -1 ? 66 : 71;
                switch (d_id) {
                    case 1: {
                        ol_dist_info = s_dist_01;
                        break;
                    }
                    case 2: {
                        ol_dist_info = s_dist_02;
                        break;
                    }
                    case 3: {
                        ol_dist_info = s_dist_03;
                        break;
                    }
                    case 4: {
                        ol_dist_info = s_dist_04;
                        break;
                    }
                    case 5: {
                        ol_dist_info = s_dist_05;
                        break;
                    }
                    case 6: {
                        ol_dist_info = s_dist_06;
                        break;
                    }
                    case 7: {
                        ol_dist_info = s_dist_07;
                        break;
                    }
                    case 8: {
                        ol_dist_info = s_dist_08;
                        break;
                    }
                    case 9: {
                        ol_dist_info = s_dist_09;
                        break;
                    }
                    case 10: {
                        ol_dist_info = s_dist_10;
                    }
                }
                if (this.stmtInsertOrderLine == null) {
                    this.stmtInsertOrderLine = this.conn.prepareStatement("INSERT INTO order_line (ol_o_id, ol_d_id, ol_w_id, ol_number, ol_i_id, ol_supply_w_id,  ol_quantity, ol_amount, ol_dist_info) VALUES (?,?,?,?,?,?,?,?,?)");
                }
                this.stmtInsertOrderLine.setInt(1, o_id);
                this.stmtInsertOrderLine.setInt(2, d_id);
                this.stmtInsertOrderLine.setInt(3, w_id);
                this.stmtInsertOrderLine.setInt(4, ol_number);
                this.stmtInsertOrderLine.setInt(5, ol_i_id);
                this.stmtInsertOrderLine.setInt(6, ol_supply_w_id);
                this.stmtInsertOrderLine.setInt(7, ol_quantity);
                this.stmtInsertOrderLine.setFloat(8, ol_amount);
                this.stmtInsertOrderLine.setString(9, ol_dist_info);
                this.stmtInsertOrderLine.addBatch();
            }
            this.stmtInsertOrderLine.executeBatch();
            this.stmtUpdateStock.executeBatch();
            this.transCommit();
            this.stmtInsertOrderLine.clearBatch();
            this.stmtUpdateStock.clearBatch();
            total_amount *= (1.0f + w_tax + d_tax) * (1.0f - c_discount);
            StringBuffer terminalMessage = new StringBuffer();
            terminalMessage.append("\n+--------------------------- NEW-ORDER ---------------------------+\n");
            terminalMessage.append(" Date: ");
            terminalMessage.append(jTPCCUtil.getCurrentTime());
            terminalMessage.append("\n\n Warehouse: ");
            terminalMessage.append(w_id);
            terminalMessage.append("\n   Tax:     ");
            terminalMessage.append(w_tax);
            terminalMessage.append("\n District:  ");
            terminalMessage.append(d_id);
            terminalMessage.append("\n   Tax:     ");
            terminalMessage.append(d_tax);
            terminalMessage.append("\n Order:     ");
            terminalMessage.append(o_id);
            terminalMessage.append("\n   Lines:   ");
            terminalMessage.append(o_ol_cnt);
            terminalMessage.append("\n\n Customer:  ");
            terminalMessage.append(c_id);
            terminalMessage.append("\n   Name:    ");
            terminalMessage.append(c_last);
            terminalMessage.append("\n   Credit:  ");
            terminalMessage.append(c_credit);
            terminalMessage.append("\n   %Disc:   ");
            terminalMessage.append(c_discount);
            terminalMessage.append("\n\n Order-Line List [Supp_W - Item_ID - Item Name - Qty - Stock - B/G - Price - Amount]\n");
            for (int i = 0; i < o_ol_cnt; ++i) {
                terminalMessage.append("                 [");
                terminalMessage.append(supplierWarehouseIDs[i]);
                terminalMessage.append(" - ");
                terminalMessage.append(itemIDs[i]);
                terminalMessage.append(" - ");
                terminalMessage.append(itemNames[i]);
                terminalMessage.append(" - ");
                terminalMessage.append(orderQuantities[i]);
                terminalMessage.append(" - ");
                terminalMessage.append(stockQuantities[i]);
                terminalMessage.append(" - ");
                terminalMessage.append(brandGeneric[i]);
                terminalMessage.append(" - ");
                terminalMessage.append(jTPCCUtil.formattedDouble(itemPrices[i]));
                terminalMessage.append(" - ");
                terminalMessage.append(jTPCCUtil.formattedDouble(orderLineAmounts[i]));
                terminalMessage.append("]\n");
            }
            terminalMessage.append("\n\n Total Amount: ");
            terminalMessage.append(total_amount);
            terminalMessage.append("\n\n Execution Status: New order placed!\n");
            terminalMessage.append("+-----------------------------------------------------------------+\n\n");
            this.terminalMessage(terminalMessage.toString());
            Object var55_60 = null;
            try {
                this.terminalMessage("Performing ROLLBACK in NEW-ORDER Txn...");
                this.transRollback();
                this.stmtInsertOrderLine.clearBatch();
                this.stmtUpdateStock.clearBatch();
            }
            catch (Exception e1) {
                this.error("NEW-ORDER-ROLLBACK");
                this.logException(e1);
            }
            break block44;
            {
                catch (SQLException ex) {
                    System.out.println("\n--- Unexpected SQLException caught in NEW-ORDER Txn ---\n");
                    while (ex != null) {
                        System.out.println("Message:   " + ex.getMessage());
                        System.out.println("SQLState:  " + ex.getSQLState());
                        System.out.println("ErrorCode: " + ex.getErrorCode());
                        ex = ex.getNextException();
                        System.out.println("");
                    }
                    Object var55_61 = null;
                    try {
                        this.terminalMessage("Performing ROLLBACK in NEW-ORDER Txn...");
                        this.transRollback();
                        this.stmtInsertOrderLine.clearBatch();
                        this.stmtUpdateStock.clearBatch();
                    }
                    catch (Exception e1) {
                        this.error("NEW-ORDER-ROLLBACK");
                        this.logException(e1);
                    }
                    break block44;
                }
                catch (Exception e) {
                    if (e instanceof IllegalAccessException) {
                        StringBuffer terminalMessage2 = new StringBuffer();
                        terminalMessage2.append("\n+---- NEW-ORDER Rollback Txn expected to happen for 1% of Txn's -----+");
                        terminalMessage2.append("\n Warehouse: ");
                        terminalMessage2.append(w_id);
                        terminalMessage2.append("\n District:  ");
                        terminalMessage2.append(d_id);
                        terminalMessage2.append("\n Order:     ");
                        terminalMessage2.append(o_id);
                        terminalMessage2.append("\n\n Customer:  ");
                        terminalMessage2.append(c_id);
                        terminalMessage2.append("\n   Name:    ");
                        terminalMessage2.append(c_last);
                        terminalMessage2.append("\n   Credit:  ");
                        terminalMessage2.append(c_credit);
                        terminalMessage2.append("\n\n Execution Status: Item number is not valid!\n");
                        terminalMessage2.append("+-----------------------------------------------------------------+\n\n");
                        this.terminalMessage(terminalMessage2.toString());
                    }
                    Object var55_62 = null;
                    try {
                        this.terminalMessage("Performing ROLLBACK in NEW-ORDER Txn...");
                        this.transRollback();
                        this.stmtInsertOrderLine.clearBatch();
                        this.stmtUpdateStock.clearBatch();
                    }
                    catch (Exception e1) {
                        this.error("NEW-ORDER-ROLLBACK");
                        this.logException(e1);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var55_63 = null;
                try {
                    this.terminalMessage("Performing ROLLBACK in NEW-ORDER Txn...");
                    this.transRollback();
                    this.stmtInsertOrderLine.clearBatch();
                    this.stmtUpdateStock.clearBatch();
                }
                catch (Exception e1) {
                    this.error("NEW-ORDER-ROLLBACK");
                    this.logException(e1);
                }
                throw throwable;
            }
        }
    }

    private void stockLevelTransaction(int w_id, int d_id, int threshold) {
        int o_id = 0;
        boolean i_id = false;
        int stock_count = 0;
        District dist = new District();
        OrderLine orln = new OrderLine();
        Stock stck = new Stock();
        this.printMessage("Stock Level Txn for W_ID=" + w_id + ", D_ID=" + d_id + ", threshold=" + threshold);
        try {
            if (this.stockGetDistOrderId == null) {
                this.stockGetDistOrderId = this.conn.prepareStatement("SELECT d_next_o_id FROM district WHERE d_w_id = ? AND d_id = ?");
            }
            this.stockGetDistOrderId.setInt(1, w_id);
            this.stockGetDistOrderId.setInt(2, d_id);
            this.rs = this.stockGetDistOrderId.executeQuery();
            if (!this.rs.next()) {
                throw new Exception("D_W_ID=" + w_id + " D_ID=" + d_id + " not found!");
            }
            o_id = this.rs.getInt("d_next_o_id");
            this.rs.close();
            this.rs = null;
            this.printMessage("Next Order ID for District = " + o_id);
            if (this.stockGetCountStock == null) {
                this.stockGetCountStock = this.conn.prepareStatement("SELECT COUNT(DISTINCT (s_i_id)) AS stock_count FROM order_line, stock WHERE ol_w_id = ? AND ol_d_id = ? AND ol_o_id < ? AND ol_o_id >= ? - 20 AND s_w_id = ? AND s_i_id = ol_i_id AND s_quantity < ?");
            }
            this.stockGetCountStock.setInt(1, w_id);
            this.stockGetCountStock.setInt(2, d_id);
            this.stockGetCountStock.setInt(3, o_id);
            this.stockGetCountStock.setInt(4, o_id);
            this.stockGetCountStock.setInt(5, w_id);
            this.stockGetCountStock.setInt(6, threshold);
            this.rs = this.stockGetCountStock.executeQuery();
            if (!this.rs.next()) {
                throw new Exception("OL_W_ID=" + w_id + " OL_D_ID=" + d_id + " OL_O_ID=" + o_id + " (...) not found!");
            }
            stock_count = this.rs.getInt("stock_count");
            this.rs.close();
            this.rs = null;
            StringBuffer terminalMessage = new StringBuffer();
            terminalMessage.append("\n+-------------------------- STOCK-LEVEL --------------------------+");
            terminalMessage.append("\n Warehouse: ");
            terminalMessage.append(w_id);
            terminalMessage.append("\n District:  ");
            terminalMessage.append(d_id);
            terminalMessage.append("\n\n Stock Level Threshold: ");
            terminalMessage.append(threshold);
            terminalMessage.append("\n Low Stock Count:       ");
            terminalMessage.append(stock_count);
            terminalMessage.append("\n+-----------------------------------------------------------------+\n\n");
            this.terminalMessage(terminalMessage.toString());
        }
        catch (Exception e) {
            this.error("STOCK-LEVEL");
            this.logException(e);
        }
    }

    private void paymentTransaction(int w_id, int c_w_id, float h_amount, int d_id, int c_d_id, int c_id, String c_last, boolean c_by_name) {
        String c_credit = null;
        String c_data = null;
        float c_balance = 0.0f;
        Warehouse whse = new Warehouse();
        Customer cust = new Customer();
        District dist = new District();
        History hist = new History();
        try {
            Date c_since;
            float c_discount;
            float c_credit_lim;
            String c_phone;
            String c_zip;
            String c_state;
            String c_city;
            String c_street_2;
            String c_street_1;
            String c_middle;
            String c_first;
            if (this.payUpdateWhse == null) {
                this.payUpdateWhse = this.conn.prepareStatement("UPDATE warehouse SET w_ytd = w_ytd + ?  WHERE w_id = ? ");
            }
            this.payUpdateWhse.setFloat(1, h_amount);
            this.payUpdateWhse.setInt(2, w_id);
            this.result = this.payUpdateWhse.executeUpdate();
            if (this.result == 0) {
                throw new Exception("W_ID=" + w_id + " not found!");
            }
            if (this.payGetWhse == null) {
                this.payGetWhse = this.conn.prepareStatement("SELECT w_street_1, w_street_2, w_city, w_state, w_zip, w_name FROM warehouse WHERE w_id = ?");
            }
            this.payGetWhse.setInt(1, w_id);
            this.rs = this.payGetWhse.executeQuery();
            if (!this.rs.next()) {
                throw new Exception("W_ID=" + w_id + " not found!");
            }
            String w_street_1 = this.rs.getString("w_street_1");
            String w_street_2 = this.rs.getString("w_street_2");
            String w_city = this.rs.getString("w_city");
            String w_state = this.rs.getString("w_state");
            String w_zip = this.rs.getString("w_zip");
            String w_name = this.rs.getString("w_name");
            this.rs.close();
            this.rs = null;
            if (this.payUpdateDist == null) {
                this.payUpdateDist = this.conn.prepareStatement("UPDATE district SET d_ytd = d_ytd + ? WHERE d_w_id = ? AND d_id = ?");
            }
            this.payUpdateDist.setFloat(1, h_amount);
            this.payUpdateDist.setInt(2, w_id);
            this.payUpdateDist.setInt(3, d_id);
            this.result = this.payUpdateDist.executeUpdate();
            if (this.result == 0) {
                throw new Exception("D_ID=" + d_id + " D_W_ID=" + w_id + " not found!");
            }
            if (this.payGetDist == null) {
                this.payGetDist = this.conn.prepareStatement("SELECT d_street_1, d_street_2, d_city, d_state, d_zip, d_name FROM district WHERE d_w_id = ? AND d_id = ?");
            }
            this.payGetDist.setInt(1, w_id);
            this.payGetDist.setInt(2, d_id);
            this.rs = this.payGetDist.executeQuery();
            if (!this.rs.next()) {
                throw new Exception("D_ID=" + d_id + " D_W_ID=" + w_id + " not found!");
            }
            String d_street_1 = this.rs.getString("d_street_1");
            String d_street_2 = this.rs.getString("d_street_2");
            String d_city = this.rs.getString("d_city");
            String d_state = this.rs.getString("d_state");
            String d_zip = this.rs.getString("d_zip");
            String d_name = this.rs.getString("d_name");
            this.rs.close();
            this.rs = null;
            if (c_by_name) {
                if (this.payCountCust == null) {
                    this.payCountCust = this.conn.prepareStatement("SELECT count(c_id) AS namecnt FROM customer  WHERE c_last = ?  AND c_d_id = ? AND c_w_id = ?");
                }
                this.payCountCust.setString(1, c_last);
                this.payCountCust.setInt(2, c_d_id);
                this.payCountCust.setInt(3, c_w_id);
                this.rs = this.payCountCust.executeQuery();
                if (!this.rs.next()) {
                    throw new Exception("C_LAST=" + c_last + " C_D_ID=" + c_d_id + " C_W_ID=" + c_w_id + " not found!");
                }
                int namecnt = this.rs.getInt("namecnt");
                this.rs.close();
                this.rs = null;
                if (this.payCursorCustByName == null) {
                    this.payCursorCustByName = this.conn.prepareStatement("SELECT c_first, c_middle, c_id, c_street_1, c_street_2, c_city, c_state, c_zip,       c_phone, c_credit, c_credit_lim, c_discount, c_balance, c_since   FROM customer WHERE c_w_id = ? AND c_d_id = ? AND c_last = ? ORDER BY c_w_id, c_d_id, c_last, c_first ");
                }
                this.payCursorCustByName.setInt(1, c_w_id);
                this.payCursorCustByName.setInt(2, c_d_id);
                this.payCursorCustByName.setString(3, c_last);
                this.rs = this.payCursorCustByName.executeQuery();
                if (!this.rs.next()) {
                    throw new Exception("C_LAST=" + c_last + " C_D_ID=" + c_d_id + " C_W_ID=" + c_w_id + " not found!");
                }
                if (namecnt % 2 == 1) {
                    ++namecnt;
                }
                for (int i = 1; i < namecnt / 2; ++i) {
                    this.rs.next();
                }
                c_id = this.rs.getInt("c_id");
                c_first = this.rs.getString("c_first");
                c_middle = this.rs.getString("c_middle");
                c_street_1 = this.rs.getString("c_street_1");
                c_street_2 = this.rs.getString("c_street_2");
                c_city = this.rs.getString("c_city");
                c_state = this.rs.getString("c_state");
                c_zip = this.rs.getString("c_zip");
                c_phone = this.rs.getString("c_phone");
                c_credit = this.rs.getString("c_credit");
                c_credit_lim = this.rs.getFloat("c_credit_lim");
                c_discount = this.rs.getFloat("c_discount");
                c_balance = this.rs.getFloat("c_balance");
                c_since = this.rs.getDate("c_since");
                this.rs.close();
                this.rs = null;
            } else {
                if (this.payGetCust == null) {
                    this.payGetCust = this.conn.prepareStatement("SELECT c_first, c_middle, c_last, c_street_1, c_street_2, c_city, c_state, c_zip,       c_phone, c_credit, c_credit_lim, c_discount, c_balance, c_since   FROM customer WHERE c_w_id = ? AND c_d_id = ? AND c_id = ?");
                }
                this.payGetCust.setInt(1, c_w_id);
                this.payGetCust.setInt(2, c_d_id);
                this.payGetCust.setInt(3, c_id);
                this.rs = this.payGetCust.executeQuery();
                if (!this.rs.next()) {
                    throw new Exception("C_ID=" + c_id + " C_D_ID=" + c_d_id + " C_W_ID=" + c_w_id + " not found!");
                }
                c_last = this.rs.getString("c_last");
                c_first = this.rs.getString("c_first");
                c_middle = this.rs.getString("c_middle");
                c_street_1 = this.rs.getString("c_street_1");
                c_street_2 = this.rs.getString("c_street_2");
                c_city = this.rs.getString("c_city");
                c_state = this.rs.getString("c_state");
                c_zip = this.rs.getString("c_zip");
                c_phone = this.rs.getString("c_phone");
                c_credit = this.rs.getString("c_credit");
                c_credit_lim = this.rs.getFloat("c_credit_lim");
                c_discount = this.rs.getFloat("c_discount");
                c_balance = this.rs.getFloat("c_balance");
                c_since = this.rs.getDate("c_since");
                this.rs.close();
                this.rs = null;
            }
            c_balance += h_amount;
            if (c_credit.equals("BC")) {
                if (this.payGetCustCdata == null) {
                    this.payGetCustCdata = this.conn.prepareStatement("SELECT c_data FROM customer WHERE c_w_id = ? AND c_d_id = ? AND c_id = ?");
                }
                this.payGetCustCdata.setInt(1, c_w_id);
                this.payGetCustCdata.setInt(2, c_d_id);
                this.payGetCustCdata.setInt(3, c_id);
                this.rs = this.payGetCustCdata.executeQuery();
                if (!this.rs.next()) {
                    throw new Exception("C_ID=" + c_id + " C_W_ID=" + c_w_id + " C_D_ID=" + c_d_id + " not found!");
                }
                c_data = this.rs.getString("c_data");
                this.rs.close();
                this.rs = null;
                String c_new_data = c_id + " " + c_d_id + " " + c_w_id + " " + d_id + " " + w_id + " " + h_amount + " |";
                c_new_data = c_data.length() > c_new_data.length() ? c_new_data + c_data.substring(0, c_data.length() - c_new_data.length()) : c_new_data + c_data;
                if (c_new_data.length() > 500) {
                    c_new_data = c_new_data.substring(0, 500);
                }
                if (this.payUpdateCustBalCdata == null) {
                    this.payUpdateCustBalCdata = this.conn.prepareStatement("UPDATE customer SET c_balance = ?, c_data = ?  WHERE c_w_id = ? AND c_d_id = ? AND c_id = ?");
                }
                this.payUpdateCustBalCdata.setFloat(1, c_balance);
                this.payUpdateCustBalCdata.setString(2, c_new_data);
                this.payUpdateCustBalCdata.setInt(3, c_w_id);
                this.payUpdateCustBalCdata.setInt(4, c_d_id);
                this.payUpdateCustBalCdata.setInt(5, c_id);
                this.result = this.payUpdateCustBalCdata.executeUpdate();
                if (this.result == 0) {
                    throw new Exception("Error in PYMNT Txn updating Customer C_ID=" + c_id + " C_W_ID=" + c_w_id + " C_D_ID=" + c_d_id);
                }
            } else {
                if (this.payUpdateCustBal == null) {
                    this.payUpdateCustBal = this.conn.prepareStatement("UPDATE customer SET c_balance = ? WHERE c_w_id = ? AND c_d_id = ? AND c_id = ?");
                }
                this.payUpdateCustBal.setFloat(1, c_balance);
                this.payUpdateCustBal.setInt(2, c_w_id);
                this.payUpdateCustBal.setInt(3, c_d_id);
                this.payUpdateCustBal.setInt(4, c_id);
                this.result = this.payUpdateCustBal.executeUpdate();
                if (this.result == 0) {
                    throw new Exception("C_ID=" + c_id + " C_W_ID=" + c_w_id + " C_D_ID=" + c_d_id + " not found!");
                }
            }
            if (w_name.length() > 10) {
                w_name = w_name.substring(0, 10);
            }
            if (d_name.length() > 10) {
                d_name = d_name.substring(0, 10);
            }
            String h_data = w_name + "    " + d_name;
            if (this.payInsertHist == null) {
                this.payInsertHist = this.conn.prepareStatement("INSERT INTO history (h_c_d_id, h_c_w_id, h_c_id, h_d_id, h_w_id, h_date, h_amount, h_data)  VALUES (?,?,?,?,?,?,?,?)");
            }
            this.payInsertHist.setInt(1, c_d_id);
            this.payInsertHist.setInt(2, c_w_id);
            this.payInsertHist.setInt(3, c_id);
            this.payInsertHist.setInt(4, d_id);
            this.payInsertHist.setInt(5, w_id);
            this.payInsertHist.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            this.payInsertHist.setFloat(7, h_amount);
            this.payInsertHist.setString(8, h_data);
            this.payInsertHist.executeUpdate();
            this.transCommit();
            StringBuffer terminalMessage = new StringBuffer();
            terminalMessage.append("\n+---------------------------- PAYMENT ----------------------------+");
            terminalMessage.append("\n Date: " + jTPCCUtil.getCurrentTime());
            terminalMessage.append("\n\n Warehouse: ");
            terminalMessage.append(w_id);
            terminalMessage.append("\n   Street:  ");
            terminalMessage.append(w_street_1);
            terminalMessage.append("\n   Street:  ");
            terminalMessage.append(w_street_2);
            terminalMessage.append("\n   City:    ");
            terminalMessage.append(w_city);
            terminalMessage.append("   State: ");
            terminalMessage.append(w_state);
            terminalMessage.append("  Zip: ");
            terminalMessage.append(w_zip);
            terminalMessage.append("\n\n District:  ");
            terminalMessage.append(d_id);
            terminalMessage.append("\n   Street:  ");
            terminalMessage.append(d_street_1);
            terminalMessage.append("\n   Street:  ");
            terminalMessage.append(d_street_2);
            terminalMessage.append("\n   City:    ");
            terminalMessage.append(d_city);
            terminalMessage.append("   State: ");
            terminalMessage.append(d_state);
            terminalMessage.append("  Zip: ");
            terminalMessage.append(d_zip);
            terminalMessage.append("\n\n Customer:  ");
            terminalMessage.append(c_id);
            terminalMessage.append("\n   Name:    ");
            terminalMessage.append(c_first);
            terminalMessage.append(" ");
            terminalMessage.append(c_middle);
            terminalMessage.append(" ");
            terminalMessage.append(c_last);
            terminalMessage.append("\n   Street:  ");
            terminalMessage.append(c_street_1);
            terminalMessage.append("\n   Street:  ");
            terminalMessage.append(c_street_2);
            terminalMessage.append("\n   City:    ");
            terminalMessage.append(c_city);
            terminalMessage.append("   State: ");
            terminalMessage.append(c_state);
            terminalMessage.append("  Zip: ");
            terminalMessage.append(c_zip);
            terminalMessage.append("\n   Since:   ");
            if (c_since != null) {
                terminalMessage.append(c_since.toString());
            } else {
                terminalMessage.append("");
            }
            terminalMessage.append("\n   Credit:  ");
            terminalMessage.append(c_credit);
            terminalMessage.append("\n   %Disc:   ");
            terminalMessage.append(c_discount);
            terminalMessage.append("\n   Phone:   ");
            terminalMessage.append(c_phone);
            terminalMessage.append("\n\n Amount Paid:      ");
            terminalMessage.append(h_amount);
            terminalMessage.append("\n Credit Limit:     ");
            terminalMessage.append(c_credit_lim);
            terminalMessage.append("\n New Cust-Balance: ");
            terminalMessage.append(c_balance);
            if (c_credit.equals("BC")) {
                if (c_data.length() > 50) {
                    terminalMessage.append("\n\n Cust-Data: " + c_data.substring(0, 50));
                    int data_chunks = c_data.length() > 200 ? 4 : c_data.length() / 50;
                    for (int n = 1; n < data_chunks; ++n) {
                        terminalMessage.append("\n            " + c_data.substring(n * 50, (n + 1) * 50));
                    }
                } else {
                    terminalMessage.append("\n\n Cust-Data: " + c_data);
                }
            }
            terminalMessage.append("\n+-----------------------------------------------------------------+\n\n");
            this.terminalMessage(terminalMessage.toString());
        }
        catch (Exception e) {
            this.error("PAYMENT");
            this.logException(e);
            try {
                this.terminalMessage("Performing ROLLBACK...");
                this.transRollback();
            }
            catch (Exception e1) {
                this.error("PAYMENT-ROLLBACK");
                this.logException(e1);
            }
        }
    }

    private void error(String type) {
        this.errorOutputArea.println("[ERROR] TERMINAL=" + this.terminalName + "  TYPE=" + type + "  COUNT=" + this.transactionCount);
    }

    private void logException(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        printWriter.close();
        this.errorOutputArea.println(stringWriter.toString());
    }

    private void terminalMessage(String message) {
        this.terminalOutputArea.println(message);
    }

    private void printMessage(String message) {
        if (this.debugMessages) {
            this.terminalOutputArea.println("[ jTPCC ] " + message);
        }
    }

    void transRollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException se) {
            System.out.println(se.getMessage());
        }
    }

    void transCommit() {
        try {
            this.conn.commit();
        }
        catch (SQLException se) {
            System.out.println(se.getMessage());
            this.transRollback();
        }
    }
}

