/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.ActionServletWrapper;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.ModuleUtils;

public class RequestUtils {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$struts$util$RequestUtils == null ? (class$org$apache$struts$util$RequestUtils = RequestUtils.class$("org.apache.struts.util.RequestUtils")) : class$org$apache$struts$util$RequestUtils));
    static /* synthetic */ Class class$org$apache$struts$util$RequestUtils;

    public static URL absoluteURL(HttpServletRequest request, String path) throws MalformedURLException {
        return new URL(RequestUtils.serverURL(request), request.getContextPath() + path);
    }

    public static Class applicationClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$org$apache$struts$util$RequestUtils == null ? (class$org$apache$struts$util$RequestUtils = RequestUtils.class$("org.apache.struts.util.RequestUtils")) : class$org$apache$struts$util$RequestUtils).getClassLoader();
        }
        return classLoader.loadClass(className);
    }

    public static Object applicationInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return RequestUtils.applicationClass(className).newInstance();
    }

    public static ActionForm createActionForm(HttpServletRequest request, ActionMapping mapping, ModuleConfig moduleConfig, ActionServlet servlet) {
        String attribute = mapping.getAttribute();
        if (attribute == null) {
            return null;
        }
        String name = mapping.getName();
        FormBeanConfig config = moduleConfig.findFormBeanConfig(name);
        if (config == null) {
            log.warn((Object)("No FormBeanConfig found under '" + name + "'"));
            return null;
        }
        ActionForm instance = RequestUtils.lookupActionForm(request, attribute, mapping.getScope());
        try {
            if (instance != null && RequestUtils.canReuseActionForm(instance, config)) {
                return instance;
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)servlet.getInternal().getMessage("formBean", (Object)config.getType()), (Throwable)e);
            return null;
        }
        return RequestUtils.createActionForm(config, servlet);
    }

    private static ActionForm lookupActionForm(HttpServletRequest request, String attribute, String scope) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Looking for ActionForm bean instance in scope '" + scope + "' under attribute key '" + attribute + "'"));
        }
        ActionForm instance = null;
        HttpSession session = null;
        if ("request".equals(scope)) {
            instance = (ActionForm)request.getAttribute(attribute);
        } else {
            session = request.getSession();
            instance = (ActionForm)session.getAttribute(attribute);
        }
        return instance;
    }

    private static boolean canReuseActionForm(ActionForm instance, FormBeanConfig config) throws ClassNotFoundException {
        if (instance == null) {
            return false;
        }
        boolean canReuse = false;
        String formType = null;
        String className = null;
        if (config.getDynamic()) {
            className = ((DynaBean)instance).getDynaClass().getName();
            canReuse = className.equals(config.getName());
            formType = "DynaActionForm";
        } else {
            Class configClass = RequestUtils.applicationClass(config.getType());
            className = instance.getClass().getName();
            canReuse = configClass.isAssignableFrom(instance.getClass());
            formType = "ActionForm";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Can recycle existing " + formType + " instance " + "of type '" + className + "'?: " + canReuse));
            log.trace((Object)(" --> " + instance));
        }
        return canReuse;
    }

    public static ActionForm createActionForm(FormBeanConfig config, ActionServlet servlet) {
        if (config == null) {
            return null;
        }
        ActionForm instance = null;
        try {
            instance = config.createActionForm(servlet);
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Creating new " + (config.getDynamic() ? "DynaActionForm" : "ActionForm") + " instance of type '" + config.getType() + "'"));
                log.trace((Object)(" --> " + instance));
            }
        }
        catch (Throwable t) {
            log.error((Object)servlet.getInternal().getMessage("formBean", (Object)config.getType()), t);
        }
        return instance;
    }

    public static Locale getUserLocale(HttpServletRequest request, String locale) {
        Locale userLocale = null;
        HttpSession session = request.getSession(false);
        if (locale == null) {
            locale = "org.apache.struts.action.LOCALE";
        }
        if (session != null) {
            userLocale = (Locale)session.getAttribute(locale);
        }
        if (userLocale == null) {
            userLocale = request.getLocale();
        }
        return userLocale;
    }

    public static void populate(Object bean, HttpServletRequest request) throws ServletException {
        RequestUtils.populate(bean, null, null, request);
    }

    public static void populate(Object bean, String prefix, String suffix, HttpServletRequest request) throws ServletException {
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        Enumeration names = null;
        Map multipartParameters = null;
        String contentType = request.getContentType();
        String method = request.getMethod();
        boolean isMultipart = false;
        if (contentType != null && contentType.startsWith("multipart/form-data") && method.equalsIgnoreCase("POST")) {
            if (!(bean instanceof ActionForm)) {
                throw new ServletException("bean that's supposed to be populated from a multipart request is not of type \"org.apache.struts.action.ActionForm\", but type \"" + bean.getClass().getName() + "\"");
            }
            ActionServletWrapper servlet = ((ActionForm)bean).getServletWrapper();
            MultipartRequestHandler multipartHandler = RequestUtils.getMultipartHandler(request);
            ((ActionForm)bean).setMultipartRequestHandler(multipartHandler);
            if (multipartHandler != null) {
                isMultipart = true;
                servlet.setServletFor(multipartHandler);
                multipartHandler.setMapping((ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance"));
                multipartHandler.handleRequest(request);
                Boolean maxLengthExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
                if (maxLengthExceeded != null && maxLengthExceeded.booleanValue()) {
                    return;
                }
                multipartParameters = RequestUtils.getAllParametersForMultipartRequest(request, multipartHandler);
                names = Collections.enumeration(multipartParameters.keySet());
            }
        }
        if (!isMultipart) {
            names = request.getParameterNames();
        }
        while (names.hasMoreElements()) {
            String name;
            String stripped = name = (String)names.nextElement();
            if (prefix != null) {
                if (!stripped.startsWith(prefix)) continue;
                stripped = stripped.substring(prefix.length());
            }
            if (suffix != null) {
                if (!stripped.endsWith(suffix)) continue;
                stripped = stripped.substring(0, stripped.length() - suffix.length());
            }
            String[] parameterValue = null;
            parameterValue = isMultipart ? (String[])multipartParameters.get(name) : request.getParameterValues(name);
            if (stripped.startsWith("org.apache.struts.")) continue;
            properties.put(stripped, parameterValue);
        }
        try {
            BeanUtils.populate((Object)bean, properties);
        }
        catch (Exception e) {
            throw new ServletException("BeanUtils.populate", (Throwable)e);
        }
    }

    private static MultipartRequestHandler getMultipartHandler(HttpServletRequest request) throws ServletException {
        ModuleConfig moduleConfig;
        MultipartRequestHandler multipartHandler = null;
        String multipartClass = (String)request.getAttribute("org.apache.struts.action.mapping.multipartclass");
        request.removeAttribute("org.apache.struts.action.mapping.multipartclass");
        if (multipartClass != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance(multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                log.error((Object)("MultipartRequestHandler class \"" + multipartClass + "\" in mapping class not found, " + "defaulting to global multipart class"));
            }
            catch (InstantiationException ie) {
                log.error((Object)("InstantiationException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + ie.getMessage()));
            }
            catch (IllegalAccessException iae) {
                log.error((Object)("IllegalAccessException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + iae.getMessage()));
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        if ((multipartClass = (moduleConfig = ModuleUtils.getInstance().getModuleConfig(request)).getControllerConfig().getMultipartClass()) != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance(multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServletException("Cannot find multipart class \"" + multipartClass + "\"" + ", exception: " + cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                throw new ServletException("InstantiationException when instantiating multipart class \"" + multipartClass + "\", exception: " + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new ServletException("IllegalAccessException when instantiating multipart class \"" + multipartClass + "\", exception: " + iae.getMessage());
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        return multipartHandler;
    }

    private static Map getAllParametersForMultipartRequest(HttpServletRequest request, MultipartRequestHandler multipartHandler) {
        String key;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Hashtable elements = multipartHandler.getAllElements();
        Enumeration e = elements.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            parameters.put(key, elements.get(key));
        }
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
            e = request.getParameterNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                parameters.put(key, request.getParameterValues(key));
            }
        } else {
            log.debug((Object)"Gathering multipart parameters for unwrapped request");
        }
        return parameters;
    }

    public static String printableURL(URL url) {
        if (url.getHost() != null) {
            return url.toString();
        }
        String file = url.getFile();
        String ref = url.getRef();
        if (ref == null) {
            return file;
        }
        StringBuffer sb = new StringBuffer(file);
        sb.append('#');
        sb.append(ref);
        return sb.toString();
    }

    public static String actionURL(HttpServletRequest request, ActionConfig action, String pattern) {
        StringBuffer sb = new StringBuffer();
        if (pattern.endsWith("/*")) {
            sb.append(pattern.substring(0, pattern.length() - 2));
            sb.append(action.getPath());
        } else if (pattern.startsWith("*.")) {
            ModuleConfig appConfig = ModuleUtils.getInstance().getModuleConfig(request);
            sb.append(appConfig.getPrefix());
            sb.append(action.getPath());
            sb.append(pattern.substring(1));
        } else {
            throw new IllegalArgumentException(pattern);
        }
        return sb.toString();
    }

    public static String forwardURL(HttpServletRequest request, ForwardConfig forward) {
        return RequestUtils.forwardURL(request, forward, null);
    }

    public static String forwardURL(HttpServletRequest request, ForwardConfig forward, ModuleConfig moduleConfig) {
        if (moduleConfig == null) {
            moduleConfig = ModuleUtils.getInstance().getModuleConfig(request);
        }
        String path = forward.getPath();
        String prefix = moduleConfig.getPrefix();
        if (forward.getModule() != null && "/".equals(prefix = forward.getModule())) {
            prefix = "";
        }
        StringBuffer sb = new StringBuffer();
        if (forward.getContextRelative()) {
            if (!path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
            return sb.toString();
        }
        String forwardPattern = moduleConfig.getControllerConfig().getForwardPattern();
        if (forwardPattern == null) {
            sb.append(prefix);
            if (!path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
        } else {
            boolean dollar = false;
            int i = 0;
            while (i < forwardPattern.length()) {
                char ch = forwardPattern.charAt(i);
                if (dollar) {
                    switch (ch) {
                        case 'M': {
                            sb.append(prefix);
                            break;
                        }
                        case 'P': {
                            if (!path.startsWith("/")) {
                                sb.append("/");
                            }
                            sb.append(path);
                            break;
                        }
                        case '$': {
                            sb.append('$');
                            break;
                        }
                    }
                    dollar = false;
                } else if (ch == '$') {
                    dollar = true;
                } else {
                    sb.append(ch);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static URL requestURL(HttpServletRequest request) throws MalformedURLException {
        StringBuffer url = RequestUtils.requestToServerUriStringBuffer(request);
        return new URL(url.toString());
    }

    public static URL serverURL(HttpServletRequest request) throws MalformedURLException {
        StringBuffer url = RequestUtils.requestToServerStringBuffer(request);
        return new URL(url.toString());
    }

    public static StringBuffer requestToServerUriStringBuffer(HttpServletRequest request) {
        StringBuffer serverUri = RequestUtils.createServerUriStringBuffer(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRequestURI());
        return serverUri;
    }

    public static StringBuffer requestToServerStringBuffer(HttpServletRequest request) {
        return RequestUtils.createServerStringBuffer(request.getScheme(), request.getServerName(), request.getServerPort());
    }

    public static StringBuffer createServerStringBuffer(String scheme, String server, int port) {
        StringBuffer url = new StringBuffer();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(server);
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        return url;
    }

    public static StringBuffer createServerUriStringBuffer(String scheme, String server, int port, String uri) {
        StringBuffer serverUri = RequestUtils.createServerStringBuffer(scheme, server, port);
        serverUri.append(uri);
        return serverUri;
    }

    public static void selectModule(String prefix, HttpServletRequest request, ServletContext context) {
        ModuleUtils.getInstance().selectModule(prefix, request, context);
    }

    public static void selectModule(HttpServletRequest request, ServletContext context) {
        ModuleUtils.getInstance().selectModule(request, context);
    }

    public static String getModuleName(HttpServletRequest request, ServletContext context) {
        return ModuleUtils.getInstance().getModuleName(request, context);
    }

    public static String getModuleName(String matchPath, ServletContext context) {
        return ModuleUtils.getInstance().getModuleName(matchPath, context);
    }

    public static ModuleConfig getRequestModuleConfig(HttpServletRequest request) {
        return ModuleUtils.getInstance().getModuleConfig(request);
    }

    public static ModuleConfig getModuleConfig(HttpServletRequest request, ServletContext context) {
        return ModuleUtils.getInstance().getModuleConfig(request, context);
    }

    public static String[] getModulePrefixes(ServletContext context) {
        return ModuleUtils.getInstance().getModulePrefixes(context);
    }

    public static Map computeParameters(PageContext pageContext, String paramId, String paramName, String paramProperty, String paramScope, String name, String property, String scope, boolean transaction) throws JspException {
        return TagUtils.getInstance().computeParameters(pageContext, paramId, paramName, paramProperty, paramScope, name, property, scope, transaction);
    }

    public static String computeURL(PageContext pageContext, String forward, String href, String page, Map params, String anchor, boolean redirect) throws MalformedURLException {
        return TagUtils.getInstance().computeURLWithCharEncoding(pageContext, forward, href, page, null, null, params, anchor, redirect, false);
    }

    public static String computeURL(PageContext pageContext, String forward, String href, String page, String action, Map params, String anchor, boolean redirect) throws MalformedURLException {
        return TagUtils.getInstance().computeURL(pageContext, forward, href, page, action, null, params, anchor, redirect);
    }

    public static String computeURL(PageContext pageContext, String forward, String href, String page, String action, Map params, String anchor, boolean redirect, boolean encodeSeparator) throws MalformedURLException {
        return TagUtils.getInstance().computeURL(pageContext, forward, href, page, action, null, params, anchor, redirect, encodeSeparator);
    }

    public static String getActionMappingName(String action) {
        return TagUtils.getInstance().getActionMappingName(action);
    }

    public static String getActionMappingURL(String action, PageContext pageContext) {
        return TagUtils.getInstance().getActionMappingURL(action, pageContext);
    }

    public static Object lookup(PageContext pageContext, String name, String scopeName) throws JspException {
        return TagUtils.getInstance().lookup(pageContext, name, scopeName);
    }

    public static int getScope(String scopeName) throws JspException {
        return TagUtils.getInstance().getScope(scopeName);
    }

    public static Object lookup(PageContext pageContext, String name, String property, String scope) throws JspException {
        return TagUtils.getInstance().lookup(pageContext, name, property, scope);
    }

    public static Locale retrieveUserLocale(PageContext pageContext, String locale) {
        return TagUtils.getInstance().getUserLocale(pageContext, locale);
    }

    public static String message(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        return TagUtils.getInstance().message(pageContext, bundle, locale, key);
    }

    public static String message(PageContext pageContext, String bundle, String locale, String key, Object[] args) throws JspException {
        return TagUtils.getInstance().message(pageContext, bundle, locale, key, args);
    }

    public static boolean present(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        return TagUtils.getInstance().present(pageContext, bundle, locale, key);
    }

    public static String pageURL(HttpServletRequest request, String page) {
        ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(request);
        return TagUtils.getInstance().pageURL(request, page, moduleConfig);
    }

    public static void saveException(PageContext pageContext, Throwable exception) {
        TagUtils.getInstance().saveException(pageContext, exception);
    }

    public static ModuleConfig getModuleConfig(PageContext pageContext) {
        return TagUtils.getInstance().getModuleConfig(pageContext);
    }

    public static ActionMessages getActionMessages(PageContext pageContext, String paramName) throws JspException {
        return TagUtils.getInstance().getActionMessages(pageContext, paramName);
    }

    public static ActionErrors getActionErrors(PageContext pageContext, String paramName) throws JspException {
        return TagUtils.getInstance().getActionErrors(pageContext, paramName);
    }

    public static String encodeURL(String url) {
        return TagUtils.getInstance().encodeURL(url);
    }

    public static boolean isXhtml(PageContext pageContext) {
        String xhtml = (String)pageContext.getAttribute("org.apache.struts.globals.XHTML", 1);
        return "true".equalsIgnoreCase(xhtml);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

