/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRBaseChart
extends JRBaseElement
implements JRChart {
    private static final long serialVersionUID = 10002L;
    protected byte chartType = 0;
    protected boolean isShowLegend = false;
    protected byte evaluationTime = 1;
    protected byte hyperlinkType = 1;
    protected byte hyperlinkTarget = 1;
    protected byte titlePosition = 1;
    protected Color titleColor = Color.black;
    protected Color subtitleColor = Color.black;
    protected JRBox box = null;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected String customizerClass;
    protected JRGroup evaluationGroup = null;
    protected JRExpression titleExpression = null;
    protected JRExpression subtitleExpression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    protected JRChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected int bookmarkLevel = 0;

    protected JRBaseChart(JRChart chart, JRBaseObjectFactory factory) {
        super(chart, factory);
        this.chartType = chart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 3: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 2: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 4: {
                this.dataset = factory.getXyzDataset((JRXyzDataset)chart.getDataset());
                this.plot = factory.getBubblePlot((JRBubblePlot)chart.getPlot());
                break;
            }
            case 5: {
                this.dataset = factory.getHighLowDataset((JRHighLowDataset)chart.getDataset());
                this.plot = factory.getCandlestickPlot((JRCandlestickPlot)chart.getPlot());
                break;
            }
            case 6: {
                this.dataset = factory.getHighLowDataset((JRHighLowDataset)chart.getDataset());
                this.plot = factory.getHighLowPlot((JRHighLowPlot)chart.getPlot());
                break;
            }
            case 7: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case 9: {
                this.dataset = factory.getPieDataset((JRPieDataset)chart.getDataset());
                this.plot = factory.getPiePlot((JRPiePlot)chart.getPlot());
                break;
            }
            case 8: {
                this.dataset = factory.getPieDataset((JRPieDataset)chart.getDataset());
                this.plot = factory.getPie3DPlot((JRPie3DPlot)chart.getPlot());
                break;
            }
            case 10: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getScatterPlot((JRScatterPlot)chart.getPlot());
                break;
            }
            case 12: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 11: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 16: {
                this.dataset = factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
                this.plot = factory.getTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
                break;
            }
            case 13: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 14: {
                switch (chart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
                        break;
                    }
                    case 5: {
                        this.dataset = factory.getTimePeriodDataset((JRTimePeriodDataset)chart.getDataset());
                        break;
                    }
                    case 3: {
                        this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                    }
                }
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 15: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        this.isShowLegend = chart.isShowLegend();
        this.evaluationTime = chart.getEvaluationTime();
        this.hyperlinkType = chart.getHyperlinkType();
        this.hyperlinkTarget = chart.getHyperlinkTarget();
        this.titlePosition = chart.getTitlePosition();
        this.titleColor = chart.getTitleColor();
        this.subtitleColor = chart.getSubtitleColor();
        this.box = chart.getBox();
        this.titleFont = factory.getFont(chart.getTitleFont());
        this.subtitleFont = factory.getFont(chart.getSubtitleFont());
        this.evaluationGroup = factory.getGroup(chart.getEvaluationGroup());
        this.titleExpression = factory.getExpression(chart.getTitleExpression());
        this.subtitleExpression = factory.getExpression(chart.getSubtitleExpression());
        this.anchorNameExpression = factory.getExpression(chart.getAnchorNameExpression());
        this.hyperlinkReferenceExpression = factory.getExpression(chart.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(chart.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(chart.getHyperlinkPageExpression());
        this.bookmarkLevel = chart.getBookmarkLevel();
        this.customizerClass = chart.getCustomizerClass();
    }

    public boolean isShowLegend() {
        return this.isShowLegend;
    }

    public void setShowLegend(boolean isShowLegend) {
        this.isShowLegend = isShowLegend;
    }

    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRBox getBox() {
        return this.box;
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public byte getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(byte titlePosition) {
        this.titlePosition = titlePosition;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public Color getSubtitleColor() {
        return this.subtitleColor;
    }

    public void setSubtitleColor(Color subtitleColor) {
        this.subtitleColor = subtitleColor;
    }

    public byte getHyperlinkType() {
        return this.hyperlinkType;
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    public byte getChartType() {
        return this.chartType;
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getChart(this);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void writeXml(JRXmlWriter xmlWriter) {
        xmlWriter.writeChartTag(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }
}

