/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDefaultFontProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.util.JRTextAttribute;

public class JRBaseFont
implements JRFont,
Serializable {
    private static final long serialVersionUID = 10002L;
    private static final String DEFAULT_FONT_NAME = "sansserif";
    private static final boolean DEFAULT_FONT_BOLD = false;
    private static final boolean DEFAULT_FONT_ITALIC = false;
    private static final boolean DEFAULT_FONT_UNDERLINE = false;
    private static final boolean DEFAULT_FONT_STRIKETHROUGH = false;
    private static final int DEFAULT_FONT_SIZE = 10;
    private static final String DEFAULT_PDF_FONT_NAME = "Helvetica";
    private static final String DEFAULT_PDF_ENCODING = "Cp1252";
    private static final boolean DEFAULT_PDF_EMBEDDED = false;
    private static JRFont defaultFont = null;
    protected JRDefaultFontProvider defaultFontProvider = null;
    protected JRReportFont reportFont = null;
    protected String fontName = null;
    protected Boolean isBold = null;
    protected Boolean isItalic = null;
    protected Boolean isUnderline = null;
    protected Boolean isStrikeThrough = null;
    protected Integer size = null;
    protected String pdfFontName = null;
    protected String pdfEncoding = null;
    protected Boolean isPdfEmbedded = null;
    protected boolean isCachingAttributes = false;
    protected transient Map attributes = null;

    public JRBaseFont() {
    }

    public JRBaseFont(Map attributes) {
        Boolean isPdfEmbeddedAttr;
        String pdfEncodingAttr;
        String pdfFontNameAttr;
        Object strikeThrough;
        Object underline;
        Float sizeAttr;
        Object italic;
        Object bold;
        String fontNameAttr = (String)attributes.get(TextAttribute.FAMILY);
        if (fontNameAttr != null) {
            this.setFontName(fontNameAttr);
        }
        if ((bold = attributes.get(TextAttribute.WEIGHT)) != null) {
            this.setBold(TextAttribute.WEIGHT_BOLD.equals(bold));
        }
        if ((italic = attributes.get(TextAttribute.POSTURE)) != null) {
            this.setItalic(TextAttribute.POSTURE_OBLIQUE.equals(italic));
        }
        if ((sizeAttr = (Float)attributes.get(TextAttribute.SIZE)) != null) {
            this.setSize(sizeAttr.intValue());
        }
        if ((underline = attributes.get(TextAttribute.UNDERLINE)) != null) {
            this.setUnderline(TextAttribute.UNDERLINE_ON.equals(underline));
        }
        if ((strikeThrough = attributes.get(TextAttribute.STRIKETHROUGH)) != null) {
            this.setStrikeThrough(TextAttribute.STRIKETHROUGH_ON.equals(strikeThrough));
        }
        if ((pdfFontNameAttr = (String)attributes.get(JRTextAttribute.PDF_FONT_NAME)) != null) {
            this.setPdfFontName(pdfFontNameAttr);
        }
        if ((pdfEncodingAttr = (String)attributes.get(JRTextAttribute.PDF_ENCODING)) != null) {
            this.setPdfEncoding(pdfEncodingAttr);
        }
        if ((isPdfEmbeddedAttr = (Boolean)attributes.get(JRTextAttribute.IS_PDF_EMBEDDED)) != null) {
            this.setPdfEmbedded((boolean)isPdfEmbeddedAttr);
        }
    }

    protected JRBaseFont(JRDefaultFontProvider defaultFontProvider) {
        this.defaultFontProvider = defaultFontProvider;
    }

    public JRBaseFont(JRDefaultFontProvider defaultFontProvider, JRReportFont reportFont, JRFont font) {
        this.defaultFontProvider = defaultFontProvider;
        this.reportFont = reportFont;
        this.fontName = font.getOwnFontName();
        this.isBold = font.isOwnBold();
        this.isItalic = font.isOwnItalic();
        this.isUnderline = font.isOwnUnderline();
        this.isStrikeThrough = font.isOwnStrikeThrough();
        this.size = font.getOwnSize();
        this.pdfFontName = font.getOwnPdfFontName();
        this.pdfEncoding = font.getOwnPdfEncoding();
        this.isPdfEmbedded = font.isOwnPdfEmbedded();
        this.isCachingAttributes = font.isCachingAttributes();
    }

    public JRDefaultFontProvider getDefaultFontProvider() {
        return this.defaultFontProvider;
    }

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public String getFontName() {
        if (this.fontName == null) {
            return this.getBaseFont().getFontName();
        }
        return this.fontName;
    }

    public String getOwnFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
        this.attributes = null;
    }

    public boolean isBold() {
        if (this.isBold == null) {
            return this.getBaseFont().isBold();
        }
        return this.isBold;
    }

    public Boolean isOwnBold() {
        return this.isBold;
    }

    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBold(Boolean isBold) {
        this.isBold = isBold;
        this.attributes = null;
    }

    public boolean isItalic() {
        if (this.isItalic == null) {
            return this.getBaseFont().isItalic();
        }
        return this.isItalic;
    }

    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
        this.attributes = null;
    }

    public boolean isUnderline() {
        if (this.isUnderline == null) {
            return this.getBaseFont().isUnderline();
        }
        return this.isUnderline;
    }

    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
        this.attributes = null;
    }

    public boolean isStrikeThrough() {
        if (this.isStrikeThrough == null) {
            return this.getBaseFont().isStrikeThrough();
        }
        return this.isStrikeThrough;
    }

    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStrikeThrough(Boolean isStrikeThrough) {
        this.isStrikeThrough = isStrikeThrough;
        this.attributes = null;
    }

    public int getSize() {
        if (this.size == null) {
            return this.getBaseFont().getSize();
        }
        return this.size;
    }

    public Integer getOwnSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.setSize(new Integer(size));
    }

    public void setSize(Integer size) {
        this.size = size;
        this.attributes = null;
    }

    public String getPdfFontName() {
        if (this.pdfFontName == null) {
            return this.getBaseFont().getPdfFontName();
        }
        return this.pdfFontName;
    }

    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    public void setPdfFontName(String pdfFontName) {
        this.pdfFontName = pdfFontName;
    }

    public String getPdfEncoding() {
        if (this.pdfEncoding == null) {
            return this.getBaseFont().getPdfEncoding();
        }
        return this.pdfEncoding;
    }

    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    public boolean isPdfEmbedded() {
        if (this.isPdfEmbedded == null) {
            return this.getBaseFont().isPdfEmbedded();
        }
        return this.isPdfEmbedded;
    }

    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        this.isPdfEmbedded = isPdfEmbedded;
        this.attributes = null;
    }

    public boolean isCachingAttributes() {
        return this.isCachingAttributes;
    }

    public void setCachingAttributes(boolean isCachingAttributes) {
        this.isCachingAttributes = isCachingAttributes;
        this.attributes = null;
    }

    public Map getNonPdfAttributes() {
        HashMap<TextAttribute, Object> nonPdfAttributes = new HashMap<TextAttribute, Object>();
        nonPdfAttributes.put(TextAttribute.FAMILY, this.getFontName());
        nonPdfAttributes.put(TextAttribute.SIZE, new Float(this.getSize()));
        if (this.isBold()) {
            nonPdfAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this.isItalic()) {
            nonPdfAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (this.isUnderline()) {
            nonPdfAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.isStrikeThrough()) {
            nonPdfAttributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return nonPdfAttributes;
    }

    public Map getAttributes() {
        if (this.attributes == null || !this.isCachingAttributes) {
            this.attributes = this.getNonPdfAttributes();
            this.attributes.put(JRTextAttribute.PDF_FONT_NAME, this.getPdfFontName());
            this.attributes.put(JRTextAttribute.PDF_ENCODING, this.getPdfEncoding());
            if (this.isPdfEmbedded()) {
                this.attributes.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.TRUE);
            }
        }
        return this.attributes;
    }

    private JRFont getBaseFont() {
        JRFont baseFont = null;
        baseFont = this.reportFont != null ? this.reportFont : (this.defaultFontProvider != null && this.defaultFontProvider.getDefaultFont() != null ? this.defaultFontProvider.getDefaultFont() : JRBaseFont.getDefaultFont());
        return baseFont;
    }

    private static JRFont getDefaultFont() {
        if (defaultFont == null) {
            defaultFont = new JRBaseFont();
            defaultFont.setFontName(DEFAULT_FONT_NAME);
            defaultFont.setBold(false);
            defaultFont.setItalic(false);
            defaultFont.setUnderline(false);
            defaultFont.setStrikeThrough(false);
            defaultFont.setSize(10);
            defaultFont.setPdfFontName(DEFAULT_PDF_FONT_NAME);
            defaultFont.setPdfEncoding(DEFAULT_PDF_ENCODING);
            defaultFont.setPdfEmbedded(false);
        }
        return defaultFont;
    }
}

