/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import net.sf.jasperreports.charts.design.JRDesignAreaPlot;
import net.sf.jasperreports.charts.design.JRDesignBar3DPlot;
import net.sf.jasperreports.charts.design.JRDesignBarPlot;
import net.sf.jasperreports.charts.design.JRDesignBubblePlot;
import net.sf.jasperreports.charts.design.JRDesignCandlestickPlot;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowPlot;
import net.sf.jasperreports.charts.design.JRDesignLinePlot;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPiePlot;
import net.sf.jasperreports.charts.design.JRDesignScatterPlot;
import net.sf.jasperreports.charts.design.JRDesignTimePeriodDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesPlot;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXyzDataset;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRDesignChart
extends JRDesignElement
implements JRChart {
    private static final long serialVersionUID = 10002L;
    protected byte chartType = 0;
    protected boolean isShowLegend = false;
    protected byte evaluationTime = 1;
    protected byte hyperlinkType = 1;
    protected byte hyperlinkTarget = 1;
    protected byte titlePosition = 1;
    protected Color titleColor = Color.black;
    protected Color subtitleColor = Color.black;
    protected JRBox box = null;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected String customizerClass;
    protected JRGroup evaluationGroup = null;
    protected JRExpression titleExpression = null;
    protected JRExpression subtitleExpression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    protected JRChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected int bookmarkLevel = 0;

    public JRDesignChart(byte chartType) {
        this.setChartType(chartType);
    }

    public boolean isShowLegend() {
        return this.isShowLegend;
    }

    public void setShowLegend(boolean isShowLegend) {
        this.isShowLegend = isShowLegend;
    }

    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(byte evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(JRGroup group) {
        this.evaluationGroup = group;
    }

    public JRBox getBox() {
        return this.box;
    }

    public void setBox(JRBox box) {
        this.box = box;
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(JRFont font) {
        this.titleFont = font;
    }

    public byte getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(byte titlePosition) {
        this.titlePosition = titlePosition;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public void setSubtitleFont(JRFont font) {
        this.subtitleFont = font;
    }

    public Color getSubtitleColor() {
        return this.subtitleColor;
    }

    public void setSubtitleColor(Color subtitleColor) {
        this.subtitleColor = subtitleColor;
    }

    public byte getHyperlinkType() {
        return this.hyperlinkType;
    }

    public void setHyperlinkType(byte hyperlinkType) {
        this.hyperlinkType = hyperlinkType;
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public void setHyperlinkTarget(byte hyperlinkTarget) {
        this.hyperlinkTarget = hyperlinkTarget;
    }

    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    public void setTitleExpression(JRExpression expression) {
        this.titleExpression = expression;
    }

    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public void setSubtitleExpression(JRExpression expression) {
        this.subtitleExpression = expression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        this.anchorNameExpression = anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        this.hyperlinkPageExpression = hyperlinkPageExpression;
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    public byte getChartType() {
        return this.chartType;
    }

    public void setChartType(byte chartType) {
        this.chartType = chartType;
        switch (chartType) {
            case 1: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot);
                break;
            }
            case 3: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot);
                break;
            }
            case 2: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot);
                break;
            }
            case 4: {
                this.dataset = new JRDesignXyzDataset(this.dataset);
                this.plot = new JRDesignBubblePlot(this.plot);
                break;
            }
            case 5: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignCandlestickPlot(this.plot);
                break;
            }
            case 6: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignHighLowPlot(this.plot);
                break;
            }
            case 7: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot);
                break;
            }
            case 9: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPiePlot(this.plot);
                break;
            }
            case 8: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPie3DPlot(this.plot);
                break;
            }
            case 10: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignScatterPlot(this.plot);
                break;
            }
            case 12: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot);
                break;
            }
            case 11: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot);
                break;
            }
            case 16: {
                this.plot = new JRDesignTimeSeriesPlot(this.plot);
                break;
            }
            case 13: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot);
                break;
            }
            case 14: {
                this.plot = new JRDesignBarPlot(this.plot);
                break;
            }
            case 15: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    public void setDataset(JRChartDataset ds) {
        switch (ds.getDatasetType()) {
            case 6: {
                this.dataset = (JRDesignTimeSeriesDataset)ds;
                break;
            }
            case 5: {
                this.dataset = (JRDesignTimePeriodDataset)ds;
                break;
            }
            case 3: {
                this.dataset = (JRDesignXyDataset)ds;
            }
        }
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getChart(this);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void writeXml(JRXmlWriter xmlWriter) {
        switch (this.chartType) {
            case 1: {
                xmlWriter.writeAreaChart(this);
                break;
            }
            case 3: {
                xmlWriter.writeBarChart(this);
                break;
            }
            case 2: {
                xmlWriter.writeBar3DChart(this);
                break;
            }
            case 4: {
                xmlWriter.writeBubbleChart(this);
                break;
            }
            case 5: {
                xmlWriter.writeCandlestickChart(this);
                break;
            }
            case 6: {
                xmlWriter.writeHighLowChart(this);
                break;
            }
            case 7: {
                xmlWriter.writeLineChart(this);
                break;
            }
            case 9: {
                xmlWriter.writePieChart(this);
                break;
            }
            case 8: {
                xmlWriter.writePie3DChart(this);
                break;
            }
            case 10: {
                xmlWriter.writeScatterChart(this);
                break;
            }
            case 12: {
                xmlWriter.writeStackedBarChart(this);
                break;
            }
            case 11: {
                xmlWriter.writeStackedBar3DChart(this);
                break;
            }
            case 16: {
                xmlWriter.writeTimeSeriesChart(this);
                break;
            }
            case 13: {
                xmlWriter.writeXyAreaChart(this);
                break;
            }
            case 14: {
                xmlWriter.writeXyBarChart(this);
                break;
            }
            case 15: {
                xmlWriter.writeXyLineChart(this);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        this.bookmarkLevel = bookmarkLevel;
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public void setCustomizerClass(String customizerClass) {
        this.customizerClass = customizerClass;
    }
}

