/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDefaultFontProvider;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillTextField;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRQueryExecuter;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRBaseFiller
implements JRDefaultFontProvider {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRBaseFiller == null ? (class$net$sf$jasperreports$engine$fill$JRBaseFiller = JRBaseFiller.class$("net.sf.jasperreports.engine.fill.JRBaseFiller")) : class$net$sf$jasperreports$engine$fill$JRBaseFiller));
    protected JRBaseFiller parentFiller = null;
    private JRStyledTextParser styledTextParser = new JRStyledTextParser();
    private boolean isInterrupted = false;
    protected String name = null;
    protected int columnCount = 1;
    protected byte printOrder = 1;
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected byte orientation = 1;
    protected byte whenNoDataType = 1;
    protected int columnWidth = 0;
    protected int columnSpacing = 0;
    protected int leftMargin = 0;
    protected int rightMargin = 0;
    protected int topMargin = 0;
    protected int bottomMargin = 0;
    protected boolean isTitleNewPage = false;
    protected boolean isSummaryNewPage = false;
    protected boolean isFloatColumnFooter = false;
    protected String scriptletClassName = null;
    protected String resourceBundleBaseName = null;
    protected byte whenResourceMissingType = 1;
    protected JRReportFont defaultFont = null;
    protected JRReportFont[] fonts = null;
    protected JRFillParameter[] parameters = null;
    protected Map parametersMap = null;
    protected JRQuery query = null;
    protected JRFillField[] fields = null;
    protected Map fieldsMap = null;
    protected JRFillVariable[] variables = null;
    protected Map variablesMap = null;
    protected JRFillGroup[] groups = null;
    protected JRFillBand missingFillBand = null;
    protected JRFillBand background = null;
    protected JRFillBand title = null;
    protected JRFillBand pageHeader = null;
    protected JRFillBand columnHeader = null;
    protected JRFillBand detail = null;
    protected JRFillBand columnFooter = null;
    protected JRFillBand pageFooter = null;
    protected JRFillBand lastPageFooter = null;
    protected JRFillBand summary = null;
    protected JRCalculator calculator = null;
    protected Locale locale = null;
    protected ResourceBundle resourceBundle = null;
    protected JRAbstractScriptlet scriptlet = null;
    protected JRDataSource dataSource = null;
    protected JRVirtualizer virtualizer = null;
    protected Integer reportMaxCount = null;
    protected int reportCount = 0;
    protected List formattedTextFields = new ArrayList();
    protected Map loadedSubreports = null;
    protected JRFillContext fillContext;
    protected BoundElements perPageBoundElements = null;
    protected BoundElementMap reportBoundElements = null;
    protected BoundElementMap pageBoundElements = null;
    protected BoundElementMap columnBoundElements = null;
    protected Map groupBoundElements = null;
    protected JasperPrint jasperPrint = null;
    protected JRPrintPage printPage = null;
    protected int printPageStretchHeight = 0;
    protected boolean isParametersAlreadySet = false;
    protected JRFillChartDataset[] datasets;
    protected List bands;
    protected Set subfillers;
    private List identityPages;
    private Thread fillingThread;
    private PreparedStatement dataSourceStatement;
    protected Set variableCalculationReqs;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRBaseFiller;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$util$JRClassLoader;

    protected JRBaseFiller(JasperReport jasperReport, JRCalculator initCalculator, JRBaseFiller parentFiller) throws JRException {
        JRGroup[] jrGroups;
        int i;
        JRVariable[] jrVariables;
        JRParameter[] jrParameters;
        JRGraphEnvInitializer.initializeGraphEnv();
        this.parentFiller = parentFiller;
        this.fillContext = parentFiller == null ? new JRFillContext() : parentFiller.fillContext;
        this.name = jasperReport.getName();
        this.columnCount = jasperReport.getColumnCount();
        this.printOrder = jasperReport.getPrintOrder();
        this.pageWidth = jasperReport.getPageWidth();
        this.pageHeight = jasperReport.getPageHeight();
        this.orientation = jasperReport.getOrientation();
        this.whenNoDataType = jasperReport.getWhenNoDataType();
        this.columnWidth = jasperReport.getColumnWidth();
        this.columnSpacing = jasperReport.getColumnSpacing();
        this.leftMargin = jasperReport.getLeftMargin();
        this.rightMargin = jasperReport.getRightMargin();
        this.topMargin = jasperReport.getTopMargin();
        this.bottomMargin = jasperReport.getBottomMargin();
        this.isTitleNewPage = jasperReport.isTitleNewPage();
        this.isSummaryNewPage = jasperReport.isSummaryNewPage();
        this.isFloatColumnFooter = jasperReport.isFloatColumnFooter();
        this.scriptletClassName = jasperReport.getScriptletClass();
        this.resourceBundleBaseName = jasperReport.getResourceBundle();
        this.whenResourceMissingType = jasperReport.getWhenResourceMissingType();
        this.jasperPrint = new JasperPrint();
        JRFillObjectFactory factory = new JRFillObjectFactory(this);
        this.defaultFont = factory.getReportFont(jasperReport.getDefaultFont());
        JRReportFont[] jrFonts = jasperReport.getFonts();
        if (jrFonts != null && jrFonts.length > 0) {
            this.fonts = new JRReportFont[jrFonts.length];
            for (int i2 = 0; i2 < this.fonts.length; ++i2) {
                this.fonts[i2] = factory.getReportFont(jrFonts[i2]);
            }
        }
        if ((jrParameters = jasperReport.getParameters()) != null && jrParameters.length > 0) {
            this.parameters = new JRFillParameter[jrParameters.length];
            this.parametersMap = new HashMap();
            for (int i3 = 0; i3 < this.parameters.length; ++i3) {
                this.parameters[i3] = factory.getParameter(jrParameters[i3]);
                this.parametersMap.put(this.parameters[i3].getName(), this.parameters[i3]);
            }
        }
        this.query = jasperReport.getQuery();
        JRField[] jrFields = jasperReport.getFields();
        if (jrFields != null && jrFields.length > 0) {
            this.fields = new JRFillField[jrFields.length];
            this.fieldsMap = new HashMap();
            for (int i4 = 0; i4 < this.fields.length; ++i4) {
                this.fields[i4] = factory.getField(jrFields[i4]);
                this.fieldsMap.put(this.fields[i4].getName(), this.fields[i4]);
            }
        }
        if ((jrVariables = jasperReport.getVariables()) != null && jrVariables.length > 0) {
            ArrayList variableList = new ArrayList(jrVariables.length * 3);
            this.variablesMap = new HashMap();
            for (i = 0; i < jrVariables.length; ++i) {
                this.addVariable(jrVariables[i], variableList, factory);
            }
            this.setVariables(variableList);
        }
        if ((jrGroups = jasperReport.getGroups()) != null && jrGroups.length > 0) {
            this.groups = new JRFillGroup[jrGroups.length];
            for (i = 0; i < this.groups.length; ++i) {
                this.groups[i] = factory.getGroup(jrGroups[i]);
            }
        }
        this.missingFillBand = factory.getBand(null);
        this.background = factory.getBand(jasperReport.getBackground());
        this.title = factory.getBand(jasperReport.getTitle());
        this.pageHeader = factory.getBand(jasperReport.getPageHeader());
        this.columnHeader = factory.getBand(jasperReport.getColumnHeader());
        this.detail = factory.getBand(jasperReport.getDetail());
        this.columnFooter = factory.getBand(jasperReport.getColumnFooter());
        this.pageFooter = factory.getBand(jasperReport.getPageFooter());
        this.lastPageFooter = factory.getBand(jasperReport.getLastPageFooter());
        this.summary = factory.getBand(jasperReport.getSummary());
        this.datasets = factory.getDatasets();
        this.checkVariableCalculationReqs(factory);
        this.scriptlet = this.createScriptlet();
        this.scriptlet.setData(this.parametersMap, this.fieldsMap, this.variablesMap, this.groups);
        this.calculator = initCalculator == null ? JRDefaultCompiler.getInstance().loadCalculator(jasperReport) : initCalculator;
        this.calculator.init(this);
        this.initBands();
    }

    private void initBands() {
        this.bands = new ArrayList(8 + (this.groups == null ? 0 : 2 * this.groups.length));
        this.bands.add(this.title);
        this.bands.add(this.summary);
        this.bands.add(this.pageHeader);
        this.bands.add(this.pageFooter);
        this.bands.add(this.lastPageFooter);
        this.bands.add(this.columnHeader);
        this.bands.add(this.columnFooter);
        this.bands.add(this.detail);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                this.bands.add(group.getGroupHeader());
                this.bands.add(group.getGroupFooter());
            }
        }
    }

    public JRStyledTextParser getStyledTextParser() {
        return this.styledTextParser;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public JRReportFont getDefaultFont() {
        return this.defaultFont;
    }

    protected boolean isSubreport() {
        return this.parentFiller != null;
    }

    protected boolean isInterrupted() {
        return this.isInterrupted || this.parentFiller != null && this.parentFiller.isInterrupted();
    }

    protected void setInterrupted(boolean isInterrupted) {
        this.isInterrupted = isInterrupted;
    }

    protected JRPrintPage getCurrentPage() {
        return this.printPage;
    }

    protected JRReportFont[] getFonts() {
        return this.fonts;
    }

    protected int getCurrentPageStretchHeight() {
        return this.printPageStretchHeight;
    }

    protected abstract void setPageHeight(int var1);

    /*
     * Loose catch block
     */
    public JasperPrint fill(Map parameterValues, Connection conn) throws JRException {
        block23: {
            SQLException e22;
            ResultSet rs;
            PreparedStatement pstmt;
            block22: {
                this.fillingThread = Thread.currentThread();
                if (parameterValues == null) {
                    parameterValues = new HashMap<String, Connection>();
                }
                this.setParameters(parameterValues);
                if (this.parentFiller != null) {
                    this.parentFiller.registerSubfiller(this);
                }
                if (conn == null) {
                    conn = (Connection)parameterValues.get("REPORT_CONNECTION");
                }
                if (conn == null) {
                    parameterValues.remove("REPORT_CONNECTION");
                } else {
                    parameterValues.put("REPORT_CONNECTION", conn);
                }
                JRFillParameter parameter = (JRFillParameter)this.parametersMap.get("REPORT_CONNECTION");
                if (parameter != null) {
                    this.setParameter(parameter, conn);
                }
                if (conn == null && log.isWarnEnabled()) {
                    log.warn((Object)"The supplied java.sql.Connection object is null.");
                }
                pstmt = null;
                rs = null;
                JRResultSetDataSource ds = null;
                pstmt = JRQueryExecuter.getStatement(this.query, this.parametersMap, parameterValues, conn);
                if (pstmt != null) {
                    if (this.reportMaxCount != null) {
                        pstmt.setMaxRows(this.reportMaxCount);
                    }
                    this.dataSourceStatement = pstmt;
                    rs = pstmt.executeQuery();
                    this.dataSourceStatement = null;
                    ds = new JRResultSetDataSource(rs);
                }
                this.fill(parameterValues, ds);
                Object var8_8 = null;
                this.fillingThread = null;
                this.dataSourceStatement = null;
                if (rs == null) break block22;
                try {
                    rs.close();
                }
                catch (SQLException e22) {
                    // empty catch block
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e22) {}
            }
            break block23;
            {
                catch (SQLException e3) {
                    throw new JRException("Error executing SQL statement for report : " + this.name, e3);
                }
            }
            catch (Throwable throwable) {
                SQLException e22;
                Object var8_9 = null;
                this.fillingThread = null;
                this.dataSourceStatement = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e22) {
                        // empty catch block
                    }
                }
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return this.jasperPrint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JasperPrint fill(Map parameterValues, JRDataSource ds) throws JRException {
        this.fillingThread = Thread.currentThread();
        try {
            int i;
            this.dataSource = ds;
            if (parameterValues == null) {
                parameterValues = new HashMap<String, Object>();
            }
            this.setParameters(parameterValues);
            if (this.parentFiller != null) {
                this.parentFiller.registerSubfiller(this);
            }
            if (this.dataSource == null) {
                this.dataSource = (JRDataSource)parameterValues.get("REPORT_DATA_SOURCE");
            }
            if (this.dataSource == null) {
                parameterValues.remove("REPORT_DATA_SOURCE");
            } else {
                parameterValues.put("REPORT_DATA_SOURCE", this.dataSource);
            }
            JRFillParameter parameter = (JRFillParameter)this.parametersMap.get("REPORT_DATA_SOURCE");
            if (parameter != null) {
                this.setParameter(parameter, this.dataSource);
            }
            parameterValues.put("REPORT_SCRIPTLET", this.scriptlet);
            parameter = (JRFillParameter)this.parametersMap.get("REPORT_SCRIPTLET");
            if (parameter != null) {
                this.setParameter(parameter, this.scriptlet);
            }
            parameterValues.put("REPORT_PARAMETERS_MAP", parameterValues);
            parameter = (JRFillParameter)this.parametersMap.get("REPORT_PARAMETERS_MAP");
            if (parameter != null) {
                this.setParameter(parameter, parameterValues);
            }
            this.jasperPrint.setName(this.name);
            this.jasperPrint.setPageWidth(this.pageWidth);
            this.jasperPrint.setPageHeight(this.pageHeight);
            this.jasperPrint.setOrientation(this.orientation);
            this.jasperPrint.setDefaultFont(this.defaultFont);
            if (this.fonts != null && this.fonts.length > 0) {
                for (i = 0; i < this.fonts.length; ++i) {
                    try {
                        this.jasperPrint.addFont(this.fonts[i]);
                        continue;
                    }
                    catch (JRException e) {
                        // empty catch block
                    }
                }
            }
            for (i = 0; i < this.formattedTextFields.size(); ++i) {
                ((JRFillTextField)this.formattedTextFields.get(i)).setFormat();
            }
            this.loadedSubreports = new HashMap();
            if (!this.fillContext.isPerPageBoundElements()) {
                this.reportBoundElements = new BoundElementMap();
                this.pageBoundElements = new BoundElementMap();
                this.columnBoundElements = new BoundElementMap();
                this.groupBoundElements = new HashMap();
                if (this.groups != null && this.groups.length > 0) {
                    for (i = 0; i < this.groups.length; ++i) {
                        this.groupBoundElements.put(this.groups[i].getName(), new BoundElementMap());
                    }
                }
            } else {
                this.reportBoundElements = new BoundElementMap(this.perPageBoundElements.pageToReportElements);
                this.pageBoundElements = new BoundElementMap(this.perPageBoundElements.pageToPageElements);
                this.columnBoundElements = new BoundElementMap(this.perPageBoundElements.pageToColumnElements);
                this.groupBoundElements = new HashMap();
                if (this.groups != null && this.groups.length > 0) {
                    for (i = 0; i < this.groups.length; ++i) {
                        String groupName = this.groups[i].getName();
                        HashMap map = new HashMap();
                        this.perPageBoundElements.pageToGroupElements.put(groupName, map);
                        this.groupBoundElements.put(groupName, new BoundElementMap(map));
                    }
                }
            }
            Iterator i2 = this.bands.iterator();
            while (i2.hasNext()) {
                JRFillBand band = (JRFillBand)i2.next();
                band.initBoundElementMap(this.perPageBoundElements != null);
            }
            this.reportCount = 0;
            this.fillReport();
            if (this.parentFiller != null) {
                this.parentFiller.unregisterSubfiller(this);
            }
            JasperPrint jasperPrint = this.jasperPrint;
            return jasperPrint;
        }
        finally {
            this.fillingThread = null;
        }
    }

    protected abstract void fillReport() throws JRException;

    protected ResourceBundle loadResourceBundle() {
        ResourceBundle tmpResourceBundle = null;
        if (this.resourceBundleBaseName != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    tmpResourceBundle = ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale, classLoader);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (tmpResourceBundle == null) {
                classLoader = (class$net$sf$jasperreports$engine$util$JRClassLoader == null ? (class$net$sf$jasperreports$engine$util$JRClassLoader = JRBaseFiller.class$("net.sf.jasperreports.engine.util.JRClassLoader")) : class$net$sf$jasperreports$engine$util$JRClassLoader).getClassLoader();
                tmpResourceBundle = classLoader == null ? ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale) : ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale, classLoader);
            }
        }
        return tmpResourceBundle;
    }

    protected JRAbstractScriptlet createScriptlet() throws JRException {
        JRAbstractScriptlet tmpScriptlet = null;
        if (this.scriptletClassName != null) {
            Class clazz = null;
            try {
                clazz = JRClassLoader.loadClassForName(this.scriptletClassName);
            }
            catch (ClassNotFoundException e) {
                throw new JRException("Error loading scriptlet class : " + this.scriptletClassName, e);
            }
            try {
                tmpScriptlet = (JRAbstractScriptlet)clazz.newInstance();
            }
            catch (Exception e) {
                throw new JRException("Error creating scriptlet class instance : " + this.scriptletClassName, e);
            }
        }
        if (tmpScriptlet == null) {
            tmpScriptlet = new JRDefaultScriptlet();
        }
        return tmpScriptlet;
    }

    protected void setParameters(Map parameterValues) throws JRException {
        Boolean isIgnorePaginationParam;
        if (this.isParametersAlreadySet) {
            return;
        }
        this.reportMaxCount = (Integer)parameterValues.get("REPORT_MAX_COUNT");
        this.locale = (Locale)parameterValues.get("REPORT_LOCALE");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.locale == null) {
            parameterValues.remove("REPORT_LOCALE");
        } else {
            parameterValues.put("REPORT_LOCALE", this.locale);
        }
        JRFillParameter parameter = (JRFillParameter)this.parametersMap.get("REPORT_LOCALE");
        if (parameter != null) {
            this.setParameter(parameter, this.locale);
        }
        this.resourceBundle = (ResourceBundle)parameterValues.get("REPORT_RESOURCE_BUNDLE");
        if (this.resourceBundle == null) {
            this.resourceBundle = this.loadResourceBundle();
        }
        if (this.resourceBundle == null) {
            parameterValues.remove("REPORT_RESOURCE_BUNDLE");
        } else {
            parameterValues.put("REPORT_RESOURCE_BUNDLE", this.resourceBundle);
        }
        parameter = (JRFillParameter)this.parametersMap.get("REPORT_RESOURCE_BUNDLE");
        if (parameter != null) {
            this.setParameter(parameter, this.resourceBundle);
        }
        this.virtualizer = (JRVirtualizer)parameterValues.get("REPORT_VIRTUALIZER");
        parameter = (JRFillParameter)this.parametersMap.get("REPORT_VIRTUALIZER");
        if (parameter != null) {
            this.setParameter(parameter, this.virtualizer);
        }
        if (this.virtualizer != null) {
            this.fillContext.setUsingVirtualizer(true);
            this.fillContext.setPerPageBoundElements(true);
        }
        if (this.virtualizer != null || this.fillContext.isPerPageBoundElements()) {
            this.perPageBoundElements = new BoundElements();
        }
        if ((isIgnorePaginationParam = (Boolean)parameterValues.get("IS_IGNORE_PAGINATION")) != null) {
            this.fillContext.setIgnorePagination(isIgnorePaginationParam);
        } else {
            parameterValues.put("IS_IGNORE_PAGINATION", this.fillContext.isIgnorePagination() ? Boolean.TRUE : Boolean.FALSE);
        }
        if (this.fillContext.isIgnorePagination()) {
            this.isTitleNewPage = false;
            this.isSummaryNewPage = false;
            if (this.groups != null) {
                for (int i = 0; i < this.groups.length; ++i) {
                    this.groups[i].setStartNewPage(false);
                    this.groups[i].setResetPageNumber(false);
                    this.groups[i].setStartNewColumn(false);
                }
            }
            this.setPageHeight(Integer.MAX_VALUE);
        }
        if (this.parameters != null && this.parameters.length > 0) {
            Object value = null;
            for (int i = 0; i < this.parameters.length; ++i) {
                if (parameterValues.containsKey(this.parameters[i].getName())) {
                    this.setParameter(this.parameters[i], parameterValues.get(this.parameters[i].getName()));
                    continue;
                }
                if (this.parameters[i].isSystemDefined()) continue;
                value = this.calculator.evaluate(this.parameters[i].getDefaultValueExpression(), (byte)3);
                if (value != null) {
                    parameterValues.put(this.parameters[i].getName(), value);
                }
                this.setParameter(this.parameters[i], value);
            }
        }
        this.isParametersAlreadySet = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setParameter(JRFillParameter parameter, Object value) throws JRException {
        if (value != null) {
            if (!parameter.getValueClass().isInstance(value)) throw new JRException("Incompatible value assigned to parameter " + parameter.getName() + " : " + this.name);
            parameter.setValue(value);
            return;
        } else {
            parameter.setValue(value);
        }
    }

    protected boolean next() throws JRException {
        boolean hasNext = false;
        if (this.dataSource != null) {
            boolean bl = hasNext = (this.reportMaxCount == null || this.reportMaxCount > this.reportCount++) && this.dataSource.next();
            if (hasNext) {
                int i;
                if (this.fields != null && this.fields.length > 0) {
                    JRFillField field = null;
                    for (i = 0; i < this.fields.length; ++i) {
                        field = this.fields[i];
                        field.setOldValue(field.getValue());
                        field.setValue(this.dataSource.getFieldValue(field));
                    }
                }
                if (this.variables != null && this.variables.length > 0) {
                    JRFillVariable variable = null;
                    for (i = 0; i < this.variables.length; ++i) {
                        variable = this.variables[i];
                        variable.setOldValue(variable.getValue());
                    }
                }
            }
        }
        return hasNext;
    }

    private void resolveBoundElements(Collection elements, Map boundElements, byte evaluation) throws JRException {
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                JRPrintElement element = (JRPrintElement)it.next();
                JRFillElement fillElement = (JRFillElement)boundElements.get(element);
                fillElement.resolveElement(element, evaluation);
            }
        }
    }

    private void resolvePerPageBoundElements(Map perPageElements, Map boundElements, byte evaluation) throws JRException {
        if (perPageElements != null) {
            Iterator it = perPageElements.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                JRPrintPage page = (JRPrintPage)entry.getKey();
                page.getElements();
                this.resolveBoundElements(((Map)entry.getValue()).values(), boundElements, evaluation);
            }
        }
        boundElements.clear();
    }

    private void resolveBoundElements(Map boundElements, byte evaluation) throws JRException {
        this.resolveBoundElements(boundElements.keySet(), boundElements, evaluation);
        boundElements.clear();
    }

    protected void resolveReportBoundElements() throws JRException {
        if (this.fillContext.isPerPageBoundElements()) {
            this.resolvePerPageBoundElements(this.perPageBoundElements.pageToReportElements, this.reportBoundElements, (byte)3);
        } else {
            this.resolveBoundElements(this.reportBoundElements, (byte)3);
        }
    }

    protected void resolvePageBoundElements(byte evaluation) throws JRException {
        if (this.fillContext.isPerPageBoundElements()) {
            this.resolvePerPageBoundElements(this.perPageBoundElements.pageToPageElements, this.pageBoundElements, evaluation);
        } else {
            this.resolveBoundElements(this.pageBoundElements, evaluation);
        }
    }

    protected void resolveColumnBoundElements(byte evaluation) throws JRException {
        if (this.fillContext.isPerPageBoundElements()) {
            this.resolvePerPageBoundElements(this.perPageBoundElements.pageToColumnElements, this.columnBoundElements, evaluation);
        } else {
            this.resolveBoundElements(this.columnBoundElements, evaluation);
        }
    }

    protected void resolveGroupBoundElements(byte evaluation, boolean isFinal) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                if ((!group.hasChanged() || !group.isFooterPrinted()) && !isFinal) continue;
                String groupName = group.getName();
                Map specificGroupBoundTexts = (Map)this.groupBoundElements.get(groupName);
                if (this.fillContext.isPerPageBoundElements()) {
                    this.resolvePerPageBoundElements((Map)this.perPageBoundElements.pageToGroupElements.get(groupName), specificGroupBoundTexts, evaluation);
                    continue;
                }
                this.resolveBoundElements(specificGroupBoundTexts, evaluation);
            }
        }
    }

    protected JRPrintPage newPage() {
        JRBasePrintPage page;
        if (this.virtualizer != null) {
            JRVirtualPrintPage virtualPage = new JRVirtualPrintPage(this.jasperPrint, this.virtualizer);
            JRBaseFiller.addIdentityDataProviders(virtualPage, this);
            page = virtualPage;
        } else {
            page = new JRBasePrintPage();
        }
        return page;
    }

    protected Object getVariableValue(String variableName) throws JRException {
        JRFillVariable var = (JRFillVariable)this.variablesMap.get(variableName);
        if (var == null) {
            throw new JRException("No such variable " + variableName);
        }
        return var.getValue();
    }

    protected void resolveBandBoundElements(JRFillBand band, byte evaluation) throws JRException {
        if (this.fillContext.isPerPageBoundElements()) {
            this.resolvePerPageBoundElements(band.pageToBoundElements, band.boundElements, evaluation);
        } else {
            this.resolveBoundElements(band.boundElements, evaluation);
        }
    }

    protected static JRVirtualPrintPage.ObjectIDPair[] createIdentityData(Set allElements) {
        JRVirtualPrintPage.ObjectIDPair[] ids;
        if (!allElements.isEmpty()) {
            ids = new JRVirtualPrintPage.ObjectIDPair[allElements.size()];
            int i = 0;
            Iterator it = allElements.iterator();
            while (it.hasNext()) {
                ids[i] = new JRVirtualPrintPage.ObjectIDPair(it.next());
                ++i;
            }
        } else {
            ids = null;
        }
        return ids;
    }

    protected static void addElements(Set allElements, Map pageMap, JRVirtualPrintPage page) {
        Map map = (Map)pageMap.get(page);
        if (map != null && !map.isEmpty()) {
            Collection elements = map.values();
            allElements.addAll(elements);
        }
    }

    protected static void addGroupElements(Set allElements, Map groupMap, JRVirtualPrintPage page) {
        Iterator it = groupMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            JRBaseFiller.addElements(allElements, (Map)entry.getValue(), page);
        }
    }

    protected static void updateIdentityData(Map pageMap, JRVirtualPrintPage page, BoundElementMap boundElements, JRVirtualPrintPage.ObjectIDPair[] identityData) {
        Map pageElements = (Map)pageMap.get(page);
        if (pageElements != null && pageElements.size() > 0) {
            for (int i = 0; i < identityData.length; ++i) {
                Object resolver;
                Object oldObject = pageElements.remove(new Integer(identityData[i].getIdentity()));
                if (oldObject == null || (resolver = boundElements.remove(oldObject)) == null) continue;
                boundElements.put(identityData[i].getObject(), resolver, page);
            }
        }
    }

    protected static void updateGroupIdentityData(Map pageGroupMap, JRVirtualPrintPage page, Map groupMap, JRVirtualPrintPage.ObjectIDPair[] identityData) {
        Iterator it = pageGroupMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            JRBaseFiller.updateIdentityData((Map)entry.getValue(), page, (BoundElementMap)groupMap.get(entry.getKey()), identityData);
        }
    }

    private JRFillVariable addVariable(JRVariable parentVariable, List variableList, JRFillObjectFactory factory) {
        JRFillVariable variable = factory.getVariable(parentVariable);
        byte calculation = variable.getCalculation();
        switch (calculation) {
            case 3: 
            case 7: {
                JRVariable countVar = this.createHelperVariable(parentVariable, "_COUNT", (byte)1);
                JRFillVariable fillCountVar = this.addVariable(countVar, variableList, factory);
                variable.setHelperVariable(fillCountVar, (byte)0);
                JRVariable sumVar = this.createHelperVariable(parentVariable, "_SUM", (byte)2);
                JRFillVariable fillSumVar = this.addVariable(sumVar, variableList, factory);
                variable.setHelperVariable(fillSumVar, (byte)1);
                break;
            }
            case 6: {
                JRVariable varianceVar = this.createHelperVariable(parentVariable, "_VARIANCE", (byte)7);
                JRFillVariable fillVarianceVar = this.addVariable(varianceVar, variableList, factory);
                variable.setHelperVariable(fillVarianceVar, (byte)2);
                break;
            }
        }
        variableList.add(variable);
        return variable;
    }

    private void setVariables(List variableList) {
        this.variables = new JRFillVariable[variableList.size()];
        this.variables = variableList.toArray(this.variables);
        for (int i = 0; i < this.variables.length; ++i) {
            this.variablesMap.put(this.variables[i].getName(), this.variables[i]);
        }
    }

    private JRVariable createHelperVariable(JRVariable variable, String nameSuffix, byte calculation) {
        JRDesignVariable helper = new JRDesignVariable();
        helper.setName(variable.getName() + nameSuffix);
        helper.setValueClassName(variable.getValueClassName());
        helper.setIncrementerFactoryClassName(variable.getIncrementerFactoryClassName());
        helper.setResetType(variable.getResetType());
        helper.setResetGroup(variable.getResetGroup());
        helper.setIncrementType(variable.getIncrementType());
        helper.setIncrementGroup(variable.getIncrementGroup());
        helper.setCalculation(calculation);
        helper.setSystemDefined(true);
        helper.setExpression(variable.getExpression());
        return helper;
    }

    protected void addVariableCalculationReq(String variableName, byte calculation) {
        if (this.variableCalculationReqs == null) {
            this.variableCalculationReqs = new HashSet();
        }
        this.variableCalculationReqs.add(new VariableCalculationReq(variableName, calculation));
    }

    private void checkVariableCalculationReqs(JRFillObjectFactory factory) {
        if (this.variableCalculationReqs != null && !this.variableCalculationReqs.isEmpty()) {
            ArrayList variableList = new ArrayList(this.variables.length * 2);
            for (int i = 0; i < this.variables.length; ++i) {
                JRFillVariable variable = this.variables[i];
                this.checkVariableCalculationReq(variable, variableList, factory);
            }
            this.setVariables(variableList);
        }
    }

    private void checkVariableCalculationReq(JRFillVariable variable, List variableList, JRFillObjectFactory factory) {
        if (this.hasVariableCalculationReq(variable, (byte)3) || this.hasVariableCalculationReq(variable, (byte)7)) {
            if (variable.getHelperVariable((byte)0) == null) {
                JRVariable countVar = this.createHelperVariable(variable, "_COUNT", (byte)1);
                JRFillVariable fillCountVar = factory.getVariable(countVar);
                this.checkVariableCalculationReq(fillCountVar, variableList, factory);
                variable.setHelperVariable(fillCountVar, (byte)0);
            }
            if (variable.getHelperVariable((byte)1) == null) {
                JRVariable sumVar = this.createHelperVariable(variable, "_SUM", (byte)2);
                JRFillVariable fillSumVar = factory.getVariable(sumVar);
                this.checkVariableCalculationReq(fillSumVar, variableList, factory);
                variable.setHelperVariable(fillSumVar, (byte)1);
            }
        }
        if (this.hasVariableCalculationReq(variable, (byte)6) && variable.getHelperVariable((byte)2) == null) {
            JRVariable varianceVar = this.createHelperVariable(variable, "_VARIANCE", (byte)7);
            JRFillVariable fillVarianceVar = factory.getVariable(varianceVar);
            this.checkVariableCalculationReq(fillVarianceVar, variableList, factory);
            variable.setHelperVariable(fillVarianceVar, (byte)2);
        }
        variableList.add(variable);
    }

    private boolean hasVariableCalculationReq(JRVariable var, byte calculation) {
        return this.variableCalculationReqs.contains(new VariableCalculationReq(var.getName(), calculation));
    }

    public void cancelFill() throws JRException {
        PreparedStatement s = this.dataSourceStatement;
        if (s != null) {
            try {
                s.cancel();
            }
            catch (Throwable t) {
                throw new JRException("Error cancelling SQL statement", t);
            }
        } else {
            Thread t = this.fillingThread;
            if (t != null) {
                t.interrupt();
            }
        }
    }

    protected void registerSubfiller(JRBaseFiller subfiller) {
        if (this.subfillers == null) {
            this.subfillers = new HashSet();
        }
        if (this.subfillers.add(subfiller) && this.fillContext.isUsingVirtualizer()) {
            subfiller.identityPages = new ArrayList();
            JRVirtualPrintPage masterPrintPage = (JRVirtualPrintPage)this.fillContext.getPrintPage();
            subfiller.identityPages.add(masterPrintPage);
            JRBaseFiller.addIdentityDataProviders(masterPrintPage, subfiller);
        }
    }

    protected void unregisterSubfiller(JRBaseFiller subfiller) {
        if (this.subfillers.remove(subfiller) && this.fillContext.isUsingVirtualizer()) {
            this.removeIdentityDataProviders(subfiller);
        }
    }

    private static void addIdentityDataProviders(JRVirtualPrintPage page, JRBaseFiller filler) {
        page.addIdentityDataProvider(filler.perPageBoundElements);
        Iterator i = filler.bands.iterator();
        while (i.hasNext()) {
            JRFillBand band = (JRFillBand)i.next();
            page.addIdentityDataProvider(band);
        }
        if (filler.subfillers != null) {
            i = filler.subfillers.iterator();
            while (i.hasNext()) {
                JRBaseFiller subfiller = (JRBaseFiller)i.next();
                subfiller.identityPages.add(page);
                JRBaseFiller.addIdentityDataProviders(page, subfiller);
            }
        }
    }

    private void removeIdentityDataProviders(JRBaseFiller filler) {
        if (filler.identityPages != null) {
            Iterator it = filler.identityPages.iterator();
            while (it.hasNext()) {
                JRVirtualPrintPage page = (JRVirtualPrintPage)it.next();
                page.removeIdentityDataProvider(filler.perPageBoundElements);
                Iterator i = filler.bands.iterator();
                while (i.hasNext()) {
                    JRFillBand band = (JRFillBand)i.next();
                    page.removeIdentityDataProvider(band);
                }
            }
            filler.identityPages = null;
        }
    }

    protected void addPage(JRPrintPage page) {
        if (!this.isSubreport()) {
            this.jasperPrint.addPage(page);
            this.fillContext.setPrintPage(page);
        }
    }

    protected void addPageIdentityDataProvider() {
        JRVirtualPrintPage.IdentityDataProvider pageProvider = PageIdentityDataProvider.getIdentityDataProvider((JRBasePrintPage)this.printPage);
        ((JRVirtualPrintPage)this.fillContext.getPrintPage()).addIdentityDataProvider(pageProvider);
    }

    protected void removePageIdentityDataProvider() {
        JRVirtualPrintPage.IdentityDataProvider pageProvider = PageIdentityDataProvider.removeIdentityDataProvider((JRBasePrintPage)this.printPage);
        if (pageProvider != null) {
            ((JRVirtualPrintPage)this.fillContext.getPrintPage()).removeIdentityDataProvider(pageProvider);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static final class PageIdentityDataProvider
    implements JRVirtualPrintPage.IdentityDataProvider {
        private static final Map providers = new HashMap();
        private final JRBasePrintPage printPage;

        protected PageIdentityDataProvider(JRBasePrintPage printPage) {
            this.printPage = printPage;
        }

        public JRVirtualPrintPage.ObjectIDPair[] getIdentityData(JRVirtualPrintPage page) {
            return null;
        }

        public void setIdentityData(JRVirtualPrintPage page, JRVirtualPrintPage.ObjectIDPair[] identityData) {
            if (identityData != null && identityData.length > 0) {
                HashMap<Integer, Object> idMap = new HashMap<Integer, Object>();
                for (int i = 0; i < identityData.length; ++i) {
                    idMap.put(new Integer(identityData[i].getIdentity()), identityData[i].getObject());
                }
                ListIterator i = this.printPage.getElements().listIterator();
                while (i.hasNext()) {
                    Object element = i.next();
                    Integer id = new Integer(System.identityHashCode(element));
                    Object idObject = idMap.get(id);
                    if (idObject == null) continue;
                    i.set(idObject);
                }
            }
        }

        public static JRVirtualPrintPage.IdentityDataProvider getIdentityDataProvider(JRBasePrintPage printPage) {
            JRVirtualPrintPage.IdentityDataProvider provider = (JRVirtualPrintPage.IdentityDataProvider)providers.get(printPage);
            if (provider == null) {
                provider = new PageIdentityDataProvider(printPage);
                providers.put(printPage, provider);
            }
            return provider;
        }

        public static JRVirtualPrintPage.IdentityDataProvider removeIdentityDataProvider(JRBasePrintPage printPage) {
            JRVirtualPrintPage.IdentityDataProvider provider = (JRVirtualPrintPage.IdentityDataProvider)providers.remove(printPage);
            return provider;
        }
    }

    private static class VariableCalculationReq {
        String variableName;
        byte calculation;

        VariableCalculationReq(String variableName, byte calculation) {
            this.variableName = variableName;
            this.calculation = calculation;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof VariableCalculationReq)) {
                return false;
            }
            VariableCalculationReq r = (VariableCalculationReq)o;
            return this.variableName.equals(r.variableName) && this.calculation == r.calculation;
        }

        public int hashCode() {
            return 31 * this.calculation + this.variableName.hashCode();
        }
    }

    private class BoundElements
    implements JRVirtualPrintPage.IdentityDataProvider {
        HashMap pageToReportElements = new HashMap();
        HashMap pageToPageElements = new HashMap();
        HashMap pageToColumnElements = new HashMap();
        HashMap pageToBandElements = new HashMap();
        HashMap pageToGroupElements = new HashMap();

        BoundElements() {
        }

        public JRVirtualPrintPage.ObjectIDPair[] getIdentityData(JRVirtualPrintPage page) {
            HashSet allElements = new HashSet();
            JRBaseFiller.addElements(allElements, this.pageToReportElements, page);
            JRBaseFiller.addElements(allElements, this.pageToPageElements, page);
            JRBaseFiller.addElements(allElements, this.pageToColumnElements, page);
            JRBaseFiller.addElements(allElements, this.pageToBandElements, page);
            JRBaseFiller.addGroupElements(allElements, this.pageToGroupElements, page);
            return JRBaseFiller.createIdentityData(allElements);
        }

        public void setIdentityData(JRVirtualPrintPage page, JRVirtualPrintPage.ObjectIDPair[] identityData) {
            JRBaseFiller.updateIdentityData(this.pageToReportElements, page, JRBaseFiller.this.reportBoundElements, identityData);
            JRBaseFiller.updateIdentityData(this.pageToPageElements, page, JRBaseFiller.this.pageBoundElements, identityData);
            JRBaseFiller.updateIdentityData(this.pageToColumnElements, page, JRBaseFiller.this.columnBoundElements, identityData);
            JRBaseFiller.updateGroupIdentityData(this.pageToGroupElements, page, JRBaseFiller.this.groupBoundElements, identityData);
        }
    }

    public class BoundElementMap
    extends HashMap {
        private static final long serialVersionUID = 10002L;
        private final Map perPageElements;

        BoundElementMap() {
            this.perPageElements = null;
        }

        BoundElementMap(Map perPageElements) {
            this.perPageElements = perPageElements;
        }

        public Object put(Object key, Object value, JRPrintPage keyPage) {
            if (this.perPageElements != null) {
                HashMap<Integer, Object> map = (HashMap<Integer, Object>)this.perPageElements.get(keyPage);
                if (map == null) {
                    map = new HashMap<Integer, Object>();
                    this.perPageElements.put(keyPage, map);
                }
                map.put(new Integer(System.identityHashCode(key)), key);
            }
            return super.put(key, value);
        }

        public Object put(Object key, Object value) {
            if (this.perPageElements != null) {
                return this.put(key, value, JRBaseFiller.this.fillContext.getPrintPage());
            }
            return super.put(key, value);
        }

        public void clear() {
            super.clear();
            if (this.perPageElements != null) {
                this.perPageElements.clear();
            }
        }
    }
}

