/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRPrintBand;

public class JRVerticalFiller
extends JRBaseFiller {
    private boolean isCreatingNewPage = false;
    private boolean isNewPage = false;
    private boolean isNewColumn = false;
    private boolean isNewGroup = true;
    private int columnIndex = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private int columnHeaderOffsetY = 0;
    private int columnFooterOffsetY = 0;
    private int lastPageColumnFooterOffsetY = 0;
    private boolean isLastPageFooter = false;

    protected JRVerticalFiller(JasperReport jasperReport) throws JRException {
        this(jasperReport, null, null);
    }

    protected JRVerticalFiller(JasperReport jasperReport, JRBaseFiller parentFiller) throws JRException {
        super(jasperReport, null, parentFiller);
        this.setPageHeight(this.pageHeight);
    }

    protected JRVerticalFiller(JasperReport jasperReport, JRCalculator calculator, JRBaseFiller parentFiller) throws JRException {
        super(jasperReport, calculator, parentFiller);
        this.setPageHeight(this.pageHeight);
    }

    protected void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
        this.columnFooterOffsetY = pageHeight - this.bottomMargin;
        if (this.pageFooter != null) {
            this.columnFooterOffsetY -= this.pageFooter.getHeight();
        }
        if (this.columnFooter != null) {
            this.columnFooterOffsetY -= this.columnFooter.getHeight();
        }
        this.lastPageColumnFooterOffsetY = pageHeight - this.bottomMargin;
        if (this.lastPageFooter != null) {
            this.lastPageColumnFooterOffsetY -= this.lastPageFooter.getHeight();
        }
        if (this.columnFooter != null) {
            this.lastPageColumnFooterOffsetY -= this.columnFooter.getHeight();
        }
    }

    protected synchronized void fillReport() throws JRException {
        this.setLastPageFooter(false);
        if (this.next()) {
            this.fillReportStart();
            while (this.next()) {
                this.fillReportContent();
            }
            this.fillReportEnd();
        } else {
            switch (this.whenNoDataType) {
                case 3: {
                    this.scriptlet.callBeforeReportInit();
                    this.calculator.initializeVariables((byte)1);
                    this.scriptlet.callAfterReportInit();
                    this.printPage = new JRBasePrintPage();
                    this.addPage(this.printPage);
                    this.columnIndex = 0;
                    this.offsetX = this.leftMargin;
                    this.offsetY = this.topMargin;
                    this.fillBackground();
                    this.fillTitle();
                    this.fillPageHeader((byte)3);
                    this.fillColumnHeader((byte)3);
                    this.fillGroupHeaders(true);
                    this.fillGroupFooters(true);
                    this.fillSummary();
                    break;
                }
                case 2: {
                    this.printPage = new JRBasePrintPage();
                    this.addPage(this.printPage);
                    break;
                }
            }
        }
        if (this.isSubreport()) {
            this.printPageStretchHeight = this.offsetY + this.bottomMargin;
            if (this.fillContext.isUsingVirtualizer()) {
                this.removePageIdentityDataProvider();
            }
        }
        if (this.fillContext.isIgnorePagination()) {
            this.jasperPrint.setPageHeight(this.offsetY + this.bottomMargin);
        }
    }

    private void fillReportStart() throws JRException {
        this.scriptlet.callBeforeReportInit();
        this.calculator.initializeVariables((byte)1);
        this.scriptlet.callAfterReportInit();
        this.printPage = this.newPage();
        this.addPage(this.printPage);
        this.columnIndex = 0;
        this.offsetX = this.leftMargin;
        this.offsetY = this.topMargin;
        this.fillBackground();
        this.fillTitle();
        this.fillPageHeader((byte)3);
        this.fillColumnHeader((byte)3);
        this.fillGroupHeaders(true);
        this.fillDetail();
    }

    private void fillReportContent() throws JRException {
        this.calculator.estimateGroupRuptures();
        this.fillGroupFooters(false);
        this.resolveGroupBoundElements((byte)1, false);
        this.scriptlet.callBeforeGroupInit();
        this.calculator.initializeVariables((byte)4);
        this.scriptlet.callAfterGroupInit();
        this.fillGroupHeaders(false);
        this.fillDetail();
    }

    private void fillReportEnd() throws JRException {
        this.fillGroupFooters(true);
        this.fillSummary();
    }

    private void fillTitle() throws JRException {
        this.title.evaluatePrintWhenExpression((byte)3);
        if (this.title.isToPrint()) {
            while (this.title.getHeight() > this.pageHeight - this.bottomMargin - this.offsetY) {
                this.addPage(false);
            }
            this.title.evaluate((byte)3);
            JRPrintBand printBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
            if (this.title.willOverflow() && !this.title.isSplitAllowed() && this.isSubreport()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.title.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
            }
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            while (this.title.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            }
            this.resolveBandBoundElements(this.title, (byte)3);
            if (this.isTitleNewPage) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
            }
        }
    }

    private void fillPageHeader(byte evaluation) throws JRException {
        this.setNewPageColumnInBands();
        this.pageHeader.evaluatePrintWhenExpression((byte)3);
        if (this.pageHeader.isToPrint()) {
            while (this.pageHeader.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                this.resolveGroupBoundElements(evaluation, false);
                this.resolveColumnBoundElements(evaluation);
                this.resolvePageBoundElements(evaluation);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
            }
            this.fillPageBand(this.pageHeader, evaluation);
        }
        this.columnHeaderOffsetY = this.offsetY;
        this.isNewPage = true;
    }

    private void fillColumnHeader(byte evaluation) throws JRException {
        this.setNewPageColumnInBands();
        this.columnHeader.evaluatePrintWhenExpression(evaluation);
        if (this.columnHeader.isToPrint()) {
            while (this.columnHeader.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                if (this.columnIndex == this.columnCount - 1) {
                    this.fillPageFooter(evaluation);
                    this.resolveGroupBoundElements(evaluation, false);
                    this.resolveColumnBoundElements(evaluation);
                    this.resolvePageBoundElements(evaluation);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    this.fillPageHeader(evaluation);
                    continue;
                }
                this.resolveGroupBoundElements(evaluation, false);
                this.resolveColumnBoundElements(evaluation);
                this.scriptlet.callBeforeColumnInit();
                this.calculator.initializeVariables((byte)3);
                this.scriptlet.callAfterColumnInit();
                ++this.columnIndex;
                this.offsetX = this.leftMargin + this.columnIndex * (this.columnSpacing + this.columnWidth);
                this.offsetY = this.columnHeaderOffsetY;
                this.calculator.getColumnNumber().setValue(new Integer(((Number)this.calculator.getColumnNumber().getValue()).intValue() + 1));
                this.calculator.getColumnNumber().setOldValue(this.calculator.getColumnNumber().getValue());
            }
            this.fillColumnBand(this.columnHeader, evaluation);
        }
        this.isNewColumn = true;
    }

    private void fillGroupHeaders(boolean isFillAll) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                if (isFillAll) {
                    this.fillGroupHeader(this.groups[i]);
                    continue;
                }
                if (!this.groups[i].hasChanged()) continue;
                this.fillGroupHeader(this.groups[i]);
            }
        }
    }

    private void fillGroupHeader(JRFillGroup group) throws JRException {
        byte evalPrevPage;
        byte by = evalPrevPage = group.isTopLevelChange() ? (byte)1 : 3;
        if ((group.isStartNewPage() || group.isResetPageNumber()) && !this.isNewPage) {
            this.fillPageBreak(group.isResetPageNumber(), evalPrevPage, (byte)3, true);
        } else if (group.isStartNewColumn() && !this.isNewColumn) {
            this.fillColumnBreak(evalPrevPage, (byte)3);
        }
        JRFillBand groupHeader = (JRFillBand)group.getGroupHeader();
        groupHeader.evaluatePrintWhenExpression((byte)3);
        if (groupHeader.isToPrint()) {
            while (groupHeader.getHeight() > this.columnFooterOffsetY - this.offsetY || group.getMinHeightToStartNewPage() > this.columnFooterOffsetY - this.offsetY) {
                this.fillColumnBreak(evalPrevPage, (byte)3);
            }
        }
        this.setNewGroupInBands(group);
        group.setFooterPrinted(false);
        if (groupHeader.isToPrint()) {
            this.fillColumnBand(groupHeader, (byte)3);
        }
        this.isNewGroup = true;
    }

    private void fillGroupHeadersReprint(byte evaluation) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.fillGroupHeaderReprint(this.groups[i], evaluation);
            }
        }
    }

    private void fillGroupHeaderReprint(JRFillGroup group, byte evaluation) throws JRException {
        if (group.isReprintHeaderOnEachPage() && (!group.hasChanged() || group.hasChanged() && !group.isFooterPrinted())) {
            JRFillBand groupHeader = (JRFillBand)group.getGroupHeader();
            groupHeader.evaluatePrintWhenExpression(evaluation);
            if (groupHeader.isToPrint()) {
                while (groupHeader.getHeight() > this.columnFooterOffsetY - this.offsetY || group.getMinHeightToStartNewPage() > this.columnFooterOffsetY - this.offsetY) {
                    this.fillColumnBreak(evaluation, evaluation);
                }
                this.fillColumnBand(groupHeader, evaluation);
            }
        }
    }

    private void fillDetail() throws JRException {
        if (!this.detail.isPrintWhenExpressionNull()) {
            this.calculator.estimateVariables();
            this.detail.evaluatePrintWhenExpression((byte)2);
        }
        if (this.detail.isToPrint()) {
            while (this.detail.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                byte evalPrevPage = this.isNewGroup ? (byte)3 : 1;
                this.fillColumnBreak(evalPrevPage, (byte)3);
            }
        }
        this.scriptlet.callBeforeDetailEval();
        this.calculator.calculateVariables();
        this.scriptlet.callAfterDetailEval();
        if (!this.detail.isPrintWhenExpressionNull()) {
            this.detail.evaluatePrintWhenExpression((byte)3);
        }
        if (this.detail.isToPrint()) {
            this.fillColumnBand(this.detail, (byte)3);
        }
        this.isNewPage = false;
        this.isNewColumn = false;
        this.isNewGroup = false;
    }

    private void fillGroupFooters(boolean isFillAll) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            byte evaluation = isFillAll ? (byte)3 : 1;
            for (int i = this.groups.length - 1; i >= 0; --i) {
                if (isFillAll) {
                    this.fillGroupFooter(this.groups[i], evaluation);
                    continue;
                }
                if (!this.groups[i].hasChanged()) continue;
                this.fillGroupFooter(this.groups[i], evaluation);
            }
        }
    }

    private void fillGroupFooter(JRFillGroup group, byte evaluation) throws JRException {
        JRFillBand groupFooter = (JRFillBand)group.getGroupFooter();
        groupFooter.evaluatePrintWhenExpression(evaluation);
        if (groupFooter.isToPrint()) {
            if (groupFooter.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                this.fillColumnBreak(evaluation, evaluation);
            }
            this.fillColumnBand(groupFooter, evaluation);
        }
        this.isNewPage = false;
        this.isNewColumn = false;
        group.setFooterPrinted(true);
    }

    private void fillColumnFooter(byte evaluation) throws JRException {
        if (this.isSubreport() && this.columnIndex == 0) {
            this.columnFooterOffsetY = this.offsetY;
        }
        int oldOffsetY = this.offsetY;
        if (!this.isFloatColumnFooter && !this.fillContext.isIgnorePagination()) {
            this.offsetY = this.columnFooterOffsetY;
        }
        this.columnFooter.evaluatePrintWhenExpression(evaluation);
        if (this.columnFooter.isToPrint()) {
            this.fillFixedBand(this.columnFooter, evaluation);
        }
        if (this.isFloatColumnFooter && !this.fillContext.isIgnorePagination()) {
            this.offsetY += this.columnFooterOffsetY - oldOffsetY;
        }
    }

    private void fillPageFooter(byte evaluation) throws JRException {
        JRFillBand crtPageFooter = this.getCurrentPageFooter();
        this.offsetX = this.leftMargin;
        if (!this.isSubreport() && !this.fillContext.isIgnorePagination()) {
            this.offsetY = this.pageHeight - crtPageFooter.getHeight() - this.bottomMargin;
        }
        crtPageFooter.evaluatePrintWhenExpression(evaluation);
        if (crtPageFooter.isToPrint()) {
            this.fillFixedBand(crtPageFooter, evaluation);
        }
    }

    private void fillSummary() throws JRException {
        if (this.lastPageFooter == this.missingFillBand) {
            if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getHeight() <= this.columnFooterOffsetY - this.offsetY) {
                this.fillSummarySamePage();
            } else {
                this.fillSummaryNewPage();
            }
        } else if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getHeight() <= this.lastPageColumnFooterOffsetY - this.offsetY) {
            this.setLastPageFooter(true);
            this.fillSummarySamePage();
        } else if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getHeight() <= this.columnFooterOffsetY - this.offsetY) {
            this.fillSummarySamePageMixedFooters();
        } else if (this.columnIndex == 0 && this.offsetY <= this.lastPageColumnFooterOffsetY) {
            this.setLastPageFooter(true);
            this.fillSummaryNewPage();
        } else {
            this.fillPageBreak(false, (byte)3, (byte)3, false);
            this.setLastPageFooter(true);
            if (this.isSummaryNewPage) {
                this.fillSummaryNewPage();
            } else {
                this.fillSummarySamePage();
            }
        }
        this.resolveGroupBoundElements((byte)3, true);
        this.resolveColumnBoundElements((byte)3);
        this.resolvePageBoundElements((byte)3);
        this.resolveReportBoundElements();
    }

    private void fillSummarySamePage() throws JRException {
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.summary.evaluate((byte)3);
            JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed()) {
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            } else {
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
            }
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        } else {
            this.fillColumnFooter((byte)3);
            this.fillPageFooter((byte)3);
        }
    }

    private void fillSummarySamePageMixedFooters() throws JRException {
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.summary.evaluate((byte)3);
            JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed()) {
                if (this.offsetY <= this.lastPageColumnFooterOffsetY) {
                    this.setLastPageFooter(true);
                    this.fillColumnFooter((byte)3);
                    this.fillPageFooter((byte)3);
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                } else {
                    this.fillPageBreak(false, (byte)3, (byte)3, false);
                    this.setLastPageFooter(true);
                    printBand = this.summary.refill(this.lastPageColumnFooterOffsetY - this.offsetY - this.summary.getHeight());
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.fillColumnFooter((byte)3);
                    this.fillPageFooter((byte)3);
                }
            } else {
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.fillPageBreak(false, (byte)3, (byte)3, false);
                this.setLastPageFooter(true);
                if (this.summary.willOverflow()) {
                    printBand = this.summary.fill(this.lastPageColumnFooterOffsetY - this.offsetY - this.summary.getHeight());
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                }
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
            }
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        } else {
            if (this.offsetY > this.lastPageColumnFooterOffsetY) {
                this.fillPageBreak(false, (byte)3, (byte)3, false);
            }
            this.setLastPageFooter(true);
            this.fillColumnFooter((byte)3);
            this.fillPageFooter((byte)3);
        }
    }

    private void fillSummaryNewPage() throws JRException {
        this.fillColumnFooter((byte)3);
        this.fillPageFooter((byte)3);
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.resolveGroupBoundElements((byte)3, true);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables((byte)2);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            this.columnIndex = -1;
            this.summary.evaluate((byte)3);
            JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed() && this.isSubreport()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
            }
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        }
    }

    private void fillBackground() throws JRException {
        if (this.background.getHeight() <= this.pageHeight - this.bottomMargin - this.offsetY) {
            this.background.evaluatePrintWhenExpression((byte)3);
            if (this.background.isToPrint()) {
                this.background.evaluate((byte)3);
                JRPrintBand printBand = this.background.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.background.getHeight());
                this.fillBand(printBand);
            }
        }
    }

    private void addPage(boolean isResetPageNumber) throws JRException {
        if (this.isSubreport()) {
            this.printPageStretchHeight = this.offsetY + this.bottomMargin;
            if (this.fillContext.isUsingVirtualizer()) {
                this.removePageIdentityDataProvider();
            }
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new JRException("Error encountered while waiting on the subreport filling thread.", e);
            }
        }
        this.printPage = this.newPage();
        if (this.isSubreport() && this.fillContext.isUsingVirtualizer()) {
            this.addPageIdentityDataProvider();
        }
        if (isResetPageNumber) {
            this.calculator.getPageNumber().setValue(new Integer(1));
        } else {
            this.calculator.getPageNumber().setValue(new Integer(((Number)this.calculator.getPageNumber().getValue()).intValue() + 1));
        }
        this.calculator.getPageNumber().setOldValue(this.calculator.getPageNumber().getValue());
        this.addPage(this.printPage);
        this.columnIndex = 0;
        this.offsetX = this.leftMargin;
        this.offsetY = this.topMargin;
        this.calculator.getColumnNumber().setValue(new Integer(((Number)this.calculator.getColumnNumber().getValue()).intValue() + 1));
        this.calculator.getColumnNumber().setOldValue(this.calculator.getColumnNumber().getValue());
        this.fillBackground();
    }

    private void fillPageBreak(boolean isResetPageNumber, byte evalPrevPage, byte evalNextPage, boolean isReprintGroupHeaders) throws JRException {
        if (this.isCreatingNewPage) {
            throw new JRException("Infinite loop creating new page.");
        }
        this.isCreatingNewPage = true;
        this.fillColumnFooter(evalPrevPage);
        this.fillPageFooter(evalPrevPage);
        this.resolveGroupBoundElements(evalPrevPage, false);
        this.resolveColumnBoundElements(evalPrevPage);
        this.resolvePageBoundElements(evalPrevPage);
        this.scriptlet.callBeforePageInit();
        this.calculator.initializeVariables((byte)2);
        this.scriptlet.callAfterPageInit();
        this.addPage(isResetPageNumber);
        this.fillPageHeader(evalNextPage);
        this.fillColumnHeader(evalNextPage);
        if (isReprintGroupHeaders) {
            this.fillGroupHeadersReprint(evalNextPage);
        }
        this.isCreatingNewPage = false;
    }

    private void fillColumnBreak(byte evalPrevPage, byte evalNextPage) throws JRException {
        if (this.columnIndex == this.columnCount - 1) {
            this.fillPageBreak(false, evalPrevPage, evalNextPage, true);
        } else {
            this.fillColumnFooter(evalPrevPage);
            this.resolveGroupBoundElements(evalPrevPage, false);
            this.resolveColumnBoundElements(evalPrevPage);
            this.scriptlet.callBeforeColumnInit();
            this.calculator.initializeVariables((byte)3);
            this.scriptlet.callAfterColumnInit();
            ++this.columnIndex;
            this.offsetX = this.leftMargin + this.columnIndex * (this.columnSpacing + this.columnWidth);
            this.offsetY = this.columnHeaderOffsetY;
            this.calculator.getColumnNumber().setValue(new Integer(((Number)this.calculator.getColumnNumber().getValue()).intValue() + 1));
            this.calculator.getColumnNumber().setOldValue(this.calculator.getColumnNumber().getValue());
            this.fillColumnHeader(evalNextPage);
        }
    }

    protected void fillPageBand(JRFillBand band, byte evaluation) throws JRException {
        band.evaluate(evaluation);
        JRPrintBand printBand = band.fill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
        if (band.willOverflow() && !band.isSplitAllowed()) {
            this.fillPageBreak(false, evaluation, evaluation, true);
            printBand = band.refill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
        }
        this.fillBand(printBand);
        this.offsetY += printBand.getHeight();
        while (band.willOverflow()) {
            this.fillPageBreak(false, evaluation, evaluation, true);
            printBand = band.fill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
        }
        this.resolveBandBoundElements(band, evaluation);
    }

    protected void fillColumnBand(JRFillBand band, byte evaluation) throws JRException {
        band.evaluate(evaluation);
        JRPrintBand printBand = band.fill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
        if (band.willOverflow() && !band.isSplitAllowed()) {
            this.fillColumnBreak(evaluation, evaluation);
            printBand = band.refill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
        }
        this.fillBand(printBand);
        this.offsetY += printBand.getHeight();
        while (band.willOverflow()) {
            this.fillColumnBreak(evaluation, evaluation);
            printBand = band.fill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
        }
        this.resolveBandBoundElements(band, evaluation);
    }

    protected void fillFixedBand(JRFillBand band, byte evaluation) throws JRException {
        band.evaluate(evaluation);
        JRPrintBand printBand = band.fill();
        this.fillBand(printBand);
        this.offsetY += printBand.getHeight();
        this.resolveBandBoundElements(band, evaluation);
    }

    protected void fillBand(JRPrintBand band) {
        List elements = band.getElements();
        if (elements != null && elements.size() > 0) {
            JRPrintElement element = null;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                element.setX(element.getX() + this.offsetX);
                element.setY(element.getY() + this.offsetY);
                this.printPage.addElement(element);
            }
        }
    }

    private void setNewPageColumnInBands() {
        this.title.setNewPageColumn(true);
        this.pageHeader.setNewPageColumn(true);
        this.columnHeader.setNewPageColumn(true);
        this.detail.setNewPageColumn(true);
        this.columnFooter.setNewPageColumn(true);
        this.pageFooter.setNewPageColumn(true);
        this.lastPageFooter.setNewPageColumn(true);
        this.summary.setNewPageColumn(true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                ((JRFillBand)this.groups[i].getGroupHeader()).setNewPageColumn(true);
                ((JRFillBand)this.groups[i].getGroupFooter()).setNewPageColumn(true);
            }
        }
    }

    private void setNewGroupInBands(JRGroup group) {
        this.title.setNewGroup(group, true);
        this.pageHeader.setNewGroup(group, true);
        this.columnHeader.setNewGroup(group, true);
        this.detail.setNewGroup(group, true);
        this.columnFooter.setNewGroup(group, true);
        this.pageFooter.setNewGroup(group, true);
        this.lastPageFooter.setNewGroup(group, true);
        this.summary.setNewGroup(group, true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                ((JRFillBand)this.groups[i].getGroupHeader()).setNewGroup(group, true);
                ((JRFillBand)this.groups[i].getGroupFooter()).setNewGroup(group, true);
            }
        }
    }

    private JRFillBand getCurrentPageFooter() {
        return this.isLastPageFooter ? this.lastPageFooter : this.pageFooter;
    }

    private void setLastPageFooter(boolean isLastPageFooter) {
        this.isLastPageFooter = isLastPageFooter;
        if (isLastPageFooter) {
            this.columnFooterOffsetY = this.lastPageColumnFooterOffsetY;
        }
    }
}

