/*
 * Decompiled with CFR 0.152.
 */
package com.edb.util;

import com.edb.Driver;
import com.edb.util.GT;
import com.edb.util.PSQLState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;

public class PSQLException
extends SQLException {
    public PSQLException(String msg, PSQLState state, Throwable cause) {
        super(PSQLException.addCauseToMessage(msg, cause), state == null ? null : state.getState());
        this.initCause(cause);
        if (Driver.logDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    public PSQLException(String msg) {
        this(msg, (PSQLState)null, (Throwable)null);
    }

    public PSQLException(String msg, PSQLState state) {
        this(msg, state, null);
    }

    private static String addCauseToMessage(String msg, Throwable cause) {
        boolean hasInitCause = true;
        if (!hasInitCause && cause != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(baos);
                pw.println();
                pw.println(GT.tr("Exception: {0}", cause.toString()));
                pw.println(GT.tr("Stack Trace:"));
                cause.printStackTrace(pw);
                pw.println(GT.tr("End of Stack Trace"));
                pw.flush();
                msg = msg + baos.toString();
                pw.close();
                baos.close();
            }
            catch (IOException ioe) {
                msg = msg + GT.tr("Exception generating stacktrace for: {0} encountered: {1}", new Object[]{cause.toString(), ioe.toString()});
            }
        }
        return msg;
    }
}

