/*
 * Decompiled with CFR 0.152.
 */
package com.edb.util;

import com.edb.Driver;
import com.edb.util.GT;
import java.util.Hashtable;

public class ServerErrorMessage {
    private static final Character SEVERITY = new Character('S');
    private static final Character MESSAGE = new Character('M');
    private static final Character DETAIL = new Character('D');
    private static final Character HINT = new Character('H');
    private static final Character POSITION = new Character('P');
    private static final Character WHERE = new Character('W');
    private static final Character FILE = new Character('F');
    private static final Character LINE = new Character('L');
    private static final Character ROUTINE = new Character('R');
    private static final Character SQLSTATE = new Character('C');
    private Hashtable m_mesgParts;

    public ServerErrorMessage(String p_serverError) {
        char[] l_chars = p_serverError.toCharArray();
        int l_length = l_chars.length;
        this.m_mesgParts = new Hashtable();
        for (int l_pos = 0; l_pos < l_length; ++l_pos) {
            char l_mesgType = l_chars[l_pos];
            if (l_mesgType == '\u0000') continue;
            int l_startString = ++l_pos;
            while (l_chars[l_pos] != '\u0000' && l_pos < l_length) {
                ++l_pos;
            }
            String l_mesgPart = new String(l_chars, l_startString, l_pos - l_startString);
            this.m_mesgParts.put(new Character(l_mesgType), l_mesgPart);
        }
    }

    public String getSQLState() {
        return (String)this.m_mesgParts.get(SQLSTATE);
    }

    public String toString() {
        StringBuffer l_totalMessage = new StringBuffer();
        String l_message = (String)this.m_mesgParts.get(SEVERITY);
        if (l_message != null) {
            l_totalMessage.append(l_message).append(": ");
        }
        if ((l_message = (String)this.m_mesgParts.get(MESSAGE)) != null) {
            l_totalMessage.append(l_message);
        }
        if (Driver.logInfo) {
            l_message = (String)this.m_mesgParts.get(DETAIL);
            if (l_message != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Detail: {0}", l_message));
            }
            if ((l_message = (String)this.m_mesgParts.get(HINT)) != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Hint: {0}", l_message));
            }
            if ((l_message = (String)this.m_mesgParts.get(POSITION)) != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Position: {0}", l_message));
            }
            if ((l_message = (String)this.m_mesgParts.get(WHERE)) != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Where: {0}", l_message));
            }
        }
        if (Driver.logDebug) {
            String l_file = (String)this.m_mesgParts.get(FILE);
            String l_line = (String)this.m_mesgParts.get(LINE);
            String l_routine = (String)this.m_mesgParts.get(ROUTINE);
            if (l_file != null || l_line != null || l_routine != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Location: File: {0}, Routine: {1}, Line: {2}", new Object[]{l_file, l_routine, l_line}));
            }
            if ((l_message = (String)this.m_mesgParts.get(SQLSTATE)) != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Server SQLState: {0}", l_message));
            }
        }
        return l_totalMessage.toString();
    }
}

