package com.enterprisedb.dashboard.agent;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

/**
 * Customf Dashboard R
 * @author usman
 *
 */
public class DashboardResultSetConverter {

	private int records = 0;
	/**
	 * Converts a ResultSet to formatted HTML using following template<br>
	 * <br>
	 * <code>
	 *&nbsp;&lt;table class='layoutMain' border cellpadding='0' cellspacing='0' width='100%' align='center'&gt;<br>
	 *&nbsp;&lt;tr bgcolor='#FFFFFF'&gt;<br>
	 *&nbsp;&lt;td&gt;<br>
	 *&nbsp;&lt;table border='0' cellpadding='2' cellspacing='1' width='100%'&gt;<br>
	 *&nbsp;&nbsp;&nbsp;&nbsp;   &lt;tr class='sectHead'&gt;<br>
	 *&nbsp;&nbsp;&nbsp;&nbsp;    &lt;th>Col1&lt;/th&gt;<br>
	 *&nbsp;&nbsp;&nbsp;&nbsp;    &lt;th>Col2&lt;/th&gt;<br>
	 *&nbsp;&nbsp;&nbsp;&nbsp;    &lt;th>Col3&lt;/th&gt;<br>
	 *&nbsp;&nbsp;&nbsp;    &lt;/tr&gt;<br>
	 * &nbsp;&nbsp;  &lt;tr class='odd'&gt;<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;   &lt;td>Val1&lt;/td&gt;<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;   &lt;td>Val2&lt;/td&gt;<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;   &lt;td>Val3&lt;/td&gt;<br>
	 * &nbsp;&nbsp;&nbsp; &lt;/tr&gt;<br>
	 * &nbsp;&nbsp;&nbsp;  &lt;tr class='even'&gt;<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;   &lt;td>Val4&lt;/td&gt;<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;   &lt;td>Val5&lt;/td&gt;<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;   &lt;td>Val6&lt;/td&gt;<br>
	 * &nbsp;&nbsp;&nbsp;  &lt;/tr&gt;<br>
	 *&nbsp;&lt;/table&gt;<br>
	 *&nbsp;&lt;/td&gt;<br>
	 *&nbsp;&lt;/tr&gt;<br>
	 *&nbsp;&lt;/table&gt;<br>
	 *</code>
	 * Note: ResultSet may not be useable after this method call
	 * @param rs
	 *            ResultSet
	 * @return Formatted resultset in HTML table format
	 * @throws SQLException in case of database error
	 */
	public String formattedResultSet(ResultSet rs) throws SQLException {
		StringBuffer sb = new StringBuffer();
		sb
				.append("<table class='layoutMain' border cellpadding='0' cellspacing='0' width='100%' align='center'>\n");
		sb
				.append("<tr bgcolor='#FFFFFF'>\n<td>\n<table border='0' cellpadding='2' cellspacing='1' width='100%'>\n");
		sb.append("<tr class='sectHead'>\n");
		ResultSetMetaData rsmd = rs.getMetaData();
		for (int i = 1; i <= rsmd.getColumnCount(); i++) {
			sb.append("<th>" + rsmd.getColumnName(i) + "</th>\n");
		}
		sb.append("</tr>\n");
		boolean odd = true;
		while (rs.next()) {
			sb.append("<tr class='" + (odd ? "odd" : "even") + "'>\n");
			odd = !odd;
			for (int i = 1; i <= rsmd.getColumnCount(); i++) {
				Object obj = rs.getObject(i);
				String value = "null";
				if (obj != null) {
					value = obj.toString();
				}
				sb.append("<th>" + value + "</th>\n");
			}
			sb.append("</tr>\n");
			records++;
		}
		sb.append("</table>\n</td>\n</tr>\n</table>");

		return sb.toString();
	}
	
	/**
	 * Returns numbers of records traversed by resultset 
	 * @return
	 */
	public int getRecords(){
		return records;
	}

}
