/**
 * 
 */
package com.enterprisedb.dashboard.agent;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

/**
 * Custom JRDataSource class for Functions reports
 * 
 * @author sarah
 * 
 */
public class FunctionsJRDataSource implements JRDataSource {

	private static final Logger logger = Logger
			.getLogger(FunctionsJRDataSource.class.getName());
	// defaults to 0 - empty
	private int count = 0;

	private static final String DBTYPE_QUERY = "SELECT version();";
	
	// fields...
	private ArrayList functionName = new ArrayList();
	private ArrayList functionLanguage = new ArrayList();
	private ArrayList functionReturnType = new ArrayList();
	private ArrayList functionOwner = new ArrayList();
	private ArrayList functionDefinition = new ArrayList();
	private ArrayList sourceName = new ArrayList();
	private ArrayList reportTime = new ArrayList();
	//private ArrayList isProcedure = new ArrayList();

	/**
	 * Default constructor - initialize fields
	 * 
	 * @param src
	 *            Source object from which to data obtain
	 */
	public FunctionsJRDataSource(Source src, String schema) {
		if (src != null && schema!=null) {
			Connection con = null;
			ResultSet rsVersion = null;
			boolean isEnterpriseDB = true;
			Statement stOuter = null;
			ResultSet rsOuter = null;
			String dbSchema = schema.toUpperCase().trim();
						
			try {
				con = src.getConnection();
				
				Statement stVersion = con.createStatement();
				rsVersion = stVersion.executeQuery(DBTYPE_QUERY);			
				DatabaseMetaData mtDB = con.getMetaData();
				stOuter = con.createStatement();
				String dbVerisonString;
				
				if(!rsVersion.next()){
					rsVersion.close();
					stVersion.close();
					return;
				}else{
					dbVerisonString =  rsVersion.getString(1);
					rsVersion.close();
					stVersion.close();	
				}
				
				isEnterpriseDB = dbVerisonString.toUpperCase().startsWith("ENTERPRISEDB");
				int dbMajorVersion = mtDB.getDatabaseMajorVersion();
				int dbMinorVersion = mtDB.getDatabaseMinorVersion();
									
				String FUNCTIONS_QUERY = "";
				
				//If database is EnterpriseDB 8.1 and above
				if(isEnterpriseDB) {
					if(dbMajorVersion>=8 && dbMinorVersion>=1) {
						//We can directly get the function signature from the funsig column
						FUNCTIONS_QUERY = "SELECT f.funname as profuncname, f.funsig as profuncsig, f.funsrc as profuncsrc,"
							+ " f.funargtypes as argtypes,"
							+ " pg_get_userbyid(funowner) as profuncowner, description, TYP.typname, TYPNS.nspname AS typnsp, lanname"
							+ " FROM pg_function f"
							+ " JOIN pg_type TYP ON TYP.oid=f.funrettype"
							+ " JOIN pg_namespace TYPNS ON TYPNS.oid=f.funnamespace"
							+ " JOIN pg_language LNG ON LNG.oid=funlang"
							+ " LEFT OUTER JOIN pg_description des ON des.objoid=f.oid"
							+ " WHERE UPPER(typname) NOT IN('TRIGGER','LANGUAGE_HANDLER')"
							+ " AND UPPER(nspname) = '" + dbSchema + "'";
						
						rsOuter = stOuter.executeQuery(FUNCTIONS_QUERY);
						
						while(rsOuter.next()) {
							
							StringBuffer funcDefinition = new StringBuffer();
							
							//We need to create the function signature for non EDB-SPL and PL/PGSQL functions
							if(rsOuter.getString("profuncsig").trim().length()==0) {

								funcDefinition.append("CREATE OR REPLACE FUNCTION ");
								funcDefinition.append(rsOuter.getString("profuncname"));
								funcDefinition.append("(");
								
								String[] inFuncDataTypes = rsOuter.getObject("argtypes").toString().split(" ");
								
								//We have a plain function with just in parameters 
								if(inFuncDataTypes!=null && inFuncDataTypes[0].trim().length()>0) {								
									//Create the statement to query about the type against each argument
									Statement stFuncParaDataType = con.createStatement();
									ResultSet rsFuncParaDataType = null;
									
									for(int argCount=0;argCount<inFuncDataTypes.length;argCount++) {
									  //Find the data types for each of the arguments 
									   String dataTypeQuery = "SELECT typname FROM pg_type WHERE oid=" + inFuncDataTypes[argCount];

									   rsFuncParaDataType = stFuncParaDataType.executeQuery(dataTypeQuery.toString());
									   String funcParameterDataType = rsFuncParaDataType.next() ? rsFuncParaDataType.getString(1) : "";
									   funcDefinition.append(funcParameterDataType);
								   
										if(argCount+1!=inFuncDataTypes.length)
											funcDefinition.append(", ");

									}
									if(rsFuncParaDataType!=null) rsFuncParaDataType.close();
									stFuncParaDataType.close();
								}
								funcDefinition.append(")");
								funcDefinition.append(" RETURNS " + rsOuter.getString("typname") + " AS " + "\n");
								funcDefinition.append(rsOuter.getString("profuncsrc"));
							}							
							else {
								funcDefinition.append(rsOuter.getString("profuncsig") + "\n" + rsOuter.getString("profuncsrc").trim());
						   }
							
						sourceName.add(src.getName());
						reportTime.add(new Timestamp(new java.util.Date().getTime()));
						functionName.add(rsOuter.getString("profuncname").trim());
						functionLanguage.add(rsOuter.getString("lanname").trim());
						functionReturnType.add(rsOuter.getString("typname").trim());
						functionOwner.add(rsOuter.getString("profuncowner").trim());
						functionDefinition.add(funcDefinition.toString());
						
						funcDefinition.setLength(0);
						count++;
						
					  }
						rsOuter.close();
						stOuter.close();
					}
					else{
						//We need to construct function signature from the funargdirs,funargnames and funargtypes columns
						FUNCTIONS_QUERY = "SELECT f.funname as profuncname, f.funnargs, f.funsig AS profuncsig, f.funsrc AS profuncsource,"
							+ " f.funargtypes, f.funargnames, f.funargdirs,"
							+ " pg_get_userbyid(funowner) as owner, description, TYP.typname, TYPNS.nspname AS typnsp, lanname"
							+ " FROM pg_function f"
							+ " JOIN pg_type TYP ON TYP.oid=f.funrettype"
							+ " JOIN pg_namespace TYPNS ON TYPNS.oid=f.funnamespace"
							+ " JOIN pg_language LNG ON LNG.oid=funlang"
							+ " LEFT OUTER JOIN pg_description des ON des.objoid=f.oid"
							+ " WHERE UPPER(typname) NOT IN('TRIGGER','LANGUAGE_HANDLER')"
							+ " AND UPPER(nspname) = '" + dbSchema + "'";
						
						rsOuter = stOuter.executeQuery(FUNCTIONS_QUERY);
						//The StringBuffer to contain the final signature that is constructed via funargdirs, funargtypes and funargnames
						StringBuffer funcDefinition = new StringBuffer();

						while(rsOuter.next()) {
							String signature = rsOuter.getString("profuncsig");
							if(signature.trim().equals("-")) {									
								funcDefinition.append("CREATE OR REPLACE FUNCTION ");

								funcDefinition.append(rsOuter.getString("profuncname"));
								funcDefinition.append("(");
						
								String[] funcArgDirections = rsOuter.getObject("funargdirs").toString().split(" ");
			                	String[] funcArgDataTypes = rsOuter.getObject("funargtypes").toString().split(" ");
			                	String[] funcArgNames = rsOuter.getArray("funargnames")!=null ? (String[])rsOuter.getArray("funargnames").getArray() : null;

								//Construct the function signature in case its blank and check that the arrays that its to be constructed from are not null
								if(funcArgDirections.length>0 && funcArgDataTypes.length>0 && funcArgDirections[0].trim().length()>0) {
									
									ResultSet rsFuncParaDataType = null;
				                	Statement stFuncParaDataType = con.createStatement();
				                	
				                	   //Loop through each of the function arguments
									   for(int i=0;i<funcArgDataTypes.length;i++) {
										   String funcParameterDirection = funcArgDirections[i];
										   
										   //SQL and PL/PGSQL Functions can have parameters without any name
										   if(funcArgNames!=null) {
										   	funcDefinition.append(funcArgNames[i] + " ");
										   }
										   
										   String dataTypeQuery = "SELECT typname FROM pg_type WHERE oid=" + funcArgDataTypes[i];
										   
										   rsFuncParaDataType = stFuncParaDataType.executeQuery(dataTypeQuery);
										   String funcParameterDataType = rsFuncParaDataType.next() ? rsFuncParaDataType.getString(1) : "";
										   
											//The parameter direction is stored in the form of an OidVector with parameter directions stored in numeric form
											if(funcParameterDirection.trim().equals("1"))
												funcDefinition.append("IN ");
											else if(funcParameterDirection.trim().equals("2"))
												funcDefinition.append("OUT ");
											else if(funcParameterDirection.trim().equals("3"))
												funcDefinition.append("INOUT ");
											

											funcDefinition.append(funcParameterDataType);
											
											if(i+1!=funcArgDataTypes.length)
												funcDefinition.append(", ");

										   }
										
									   stFuncParaDataType.close();
									   if(rsFuncParaDataType!=null) rsFuncParaDataType.close();
									}
								funcDefinition.append(")");
								funcDefinition.append(" RETURNS " + rsOuter.getString("typname") + " AS ");
							}
							else {
								funcDefinition.append(rsOuter.getString("profuncsig"));
							}
															
							funcDefinition.append(rsOuter.getString("profuncsource"));
							
							sourceName.add(src.getName());
							reportTime.add(new Timestamp(new java.util.Date().getTime()));
							functionName.add(rsOuter.getString("profuncname").trim());
							functionLanguage.add(rsOuter.getString("lanname").trim());
							functionReturnType.add(rsOuter.getString("typname").trim());
							functionOwner.add(rsOuter.getString("owner").trim());
							functionDefinition.add(funcDefinition.toString());
							
							funcDefinition.setLength(0);
							count++;
						}							
						rsOuter.close();
						stOuter.close();
					}
				}
				//The database is PostgreSQL
				else {
					//Check if the version of PostgreSQL is 8.1 and above or not
					 if(dbMajorVersion>=8 && dbMinorVersion>=1) {
					 	FUNCTIONS_QUERY = "SELECT f.proname, LNG.lanname, TYP.typname, TYPNS.nspname, pg_get_userbyid(proowner) as funcowner, "
					 					+ " f.proallargtypes, f.proargmodes, f.proargnames, f.proargtypes, f.prosrc "
										+ " FROM pg_proc f JOIN pg_type TYP ON TYP.oid=f.prorettype" 
										+ " JOIN pg_namespace TYPNS ON TYPNS.oid=f.pronamespace"
										+ " JOIN pg_language LNG ON LNG.oid=f.prolang" 
										+ " JOIN pg_user USR ON USR.usesysid=f.proowner"
										+ " LEFT OUTER JOIN pg_description des ON des.objoid=f.oid" 
										+ " WHERE UPPER(typname) NOT IN ('TRIGGER','LANGUAGE_HANDLER')"
										+ " AND UPPER(nspname) = '" + dbSchema + "'";
					 	
						rsOuter = stOuter.executeQuery(FUNCTIONS_QUERY);
						
						//PostgreSQL 8.1 and above support IN,OUT and INOUT parameter modes					
						while(rsOuter.next()) {
							
							StringBuffer funcDefinition = new StringBuffer();
							
							funcDefinition.append("CREATE OR REPLACE FUNCTION ");
							funcDefinition.append(rsOuter.getString("proname"));
							//Append a bracket to mark the beginning of arguments
							funcDefinition.append("(");

							//Get the Function argument modes stored as a char[]
							String[] funcArgModes = rsOuter.getArray("proargmodes")!=null ? (String[])rsOuter.getArray("proargmodes").getArray() : null;
							//Also get the oid of the argument types stored as an oid[]
							int[] funcArgDataTypes = rsOuter.getArray("proallargtypes")!=null ? (int[])rsOuter.getArray("proallargtypes").getArray() : null;
							//Get the argument names is specified
							String[] funcArgNames = rsOuter.getArray("proargnames")!=null ? (String[])rsOuter.getArray("proargnames").getArray() : null;
							//Get the argument types for plain functions with just an IN parameter direction
							String[] inFuncDataTypes = rsOuter.getObject("proargtypes").toString().split(" ");
						
							ResultSet rsFuncParaDataType = null;
							Statement stFuncParaDataType =  null;
							
							//If we have a function which has arguments
							if(funcArgModes!=null && funcArgDataTypes!=null) {
																
								//Create the statement to query about the type against each argument
								stFuncParaDataType = con.createStatement();
								
								//Loop through the array of returned argument modes and data types against each of those modes
								for(int count = 0; count<funcArgModes.length; count++) {
								
									String funcParameterDirection = funcArgModes[count];
									
									   String dataTypeQuery = "SELECT typname FROM pg_type WHERE oid=" + funcArgDataTypes[count];
									   
									   rsFuncParaDataType = stFuncParaDataType.executeQuery(dataTypeQuery);
									   String funcParameterDataType = rsFuncParaDataType.next() ? rsFuncParaDataType.getString(1) : "";
									   
										//The parameter direction is stored in the form of an OidVector with parameter directions stored in numeric form
										if(funcParameterDirection.trim().equalsIgnoreCase("i"))
											funcDefinition.append("IN");
										else if(funcParameterDirection.trim().equalsIgnoreCase("o"))
											funcDefinition.append("OUT");
										else if(funcParameterDirection.trim().equalsIgnoreCase("b"))
											funcDefinition.append("INOUT");
										
										if(funcArgNames!=null)
											funcDefinition.append(" " + funcArgNames[count]);
										
										funcDefinition.append(" " + funcParameterDataType);
										
										if(count+1==funcArgDataTypes.length)
											funcDefinition.append(")");
										else
											funcDefinition.append(", ");


								}
								rsFuncParaDataType.close();
								stFuncParaDataType.close();
							
							}
							//We have a plain function with just in parameters 
							else if(inFuncDataTypes!=null && inFuncDataTypes[0].trim().length()>0) {								
								//Create the statement to query about the type against each argument
								stFuncParaDataType = con.createStatement();

								for(int argCount=0;argCount<inFuncDataTypes.length;argCount++) {
								  //Find the data types for each of the arguments 
								   String dataTypeQuery = "SELECT typname FROM pg_type WHERE oid=" + inFuncDataTypes[argCount];

								   rsFuncParaDataType = stFuncParaDataType.executeQuery(dataTypeQuery.toString());
								   String funcParameterDataType = rsFuncParaDataType.next() ? rsFuncParaDataType.getString(1) : "";
								   funcDefinition.append(funcParameterDataType);
							   
									if(argCount+1!=inFuncDataTypes.length)
										funcDefinition.append(", ");

								}
								rsFuncParaDataType.close();
								stFuncParaDataType.close();
							}
							funcDefinition.append(")");
							funcDefinition.append(" RETURNS " + rsOuter.getString("typname") + " AS ");
							funcDefinition.append(rsOuter.getString("prosrc").trim());

							sourceName.add(src.getName());
							reportTime.add(new Timestamp(new java.util.Date().getTime()));
							functionName.add(rsOuter.getString("proname").trim());
							functionLanguage.add(rsOuter.getString("lanname").trim());
							functionReturnType.add(rsOuter.getString("typname").trim());
							functionOwner.add(rsOuter.getString("funcowner").trim());
							functionDefinition.add(funcDefinition.toString());
							
							funcDefinition.setLength(0);
							count++;
						}
						rsOuter.close();
						stOuter.close();
						
				 }
					 //The database is PostgreSQL 8.0 and below
					else 
					{
						FUNCTIONS_QUERY = "SELECT f.proname, LNG.lanname, TYP.typname, TYPNS.nspname, pg_get_userbyid(proowner) as funcowner, "
	 					+ " f.proargnames, f.proargtypes, f.prosrc "
						+ " FROM pg_proc f JOIN pg_type TYP ON TYP.oid=f.prorettype" 
						+ " JOIN pg_namespace TYPNS ON TYPNS.oid=f.pronamespace"
						+ " JOIN pg_language LNG ON LNG.oid=f.prolang" 
						+ " JOIN pg_user USR ON USR.usesysid=f.proowner"
						+ " LEFT OUTER JOIN pg_description des ON des.objoid=f.oid" 
						+ " WHERE UPPER(typname) NOT IN ('TRIGGER','LANGUAGE_HANDLER')"
						+ " AND UPPER(nspname)  = '" + dbSchema + "'";
		 	
					 	rsOuter = stOuter.executeQuery(FUNCTIONS_QUERY);

						while(rsOuter.next()) {
							
							StringBuffer funcDefinition = new StringBuffer();
							
							funcDefinition.append("CREATE OR REPLACE FUNCTION ");
							funcDefinition.append(rsOuter.getString("proname"));
							//Append a bracket to mark the beginning of arguments
							funcDefinition.append("(");

							//TODO: Check if argument names are used with PostgreSQL 8.0 and below
							//Get the argument names is specified
							String[] funcArgNames = rsOuter.getArray("proargnames")!=null ? (String[])rsOuter.getArray("proargnames").getArray() : null;
							//Get the argument types for plain functions with just an IN parameter direction
							String[] funcDataTypes = rsOuter.getObject("proargtypes").toString().split(" ");
						
							ResultSet rsFuncParaDataType = null;
							Statement stFuncParaDataType =  null;
							
							
							if(funcDataTypes!=null && funcDataTypes[0].trim().length()>0) {								
								//Create the statement to query about the type against each argument
								stFuncParaDataType = con.createStatement();

								for(int argCount=0;argCount<funcDataTypes.length;argCount++) {
								  //Find the data types for each of the arguments 
								   String dataTypeQuery = "SELECT typname FROM pg_type WHERE oid=" + funcDataTypes[argCount];

								   rsFuncParaDataType = stFuncParaDataType.executeQuery(dataTypeQuery.toString());
								   String funcParameterDataType = rsFuncParaDataType.next() ? rsFuncParaDataType.getString(1) : "";
								   funcDefinition.append(funcParameterDataType);
							   
									if(argCount+1!=funcDataTypes.length)
										funcDefinition.append(", ");

								}								
								rsFuncParaDataType.close();
								stFuncParaDataType.close();
							}
							
							funcDefinition.append(")");
							funcDefinition.append(" RETURNS " + rsOuter.getString("typname") + " AS ");
							funcDefinition.append(rsOuter.getString("prosrc"));

							sourceName.add(src.getName());
							reportTime.add(new Timestamp(new java.util.Date().getTime()));
							functionName.add(rsOuter.getString("proname").trim());
							functionLanguage.add(rsOuter.getString("lanname").trim());
							functionReturnType.add(rsOuter.getString("typname").trim());
							functionOwner.add(rsOuter.getString("funcowner").trim());
							functionDefinition.add(funcDefinition.toString());
							
							funcDefinition.setLength(0);
							count++;

						}
						rsOuter.close();
						stOuter.close();
						
					  }
				}
			} catch (SQLException sqe) {
				logger.log(Level.SEVERE, sqe.getMessage(), sqe);
				sqe.printStackTrace();
			} finally {
				if (con != null) {
					try {
						con.close();
					} catch (SQLException sqe) {
						logger.log(Level.SEVERE, sqe.getMessage(), sqe);
					}
				}
			}

		}
	}
	/**
	 * @return Returns the counter.
	 */
	public int getCount() {
		return count;
	}

	/**
	 * @param count
	 *            The counter to set.
	 */
	public void setCount(int count) {
		this.count = count;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.jasperreports.engine.JRDataSource#next()
	 */
	public boolean next() throws JRException {
		if (count > 0) {
			count--;
			return true;
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.jasperreports.engine.JRDataSource#getFieldValue(net.sf.jasperreports.engine.JRField)
	 */
	public Object getFieldValue(JRField field) throws JRException {
		if (field.getName().equals("source")) {
			return this.sourceName.get(count);
		} else if (field.getName().equals("owner")) {
			return this.functionOwner.get(count); 
		} else if (field.getName().equals("funcName")) {
			return this.functionName.get(count);
		} else if (field.getName().equals("funcLanguage")) {
			return this.functionLanguage.get(count);
		} else if (field.getName().equals("funcDefinition")) {
			return this.functionDefinition.get(count);
		} else if (field.getName().equals("report_time")) {
			return this.reportTime.get(count);
		}
		return null;
	}

}
