/**
 * 
 */
package com.enterprisedb.dashboard.agent;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

/**
 * Custom JRDataSource class for Indexes Report
 * 
 * @author Sarah
 * @version Build 9 
 * @converting this report to JR Data Source due to table size
 * 
 */
public class IndexesJRDataSource implements JRDataSource {

	private static final Logger logger = Logger
			.getLogger(TableInfoJRDataSource.class.getName());
	// defaults to 0 - empty
	private int count = 0;

	// fields...
	private ArrayList tableName = new ArrayList();
	private ArrayList indexName = new ArrayList();
	private ArrayList indexDefinition = new ArrayList();
	private ArrayList rowCount = new ArrayList();
	private ArrayList indexSize = new ArrayList();
	private ArrayList sourceName = new ArrayList();	
	private ArrayList reportTime = new ArrayList();
	/**
	 * Default constructor - initialize fields
	 * 
	 * @param src
	 *            Source object from which to data obtain
	 */
	public IndexesJRDataSource(Source src, String schema) {

		
		if (src != null && schema!=null) {

			Connection con = null;
			String dbSchema = schema.toUpperCase().trim();
			
			String OUTER_QUERY 	= 	"SELECT c.reltuples::int8,tablename,indexname,indexdef" 
								+	" FROM pg_catalog.pg_indexes p, pg_class c"
								+	" WHERE UPPER(schemaname) = '" + dbSchema + "'"
								+	" AND c.relname = p.tablename "
								+	" AND c.relnamespace = (select oid from pg_namespace where nspname = '"+ schema + "')"
								+ 	" AND UPPER(schemaname) NOT IN('PG_CATALOG','INFORMATION_SCHEMA','SYS','DBO','PG_TOAST')"
								+	" AND UPPER(schemaname) NOT LIKE 'PG_TEMP%'"
								+	" Order by tablename DESC,Indexname DESC";
					
			try {
				con = src.getConnection();
				// step 1: Outer query
				Statement stOuter = con.createStatement();
				ResultSet rsOuter = stOuter.executeQuery(OUTER_QUERY);
				
				while (rsOuter.next()) {
					
					sourceName.add(src.getName());
					reportTime.add(new Timestamp(new java.util.Date().getTime()));
					tableName.add(rsOuter.getString("tablename").trim());
					indexName.add(rsOuter.getString("indexname").trim());
					indexDefinition.add(rsOuter.getString("indexdef").trim());
					rowCount.add(new Long(rsOuter.getLong("reltuples")));

					// Step 2: Check if the table size is available
					for (int i = 0; i < indexName.size(); i++) {
						Statement stIsIndexSizeAvailable = con.createStatement();
						ResultSet rsIsIndexSizeAvailable = stIsIndexSizeAvailable.executeQuery("SELECT * FROM pg_proc WHERE proname = 'pg_total_relation_size'");
						if(rsIsIndexSizeAvailable.next()) {
							ResultSet rsTableSize = stIsIndexSizeAvailable.executeQuery("SELECT pg_size_pretty(pg_total_relation_size('"+ schema + "."+ rsOuter.getString("indexname").trim() + "')) AS index_size");
							if(rsTableSize.next()) {
								indexSize.add(rsTableSize.getString("index_size"));
							}
						}
						else {
							indexSize.add("Not Available");
						}
						stIsIndexSizeAvailable.close();
						rsIsIndexSizeAvailable.close();
						if(rsIsIndexSizeAvailable!=null) {
							rsIsIndexSizeAvailable.close();
						}
					}
				count++;
				}
				rsOuter.close();
				stOuter.close();	
			} catch (SQLException sqe) {
				logger.log(Level.SEVERE, sqe.getMessage(), sqe);
			} finally {
				if (con != null) {
					try {
						con.close();
					} catch (SQLException sqe) {
						logger.log(Level.SEVERE, sqe.getMessage(), sqe);
					}
				}
			}

		}
	}
	/**
	 * @return Returns the counter.
	 */
	public int getCount() {
		return count;
	}

	/**
	 * @param count
	 *            The counter to set.
	 */
	public void setCount(int count) {
		this.count = count;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.jasperreports.engine.JRDataSource#next()
	 */
	public boolean next() throws JRException {
		if (count > 0) {
			count--;
			return true;
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.jasperreports.engine.JRDataSource#getFieldValue(net.sf.jasperreports.engine.JRField)
	 */
	public Object getFieldValue(JRField field) throws JRException {
		if (field.getName().equals("tablename")) {
			return this.tableName.get(count);
		} else if (field.getName().equals("indexname")) {
			return this.indexName.get(count);
		} else if (field.getName().equals("source")) {
			return this.sourceName.get(count);
		} else if (field.getName().equals("report_time")) {
			return this.reportTime.get(count);			
		} else if (field.getName().equals("indexdef")) {
			return this.indexDefinition.get(count);
		} else if (field.getName().equals("row_count")) {
			return this.rowCount.get(count);
		} else if (field.getName().equals("index_size")) {
			return this.indexSize.get(count);
		}

		return null;
	}

}
