/**
 * 
 */
package com.enterprisedb.dashboard.agent;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

/**
 * Custom JRDataSource class for Sequences reports
 * 
 * @author usman
 * 
 */
public class SequencesJRDataSource implements JRDataSource {

	private static final Logger logger = Logger
			.getLogger(SequencesJRDataSource.class.getName());
	// defaults to 0 - empty
	private int count = 0;

	// fields...
	private ArrayList schemaName = new ArrayList();
	private ArrayList sequenceName = new ArrayList();
	private ArrayList last_value = new ArrayList();
	private ArrayList increment_by = new ArrayList();
	private ArrayList max_value = new ArrayList();
	private ArrayList min_value = new ArrayList();
	private ArrayList cache_value = new ArrayList();
	private ArrayList is_cycled = new ArrayList();
	private ArrayList sourceName = new ArrayList();
	private ArrayList reportTime = new ArrayList();
	/**
	 * Default constructor - initialize fields
	 * 
	 * @param src
	 *            Source object from which to data obtain
	 */
	public SequencesJRDataSource(Source src, String schema) {
				
		if (src != null && schema!=null) {
			Connection con = null;
			String dbSchema = schema.toUpperCase().trim();
			
			String OUTER_QUERY = "SELECT * FROM"
				+ " pg_class JOIN pg_namespace ON pg_namespace.oid = pg_class.relnamespace"
				+ " WHERE relkind='S' AND UPPER(nspname) = '" + dbSchema + "'"
				+ " AND UPPER(relname) NOT LIKE '__SYS%'" + " order by relname desc" ;
		
			
			try {
				con = src.getConnection();
				// step 1: Outer query
				Statement stOuter = con.createStatement();
				ResultSet rsOuter = stOuter.executeQuery(OUTER_QUERY);
				while (rsOuter.next()) {

					sourceName.add(src.getName());
					reportTime
							.add(new Timestamp(new java.util.Date().getTime()));
					sequenceName.add(rsOuter.getString("relname").trim());
					schemaName.add(rsOuter.getString("nspname").trim());
					count++;
				}

				rsOuter.close();
				stOuter.close();

				// Step 2: Get sequence specific informaion
				for (int i = 0; i < sequenceName.size(); i++) {
					Statement stInner = con.createStatement();
					ResultSet rsInner = stInner.executeQuery("select * from "
							+ schemaName.get(i) + "." + sequenceName.get(i));
					if (rsInner.next()) {
						last_value.add(new Long(rsInner.getLong("last_value")));
						increment_by.add(new Long(rsInner
								.getLong("increment_by")));
						max_value.add(new Long(rsInner.getLong("max_value")));
						min_value.add(new Long(rsInner.getLong("min_value")));
						cache_value
								.add(new Long(rsInner.getLong("cache_value")));
						is_cycled.add(new Boolean(rsInner
								.getBoolean("is_cycled")));
					} else {
						last_value.add(new Long(-1));
						increment_by.add(new Long(-1));
						max_value.add(new Long(-1));
						min_value.add(new Long(-1));
						cache_value.add(new Long(-1));
						is_cycled.add(new Boolean("false"));
					}
					rsInner.close();
					stInner.close();
				}

			} catch (SQLException sqe) {
				logger.log(Level.SEVERE, sqe.getMessage(), sqe);
			} finally {
				if (con != null) {
					try {
						con.close();
					} catch (SQLException sqe) {
						logger.log(Level.SEVERE, sqe.getMessage(), sqe);
					}
				}
			}

		}
	}
	/**
	 * @return Returns the counter.
	 */
	public int getCount() {
		return count;
	}

	/**
	 * @param count
	 *            The counter to set.
	 */
	public void setCount(int count) {
		this.count = count;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.jasperreports.engine.JRDataSource#next()
	 */
	public boolean next() throws JRException {
		if (count > 0) {
			count--;
			return true;
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.jasperreports.engine.JRDataSource#getFieldValue(net.sf.jasperreports.engine.JRField)
	 */
	public Object getFieldValue(JRField field) throws JRException {
		if (field.getName().equals("cache_value")) {
			return this.cache_value.get(count);
		} else if (field.getName().equals("increment_by")) {
			return this.increment_by.get(count);
		} else if (field.getName().equals("source")) {
			return this.sourceName.get(count);
		} else if (field.getName().equals("is_cycled")) {
			return this.is_cycled.get(count);
		} else if (field.getName().equals("last_value")) {
			return this.last_value.get(count);
		} else if (field.getName().equals("max_value")) {
			return this.max_value.get(count);
		} else if (field.getName().equals("min_value")) {
			return this.min_value.get(count);
		} else if (field.getName().equals("report_time")) {
			return this.reportTime.get(count);
		} else if (field.getName().equals("schema_name")) {
			return this.schemaName.get(count);
		} else if (field.getName().equals("sequence_name")) {
			return this.sequenceName.get(count);
		}

		return null;
	}

}
